/*
 * Decompiled with CFR 0.152.
 */
package byfr0n.gamemodedetector.modmenu;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public boolean enableSound = true;
    public boolean visualNotification = true;
    public boolean chatNotification = true;
    public boolean debugLogs = true;
    public boolean ignoreLocalPlayer = false;
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "gamemodedetector/config.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public void save() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Config load() {
        if (CONFIG_FILE.exists()) {
            Config config;
            FileReader reader = new FileReader(CONFIG_FILE);
            try {
                config = (Config)GSON.fromJson((Reader)reader, Config.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            reader.close();
            return config;
        }
        return new Config();
    }
}

