/*
 * Decompiled with CFR 0.152.
 */
package byfr0n.gamemodedetector.rendering;

import byfr0n.gamemodedetector.Gamemodedetector;
import byfr0n.gamemodedetector.notification.ScreenNotification;
import byfr0n.gamemodedetector.utils.TweenUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class NotificationRenderer {
    private static final List<ScreenNotification> activeNotifications = new ArrayList<ScreenNotification>();
    private static final int NOTIFICATION_DURATION = 5000;
    private static final int NOTIFICATION_ANIMATION_DURATION = 500;
    private static final int NOTIFICATION_HEIGHT = 12;
    private static final int NOTIFICATION_SPACING = 5;
    private static final class_310 client = class_310.method_1551();

    public static void addNotification(String message) {
        activeNotifications.add(new ScreenNotification(message, System.currentTimeMillis()));
    }

    public static void render(class_332 context) {
        if (NotificationRenderer.client.field_1724 == null) {
            return;
        }
        if (!Gamemodedetector.CONFIG.visualNotification) {
            return;
        }
        int y = 20;
        long currentTime = System.currentTimeMillis();
        activeNotifications.removeIf(notification -> currentTime - notification.getStartTime() > 5000L);
        for (ScreenNotification notification2 : activeNotifications) {
            long timeSinceStart = currentTime - notification2.getStartTime();
            float alpha = NotificationRenderer.getAlpha(timeSinceStart);
            int x = (int)TweenUtils.ease(TweenUtils.Easing.QUAD_OUT, Math.min(timeSinceStart, 500L), -100.0f, 110.0f, 500.0f);
            int color = (int)(alpha * 255.0f) << 24 | 0xFFFFFF;
            context.method_51433(NotificationRenderer.client.field_1772, notification2.getMessage(), x, y, color, true);
            y += 17;
        }
    }

    private static float getAlpha(long timeSinceStart) {
        float alpha = 1.0f;
        if (timeSinceStart < 500L) {
            alpha = TweenUtils.ease(TweenUtils.Easing.QUAD_OUT, timeSinceStart, 0.0f, 1.0f, 500.0f);
        } else if (timeSinceStart > 4500L) {
            alpha = TweenUtils.ease(TweenUtils.Easing.QUAD_IN, timeSinceStart - 4500L, 1.0f, -1.0f, 500.0f);
        }
        return alpha;
    }
}

