/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept_delights.core;

import com.rosemods.windswept_delights.core.data.client.WDLanguageProvider;
import com.rosemods.windswept_delights.core.data.client.WDModelProvider;
import com.rosemods.windswept_delights.core.data.server.WDLootTableProvider;
import com.rosemods.windswept_delights.core.data.server.WDRecipeProvider;
import com.rosemods.windswept_delights.core.data.server.tags.WDBlockTagProvider;
import com.rosemods.windswept_delights.core.data.server.tags.WDItemTagProvider;
import com.rosemods.windswept_delights.core.other.WDCreativeTabs;
import com.rosemods.windswept_delights.core.other.WDFoods;
import com.rosemods.windswept_delights.core.registry.WDItems;
import com.teamabnormals.blueprint.core.util.DataUtil;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="windswept_delights")
public class WindsweptDelights {
    public static final String MOD_ID = "windswept_delights";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("windswept_delights");

    public WindsweptDelights() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRY_HELPER.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::dataSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            WDCreativeTabs.setupTabEditors();
            WDFoods.modifyFoodValues();
            DataUtil.registerCompostable((ItemLike)((ItemLike)WDItems.CHRISTMAS_PUDDING_SLICE.get()), (float)0.85f);
        });
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        boolean client = event.includeClient();
        boolean server = event.includeServer();
        gen.addProvider(client, (DataProvider)new WDLanguageProvider(event));
        gen.addProvider(client, (DataProvider)new WDModelProvider(event));
        WDBlockTagProvider blockTags = new WDBlockTagProvider(event);
        gen.addProvider(server, (DataProvider)blockTags);
        gen.addProvider(server, (DataProvider)new WDItemTagProvider(event, blockTags));
        gen.addProvider(server, (DataProvider)new WDRecipeProvider(event));
        gen.addProvider(server, (DataProvider)new WDLootTableProvider(event));
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

