/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.chattransform.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class TransformStart {
    private boolean available = false;
    private int value = -1;
    private boolean hasPrevious = false;
    private int previous = -1;
    private long previousTime;

    public void clear() {
        this.available = false;
        this.hasPrevious = false;
    }

    public void set(int value) {
        if (this.available) {
            this.previous = this.value;
            this.previousTime = System.currentTimeMillis();
            this.hasPrevious = true;
        } else {
            this.available = true;
        }
        if (value < 0) {
            value = 0;
        }
        this.value = value;
    }

    public int get() {
        if (!this.available) {
            throw new IllegalStateException("TransformStart is not set");
        }
        return this.value;
    }

    public void increment() {
        this.set(this.get() + 1);
    }

    public boolean isAvailable() {
        return this.available;
    }

    public boolean hasPrevious() {
        return this.hasPrevious;
    }

    public int getPrevious() {
        if (!this.hasPrevious) {
            throw new IllegalStateException("TransformStart has no previous");
        }
        return this.previous;
    }

    public boolean showPrevious() {
        return this.hasPrevious() && this.previousTime >= System.currentTimeMillis() - 500L;
    }
}

