/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.chattransform;

import io.gitlab.jfronny.chattransform.Cfg;
import io.gitlab.jfronny.chattransform.ChatTransform;
import io.gitlab.jfronny.chattransform.JapaneseMap;
import io.gitlab.jfronny.commons.data.String2ObjectMap;
import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.commons.serialize.SerializeWriter;
import io.gitlab.jfronny.commons.serialize.databind.api.TypeAdapter;
import io.gitlab.jfronny.commons.serialize.databind.api.TypeToken;
import io.gitlab.jfronny.commons.serialize.json.JsonReader;
import io.gitlab.jfronny.commons.serialize.json.JsonWriter;
import io.gitlab.jfronny.commons.throwable.ThrowingFunction;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigHolder;
import io.gitlab.jfronny.libjf.config.api.v2.Naming;
import io.gitlab.jfronny.libjf.config.api.v2.dsl.CategoryBuilder;
import io.gitlab.jfronny.libjf.config.api.v2.dsl.ConfigBuilder;
import io.gitlab.jfronny.libjf.config.api.v2.dsl.Migration;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;

public class ConfigTweaker {
    private static final Path dir = FabricLoader.getInstance().getConfigDir().resolve("chat-transform");
    private static final TypeAdapter<String2ObjectMap<String>> substitutionsAdapter = LibJf.MAPPER.getAdapter((TypeToken)new TypeToken<String2ObjectMap<String>>(){});
    private static final Path path = dir.resolve("config.json");

    public static ConfigBuilder<?> tweak(ConfigBuilder<?> builder) {
        return ((ConfigBuilder)builder.addMigration("substitutions", Migration.of(reader -> {
            Cfg.General.substitutions = (String2ObjectMap)substitutionsAdapter.deserialize(reader);
        }))).setPath(path);
    }

    static {
        try {
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
                General.writeDefaultPresets();
            }
        }
        catch (IOException e) {
            ChatTransform.LOG.error("Failed to create config directory", (Throwable)e);
        }
        ConfigHolder.getInstance().migrateFiles("chat-transform");
        Path oldPath = FabricLoader.getInstance().getConfigDir().resolve("chat-transform.json5");
        if (!Files.exists(path, new LinkOption[0]) && Files.exists(oldPath, new LinkOption[0])) {
            try {
                Files.move(oldPath, path, new CopyOption[0]);
            }
            catch (IOException e) {
                ChatTransform.LOG.error("Failed to move config file", (Throwable)e);
            }
        }
    }

    public static class General {
        private static final char[] consonants = "bcdfghjklmprstwz".toCharArray();

        private static <TEx extends Exception, Writer extends SerializeWriter<TEx, Writer>> Writer owo(Writer writer) throws TEx {
            writer.name("r").value("w");
            writer.name("l").value("w");
            writer.name("R").value("W");
            writer.name("L").value("W");
            writer.name("no").value("nu");
            writer.name("has").value("haz");
            writer.name("have").value("haz");
            writer.name("you").value("uu");
            writer.name("the ").value("da ");
            writer.name("The ").value("Da ");
            writer.name("This").value("Dis");
            writer.name("this").value("dis");
            writer.name("That").value("Dat");
            writer.name("that").value("dat");
            return writer;
        }

        private static <TEx extends Exception, Writer extends SerializeWriter<TEx, Writer>> Writer katakana(Writer writer) throws TEx {
            writer.name("-").value("\u30fc");
            for (char c : consonants) {
                writer.name("" + c + c).value("\u30c3" + c);
            }
            writer.name("nn").value("\u30f3");
            JapaneseMap.fromTable("\ta\ti\tu\te\to\tn\n\t\u30a2\t\u30a4\t\u30a6\t\u30a8\t\u30aa\t\u30f3\nx\t\u30a1\t\u30a3\t\u30a5\t\u30a7\t\u30a9\nk\t\u30ab\t\u30ad\t\u30af\t\u30b1\t\u30b3\nky\t\u30ad\u30e3\t\t\u30ad\u30e5\t\t\u30ad\u30e7\ns\t\u30b5\t\t\u30b9\t\u30bb\t\u30bd\nsh\t\u30b7\u30e3\t\u30b7\t\u30b7\u30e5\t\u30b7\u30a7\t\u30b7\u30e7\nt\t\u30bf\t\u30c6\u30a3\t\u30c4\t\u30c6\t\u30c8\nts\t\t\t\u30c4\nch\t\u30c1\u30e3\t\u30c1\t\u30c1\u30e5\t\u30c1\u30a7\t\u30c1\u30e7\nn\t\u30ca\t\u30cb\t\u30cc\t\u30cd\t\u30ce\nny\t\u30cb\u30e3\t\t\u30cb\u30e5\t\t\u30cb\u30e7\nh\t\u30cf\t\u30d2\t\u30d5\t\u30d8\t\u30db\nhy\t\u30d2\u30e3\t\t\u30d2\u30e5\t\t\u30d2\u30e7\nf\t\u30d5\u30a1\t\u30d5\u30a3\t\u30d5\t\u30d5\u30a7\t\u30d5\u30a9\nm\t\u30de\t\u30df\t\u30e0\t\u30e1\t\u30e2\nmy\t\u30df\u30e3\t\t\u30df\u30e5\t\t\u30df\u30e7\ny\t\u30e4\t\t\u30e6\t\t\u30e8\nr\t\u30e9\t\u30ea\t\u30eb\t\u30ec\t\u30ed\nry\t\u30ea\u30e3\t\u30ea\u30a3\t\u30ea\u30e5\t\u30ea\u30a7\t\u30ea\u30e7\nw\t\u30ef\t\u30a6\u30a3\t\t\u30a6\u30a7\t\u30f2\ng\t\u30ac\t\u30ae\t\u30b0\t\u30b2\t\u30b4\ngy\t\u30ae\u30e3\t\t\u30ae\u30e5\t\t\u30ae\u30e7\nz\t\u30b6\t\t\u30ba\t\u30bc\t\u30be/\u30c2\u30e7\nj\t\u30b8\u30e3/\u30c2\u30e3\t\u30b8/\u30c2\t\u30b8\u30e5/\u30c2\u30e5\t\u30b8\u30a7\t\u30b8\u30e7\nd\t\u30c0\t\t\u30c5\t\u30c7\t\u30c9\nb\t\u30d0\t\u30d3\t\u30d6\t\u30d9\t\u30dc\nby\t\u30d3\u30e3\t\t\u30d3\u30e5\t\t\u30d3\u30e7\np\t\u30d1\t\u30d4\t\u30d7\t\u30da\t\u30dd\npy\t\u30d4\u30e3\t\t\u30d4\u30e5\t\t\u30d4\u30e7\nv\t\t\t\u3094", (k, v) -> writer.name(k).value(v));
            return writer;
        }

        private static <TEx extends Exception, Writer extends SerializeWriter<TEx, Writer>> Writer hiragana(Writer writer) throws TEx {
            writer.name("-").value("\u30fc");
            for (char c : consonants) {
                writer.name("" + c + c).value("\u3063" + c);
            }
            writer.name("nn").value("\u3093");
            JapaneseMap.fromTable("\ta\ti\tu\te\to\tn\n\t\u3042\t\u3044\t\u3046\t\u3048\t\u304a\t\u3093\nx\t\u3041\t\u3043\t\u3045\t\u3047\t\u3049\nk\t\u304b\t\u304d\t\u304f\t\u3051\t\u3053\nky\t\u304d\u3083\t\t\u304d\u3085\t\t\u304d\u3087\ns\t\u3055\t\t\u3059\t\u305b\t\u305d\nsh\t\u3057\u3083\t\u3057\t\u3057\u3085\t\t\u3057\u3087\nt\t\u305f\t\t\u3064\t\u3066\t\u3068\nts\t\t\t\u3064\nch\t\u3061\u3083\t\u3061\t\u3061\u3085\t\u3061\u3047\t\u3061\u3087\nn\t\u306a\t\u306b\t\u306c\t\u306d\t\u306e\nny\t\u306b\u3083\t\t\u306b\u3085\t\t\u306b\u3087\nh\t\u306f\t\u3072\t\u3075\t\u3078\t\u307b\nhy\t\u3072\u3083\t\t\u3072\u3085\t\t\u3072\u3087\nf\t\t\t\u3075\nm\t\u307e\t\u307f\t\u3080\t\u3081\t\u3082\nmy\t\u307f\u3083\t\t\u307f\u3085\t\t\u307f\u3087\ny\t\u3084\t\t\u3086\t\t\u3088\nr\t\u3089\t\u308a\t\u308b\t\u308c\t\u308d\nry\t\u308a\u3083\t\u308a\u3043\t\u308a\u3085\t\u308a\u3047\t\u308a\u3087\nw\t\u308f\t\u3090\t\t\u3091\t\u3092\ng\t\u304c\t\u304e\t\u3050\t\u3052\t\u3054\ngy\t\u304e\u3083\t\t\u304e\u3085\t\t\u304e\u3087\nz\t\u3056\t\t\u305a\t\u305c\t\u305e/\u3062\u3087\nj\t\u3058\u3083/\u3062\u3083\t\u3058/\u3062\t\u3058\u3085/\u3062\u3085\t\t\u3058\u3087\nd\t\u3060\t\t\u3065\t\u3067\t\u3069\nb\t\u3070\t\u3073\t\u3076\t\u3079\t\u307c\nby\t\u3073\u3083\t\t\u3073\u3085\t\t\u3073\u3087\np\t\u3071\t\u3074\t\u3077\t\u307a\t\u307d\npy\t\u3074\u3083\t\t\u3074\u3085\t\t\u3074\u3087\nv\t\t\t\u3094", (k, v) -> writer.name(k).value(v));
            return writer;
        }

        private static void write(String name, ThrowingFunction<JsonWriter, JsonWriter, IOException> generate) {
            try (BufferedWriter writer = Files.newBufferedWriter(dir.resolve(name + ".preset.json"), new OpenOption[0]);
                 JsonWriter jw = LibJf.LENIENT_TRANSPORT.createWriter((Writer)writer);){
                ((JsonWriter)generate.apply((Object)jw.beginObject())).endObject();
            }
            catch (IOException e) {
                ChatTransform.LOG.error("Failed to save preset " + name, (Throwable)e);
            }
        }

        public static void writeDefaultPresets() {
            General.write("owo", (ThrowingFunction<JsonWriter, JsonWriter, IOException>)((ThrowingFunction)General::owo));
            General.write("katakana", (ThrowingFunction<JsonWriter, JsonWriter, IOException>)((ThrowingFunction)General::katakana));
            General.write("hiragana", (ThrowingFunction<JsonWriter, JsonWriter, IOException>)((ThrowingFunction)General::hiragana));
        }

        public static CategoryBuilder<?> tweak(CategoryBuilder<?> builder) {
            try (Stream<Path> possible = Files.list(dir);){
                possible.filter(path -> path.getFileName().toString().endsWith(".preset.json")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> builder.addPreset(path.getFileName().toString().replace(".preset.json", ""), () -> {
                    try (BufferedReader isr = Files.newBufferedReader(path);
                         JsonReader jsr = LibJf.LENIENT_TRANSPORT.createReader((Reader)isr);){
                        Cfg.General.substitutions = (String2ObjectMap)substitutionsAdapter.deserialize((SerializeReader)jsr);
                    }
                    catch (IOException e) {
                        ChatTransform.LOG.error("Failed to load preset " + String.valueOf(path), (Throwable)e);
                    }
                }));
            }
            catch (IOException e) {
                ChatTransform.LOG.error("Failed to load presets", (Throwable)e);
            }
            return builder;
        }
    }

    public static class CNaming
    extends Naming.Delegate
    implements Naming.Custom {
        public CNaming() {
            super("chat-transform");
        }

        public String getId() {
            return "chat-transform";
        }

        public Naming category(String name) {
            Naming dlg = this.delegate.category(name);
            if (name.equals("general")) {
                return new Naming.Delegate(this, dlg){

                    public class_2561 preset(String name) {
                        return class_2561.method_48321((String)("chat-transform.jfconfig." + name), (String)name);
                    }
                };
            }
            return dlg;
        }
    }
}

