/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.chattransform.client.mixin;

import io.gitlab.jfronny.chattransform.Cfg;
import io.gitlab.jfronny.chattransform.ChatTransform;
import io.gitlab.jfronny.chattransform.client.ITextFieldWidget;
import io.gitlab.jfronny.chattransform.client.Substitution;
import io.gitlab.jfronny.chattransform.client.TransformStart;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_342.class})
public abstract class TextFieldWidgetMixin
extends class_339
implements ITextFieldWidget {
    @Shadow
    private String field_2092;
    @Shadow
    private int field_2102;
    @Shadow
    private int field_2101;
    @Shadow
    private boolean field_2095;
    @Shadow
    private Predicate<String> field_2104;
    @Shadow
    @Final
    private class_327 field_2105;
    @Unique
    private boolean chattransform$active = false;
    @Unique
    private boolean chattransform$shouldTransform = false;
    @Unique
    private final TransformStart transformStart = new TransformStart();
    @Unique
    private Substitution lastSubstitution = null;

    public TextFieldWidgetMixin(int x, int y, int width, int height, class_2561 message) {
        super(x, y, width, height, message);
    }

    @Shadow
    public abstract String method_1882();

    @Shadow
    public abstract int method_1889(int var1);

    @Shadow
    public abstract boolean method_1885();

    @Shadow
    public abstract void method_1883(int var1, boolean var2);

    @Override
    public void chattransform$activate() {
        this.chattransform$active = true;
        ChatTransform.LOG.info("Activated widget " + String.valueOf(this), new Object[0]);
    }

    @Redirect(method={"write(Ljava/lang/String;)V"}, at=@At(value="FIELD", target="Lnet/minecraft/client/gui/widget/TextFieldWidget;text:Ljava/lang/String;", opcode=181))
    void transformBeforeWrite(class_342 instance, String value, String tx) {
        if (this.chattransform$active) {
            if (this.field_2102 == this.field_2101 && tx.length() == 1 && !class_310.method_1551().method_74189() && !this.method_1882().startsWith("/")) {
                this.chattransform$shouldTransform = true;
            } else {
                this.transformStart.clear();
            }
        }
        this.field_2092 = value;
    }

    @Inject(method={"write(Ljava/lang/String;)V"}, at={@At(value="TAIL")})
    void transformAfterWrite(String text, CallbackInfo ci) {
        if (this.chattransform$shouldTransform) {
            this.chattransform$shouldTransform = false;
            this.transform();
        }
    }

    @Inject(method={"setCursor(IZ)V"}, at={@At(value="TAIL")})
    void updateStartOnSetCursor(int cursor, boolean shiftKeyPressed, CallbackInfo ci) {
        this.transformStart.clear();
        this.lastSubstitution = null;
    }

    @Unique
    void transform() {
        if (!this.transformStart.isAvailable()) {
            this.transformStart.set(this.field_2102 - 1);
        }
        if (this.transformStart.get() >= this.field_2102) {
            return;
        }
        String currentString = this.method_1882().substring(this.transformStart.get(), this.field_2102);
        Iterator complete = Cfg.General.substitutions.getKeyValuePairsForKeysStartingWith((CharSequence)currentString).iterator();
        if (complete.hasNext()) {
            Map.Entry substitution = (Map.Entry)complete.next();
            if (((String)substitution.getKey()).length() == currentString.length() && !complete.hasNext() && this.substitute(this.transformStart.get(), this.field_2102, (String)substitution.getValue())) {
                this.transformStart.set(this.field_2102);
            }
            return;
        }
        if (this.transformStart.get() == this.field_2102 - 1) {
            this.transformStart.increment();
        } else {
            String previousString = this.method_1882().substring(this.transformStart.get(), this.field_2102 - 1);
            String substitution = (String)Cfg.General.substitutions.get((Object)previousString);
            if (substitution != null && this.substitute(this.transformStart.get(), this.field_2102 - 1, substitution)) {
                this.method_1883(this.field_2102 + 1, false);
            } else {
                this.transformStart.increment();
                this.transform();
            }
        }
    }

    @Override
    public String chattransform$finalize() {
        String str = this.method_1882();
        if (!this.transformStart.isAvailable() || this.transformStart.get() >= this.field_2102) {
            return str;
        }
        String currentString = str.substring(this.transformStart.get(), this.field_2102);
        String substitution = (String)Cfg.General.substitutions.get((Object)currentString);
        if (substitution == null || !this.substitute(this.transformStart.get(), this.field_2102, substitution)) {
            this.transformStart.increment();
            return this.chattransform$finalize();
        }
        return str;
    }

    @Unique
    boolean substitute(int start, int end, String substitution) {
        ChatTransform.LOG.info("Transforming " + this.method_1882().substring(start, end) + " to " + substitution, new Object[0]);
        String sub = this.field_2092.substring(0, start) + substitution + this.field_2092.substring(end);
        if (this.field_2104.test(sub)) {
            this.field_2092 = sub;
            int oldLen = end - start;
            int newLen = substitution.length();
            if (this.field_2102 > end) {
                this.field_2102 += newLen - oldLen;
            } else if (this.field_2102 > start) {
                this.field_2102 = start + newLen;
            }
            this.field_2101 = this.field_2102;
            this.lastSubstitution = new Substitution(start, start + newLen);
            return true;
        }
        return false;
    }

    @Inject(method={"renderWidget(Lnet/minecraft/client/gui/DrawContext;IIF)V"}, at={@At(value="TAIL")})
    void renderTransformStart(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (this.method_1885() && Cfg.Client.visualize) {
            int x;
            int y;
            int n = y = this.field_2095 ? this.method_46427() + (this.field_22759 - 8) / 2 : this.method_46427();
            if (this.transformStart.isAvailable()) {
                x = this.method_1889(this.transformStart.get());
                this.chattransform$fill(context, x, y - 1, x + 1, y + 1 + 9, 0x7F0000FF);
            }
            if (this.transformStart.showPrevious()) {
                x = this.method_1889(this.transformStart.getPrevious());
                this.chattransform$fill(context, x, y - 1, x + 1, y + 1 + 9, 0x7FFF0000);
            }
            if (this.lastSubstitution != null && this.lastSubstitution.shouldShow()) {
                int start = this.method_1889(this.lastSubstitution.start());
                int end = this.method_1889(Math.min(this.lastSubstitution.end() + 1, this.field_2092.length()));
                this.chattransform$fill(context, start, y - 1, end, y + 1 + 9, 0x7FFFFF00);
            }
        }
    }

    @Unique
    private void chattransform$fill(class_332 context, int x1, int y1, int x2, int y2, int color) {
        int i;
        int maxX;
        if (x1 < 0) {
            x1 = 0;
        }
        if (x2 < 0) {
            x2 = 0;
        }
        if (x1 > (maxX = this.method_46426() + this.method_25368())) {
            x1 = maxX;
        }
        if (x2 > maxX) {
            x2 = maxX;
        }
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        context.method_51433(this.field_2105, "X={" + x1 + ";" + x2 + "} Y={" + y1 + ";" + y2 + "}", 0, 0, -16777216, false);
        context.method_25294(x1, y1, x2, y2, color);
    }
}

