/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.chattransform.server;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.gitlab.jfronny.chattransform.Cfg;
import io.gitlab.jfronny.chattransform.ChatTransform;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigInstance;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.message.v1.ServerMessageDecoratorEvent;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_8828;

public class ChatTransformServer
implements DedicatedServerModInitializer {
    public static final ConfigInstance CONFIG_INSTANCE = Objects.requireNonNull(ConfigInstance.get((String)"chat-transform"));

    public void onInitializeServer() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            LiteralArgumentBuilder root = (LiteralArgumentBuilder)class_2170.method_9247((String)"chat-transform").executes(context -> {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("chat-transform is " + (this.get(((class_2168)context.getSource()).method_44023()) ? "enabled" : "disabled") + " for you.")));
                return 1;
            });
            root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"opt-in").requires(src -> Cfg.Server.playerConfigurable)).executes(context -> {
                if (((class_2168)context.getSource()).method_44023() == null) {
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You are not a player."));
                    return 1;
                }
                if (this.get(((class_2168)context.getSource()).method_44023())) {
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You are already opted in to using chat-transform."));
                    return 1;
                }
                this.set(((class_2168)context.getSource()).method_44023(), true);
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Toggled chat-transform on"));
                return 1;
            }));
            root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"opt-out").requires(src -> Cfg.Server.playerConfigurable)).executes(context -> {
                if (((class_2168)context.getSource()).method_44023() == null) {
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You are not a player."));
                    return 1;
                }
                if (!this.get(((class_2168)context.getSource()).method_44023())) {
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You are already opted out of using chat-transform."));
                    return 1;
                }
                this.set(((class_2168)context.getSource()).method_44023(), false);
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Toggled chat-transform off"));
                return 1;
            }));
            root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").requires(src -> Cfg.Server.playerConfigurable)).executes(context -> {
                if (((class_2168)context.getSource()).method_44023() == null) {
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You are not a player."));
                    return 1;
                }
                this.reset(((class_2168)context.getSource()).method_44023());
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Reset chat-transform to " + (Cfg.Server.defaultEnable ? "on" : "off"))));
                return 1;
            }));
            root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset-all").requires(src -> src.method_9259(4))).executes(context -> {
                Cfg.Server.playerStates.clear();
                CONFIG_INSTANCE.write();
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Reset all player states"));
                return 1;
            }));
            dispatcher.register(root);
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (Cfg.Server.messageOnFirstConnect && !this.has(handler.method_32311())) {
                this.set(handler.method_32311(), Cfg.Server.defaultEnable);
                class_5250 text = class_2561.method_43470((String)"This server uses chat-transform to transform messages you send.");
                if (Cfg.Server.playerConfigurable) {
                    text.method_27693(" To turn it " + (Cfg.Server.defaultEnable ? "off" : "on") + ", use ");
                    String command = "/chat-transform opt-" + (Cfg.Server.defaultEnable ? "out" : "in");
                    text.method_10852((class_2561)class_2561.method_43470((String)command).method_27694(s -> s.method_10958((class_2558)new class_2558.class_10609(command))));
                    text.method_27693(".");
                }
                handler.method_32311().method_64398((class_2561)text);
            }
        });
        ServerMessageDecoratorEvent.EVENT.register(ServerMessageDecoratorEvent.CONTENT_PHASE, (sender, message) -> sender != null && this.get(sender) ? this.transform(message) : message);
    }

    private boolean has(class_3222 player) {
        return Cfg.Server.playerStates.containsKey(player.method_5845());
    }

    private boolean get(class_3222 player) {
        return Cfg.Server.playerStates.computeIfAbsent(player.method_5845(), k -> Cfg.Server.defaultEnable);
    }

    private void set(class_3222 player, boolean value) {
        Cfg.Server.playerStates.put(player.method_5845(), value);
        CONFIG_INSTANCE.write();
    }

    private void reset(class_3222 player) {
        Cfg.Server.playerStates.remove(player.method_5845());
        CONFIG_INSTANCE.write();
    }

    private class_2561 transform(class_2561 source) {
        class_5250 result = class_5250.method_43477((class_7417)this.transform(source.method_10851())).method_10862(source.method_10866());
        for (class_2561 sibling : source.method_10855()) {
            result.method_10852(this.transform(sibling));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private class_7417 transform(class_7417 source) {
        String string2;
        if (source instanceof class_2588) {
            class_2588 tx = (class_2588)source;
            Object[] args = tx.method_11023();
            args = Arrays.copyOf(args, args.length);
            for (int i = 0; i < args.length; ++i) {
                Object object = args[i];
                int n = 0;
                args[i] = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2561.class, class_7417.class, String.class}, (Object)object, n)) {
                    case 0 -> {
                        class_2561 tx1 = (class_2561)object;
                        yield this.transform(tx1);
                    }
                    case 1 -> {
                        class_7417 tx1 = (class_7417)object;
                        yield this.transform(tx1);
                    }
                    case 2 -> {
                        String tx1 = (String)object;
                        yield ChatTransform.transform(tx1);
                    }
                    default -> args[i];
                };
            }
            return new class_2588(tx.method_11022(), ChatTransform.transform(tx.method_48323()), args);
        }
        if (!(source instanceof class_8828.class_2585)) return source;
        class_8828.class_2585 class_25852 = (class_8828.class_2585)source;
        try {
            String string;
            string2 = string = class_25852.comp_737();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return new class_8828.class_2585(ChatTransform.transform(string2));
    }
}

