/*
 * Decompiled with CFR 0.152.
 */
package me.Krisendo.noTemplateDupe;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class NoTemplateDupe
extends JavaPlugin
implements Listener {
    private boolean pluginEnabled;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        if (!this.pluginEnabled) {
            this.getLogger().info("NoTemplateDupe is disabled in config.yml.");
            return;
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("NoTemplateDupe enabled - Netherite Upgrade Template duplication blocked.");
        new BukkitRunnable(){

            public void run() {
                NamespacedKey key = NamespacedKey.minecraft((String)"netherite_upgrade_smithing_template");
                boolean removed = Bukkit.removeRecipe((NamespacedKey)key);
                if (removed) {
                    NoTemplateDupe.this.getLogger().info("Removed recipe: " + String.valueOf(key));
                } else {
                    NoTemplateDupe.this.getLogger().warning("Could not remove recipe " + String.valueOf(key) + ". Blocking via events.");
                }
            }
        }.runTaskLater((Plugin)this, 40L);
    }

    private void loadConfig() {
        FileConfiguration cfg = this.getConfig();
        this.pluginEnabled = cfg.getBoolean("enabled", true);
    }

    public void onDisable() {
        this.getLogger().info("NoTemplateDupe disabled.");
    }

    @EventHandler(ignoreCancelled=true)
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        if (!this.pluginEnabled) {
            return;
        }
        CraftingInventory inv = event.getInventory();
        ItemStack result = inv.getResult();
        if (this.isDuplicationResult(result)) {
            inv.setResult(new ItemStack(Material.AIR));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onCraftItem(CraftItemEvent event) {
        if (!this.pluginEnabled) {
            return;
        }
        ItemStack result = event.getInventory().getResult();
        if (this.isDuplicationResult(result) && this.matchesDuplicationPattern(event.getInventory().getMatrix())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        if (!this.pluginEnabled) {
            return;
        }
        if (!(event.getInventory() instanceof CraftingInventory)) {
            return;
        }
        CraftingInventory inv = (CraftingInventory)event.getInventory();
        ItemStack result = inv.getResult();
        if (this.isDuplicationResult(result) && this.matchesDuplicationPattern(inv.getMatrix())) {
            event.setCancelled(true);
        }
    }

    private boolean isDuplicationResult(ItemStack stack) {
        return stack != null && stack.getType() == Material.NETHERITE_UPGRADE_SMITHING_TEMPLATE;
    }

    private boolean matchesDuplicationPattern(ItemStack[] matrix) {
        if (matrix == null || matrix.length != 9) {
            return false;
        }
        boolean hasTemplate = false;
        int diamonds = 0;
        boolean hasNetherrack = false;
        for (ItemStack item : matrix) {
            if (item == null) continue;
            Material m = item.getType();
            if (m == Material.NETHERITE_UPGRADE_SMITHING_TEMPLATE) {
                hasTemplate = true;
                continue;
            }
            if (m == Material.DIAMOND) {
                ++diamonds;
                continue;
            }
            if (m != Material.NETHERRACK) continue;
            hasNetherrack = true;
        }
        return hasTemplate && diamonds >= 8 && hasNetherrack;
    }
}

