/*
 * Decompiled with CFR 0.152.
 */
package more_relics.item;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import more_relics.item.Group;
import more_relics.item.MoreRelicsFactory;
import more_relics.spell.MoreRelicSpells;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import net.minecraft.class_9285;
import net.more_rpg_classes.custom.MoreSpellSchools;
import net.more_rpg_classes.entity.attribute.MRPGCEntityAttributes;
import net.relics_rpgs.config.ItemConfig;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.ConfigUtil;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import org.jetbrains.annotations.Nullable;

public class MoreRelicsItems {
    public static final List<Entry> entries = new ArrayList<Entry>();
    public static Function<ItemArgs, class_1792> factory = args -> {
        class_1792.class_1793 settings = args.settings;
        if (args.attributes != null) {
            settings.method_57348(args.attributes);
        }
        return new class_1792(settings);
    };
    private static final float tier_0_multiplier = 0.05f;
    public static final Entry JEWEL_FIGURINE_MALACHITE = MoreRelicsItems.add(new Entry(1, "jewel_figurine_malachite", "Malachite Honeybadger Figurine")).config(new ItemConfig.Entry().withAttributes(List.of(new AttributeModifier(MoreSpellSchools.EARTH.id, 0.05f, class_1322.class_1323.field_6330), new AttributeModifier(MoreSpellSchools.NATURE.id, 0.05f, class_1322.class_1323.field_6330))));
    public static final Entry JEWEL_FIGURINE_AQUAMARINE = MoreRelicsItems.add(new Entry(1, "jewel_figurine_aquamarine", "Aquamarine Koi-Carp Figurine")).config(new ItemConfig.Entry().withAttributes(List.of(new AttributeModifier(MoreSpellSchools.AIR.id, 0.05f, class_1322.class_1323.field_6330), new AttributeModifier(MoreSpellSchools.WATER.id, 0.05f, class_1322.class_1323.field_6330))));
    public static final Entry JEWEL_FIGURINE_CHAIN = MoreRelicsItems.add(new Entry(1, "jewel_figurine_chain", "Metallic Wolf Figurine")).config(new ItemConfig.Entry().withAttributes(List.of(new AttributeModifier(MRPGCEntityAttributes.RAGE_MODIFIER.method_55840(), 0.05f, class_1322.class_1323.field_6330), new AttributeModifier(class_5134.field_23721.method_55840(), 0.025f, class_1322.class_1323.field_6330))));
    public static final Entry LESSER_PROC_AIR_WATER = MoreRelicsItems.add(new Entry(1, "lesser_proc_air_water", "Bottled Typhoon")).spell(SpellContainerHelper.createForRelic((class_2960)MoreRelicSpells.lesser_proc_air_water.id()));
    public static final Entry LESSER_PROC_EARTH_NATURE = MoreRelicsItems.add(new Entry(1, "lesser_proc_earth_nature", "Glowing Moss Stone")).spell(SpellContainerHelper.createForRelic((class_2960)MoreRelicSpells.lesser_proc_earth_nature.id()));
    public static final Entry LESSER_USE_RAGE = MoreRelicsItems.add(new Entry(1, "lesser_use_rage", "Rage Powder")).spell(SpellContainerHelper.createForRelic((class_2960)MoreRelicSpells.lesser_use_rage_power.id()));
    public static final Entry MEDIUM_USE_AIR_POWER = MoreRelicsItems.add(new Entry(2, "medium_use_air_power", "Air Orb")).spell(SpellContainerHelper.createForRelic((class_2960)MoreRelicSpells.medium_use_air_power.id()));
    public static final Entry MEDIUM_USE_EARTH_POWER = MoreRelicsItems.add(new Entry(2, "medium_use_earth_power", "Earth Orb")).spell(SpellContainerHelper.createForRelic((class_2960)MoreRelicSpells.medium_use_earth_power.id()));
    public static final Entry MEDIUM_USE_WATER_POWER = MoreRelicsItems.add(new Entry(2, "medium_use_water_power", "Water Orb")).spell(SpellContainerHelper.createForRelic((class_2960)MoreRelicSpells.medium_use_water_power.id()));
    public static final Entry MEDIUM_USE_NATURE_POWER = MoreRelicsItems.add(new Entry(2, "medium_use_nature_power", "Nature Orb")).spell(SpellContainerHelper.createForRelic((class_2960)MoreRelicSpells.medium_use_nature_power.id()));
    public static final Entry MEDIUM_PROC_RAGE = MoreRelicsItems.add(new Entry(2, "medium_proc_rage", "Mardroeme Mushroom")).spell(SpellContainerHelper.createForRelic((class_2960)MoreRelicSpells.medium_perk_rage.id()));
    public static final Entry MEDIUM_PROC_LIFESTEAL = MoreRelicsItems.add(new Entry(2, "medium_proc_lifesteal", "Vampiric Scepter")).spell(SpellContainerHelper.createForRelic((class_2960)MoreRelicSpells.medium_proc_lifesteal.id()));
    public static final Entry GREATER_FROZEN_HEART = MoreRelicsItems.add(new Entry(3, "greater_frozen_heart", "Frozen Heart")).spell(SpellContainerHelper.createForRelic((class_2960)MoreRelicSpells.greater_frozen_heart.id()));
    public static final Entry GREATER_PROC_RAGE = MoreRelicsItems.add(new Entry(3, "greater_proc_rage", "Svablod's Totem")).spell(SpellContainerHelper.createForRelic((class_2960)MoreRelicSpells.greater_proc_rage.id()));
    public static final Entry GREATER_KIRCHEIS_SHARD = MoreRelicsItems.add(new Entry(3, "greater_kircheis_shard", "Kircheis Shard")).spell(SpellContainerHelper.createForRelic((class_2960)MoreRelicSpells.greater_kircheis_shard.id()));
    public static final Entry GREATER_MADREDS_BLOODRAZOR = MoreRelicsItems.add(new Entry(3, "greater_madreds_bloodrazor", "Madred's Bloodrazor")).spell(SpellContainerHelper.createForRelic((class_2960)MoreRelicSpells.greater_madreds_bloodrazor.id()));
    public static final Entry GREATER_LIANDRYS_TORMENT = MoreRelicsItems.add(new Entry(3, "greater_liandrys_torment", "Liandry's Torment")).spell(SpellContainerHelper.createForRelic((class_2960)MoreRelicSpells.greater_liandrys_torment.id()));
    public static final Entry GREATER_SUNFIRE_CAPE = MoreRelicsItems.add(new Entry(3, "greater_sunfire_cape", "Sunfire Cape")).spell(SpellContainerHelper.createForRelic((class_2960)MoreRelicSpells.greater_sunfire_cape.id()));
    public static final Entry SUPERIOR_MEJAIS_SOULSTEALER = MoreRelicsItems.add(new Entry(4, "superior_mejais_soulstealer", "Mejai's Soulstealer")).spell(SpellContainerHelper.createForRelic((class_2960)MoreRelicSpells.superior_mejais_soulstealer.id()));
    public static final Entry SUPERIOR_ZHONYAS_HOURGLASS = MoreRelicsItems.add(new Entry(4, "superior_zhonyas_hourglass", "Zhonya's Hourglass")).spell(SpellContainerHelper.createForRelic((class_2960)MoreRelicSpells.superior_zhonyas_hourglass.id()));
    public static final Entry SUPERIOR_SHURELYAS_BATTLESONG = MoreRelicsItems.add(new Entry(4, "superior_shurelyas_battlesong", "Shurelya's Battlesong")).spell(SpellContainerHelper.createForRelic((class_2960)MoreRelicSpells.superior_shurelyas_battlesong.id()));
    public static final Entry SUPERIOR_MIKAELS_BLESSING = MoreRelicsItems.add(new Entry(4, "superior_mikaels_blessing", "Mikael's Blessing")).spell(SpellContainerHelper.createForRelic((class_2960)MoreRelicSpells.superior_mikaels_blessing.id()));
    public static final Entry SUPERIOR_GUARDIAN_ANGEL = MoreRelicsItems.add(new Entry(4, "superior_guardian_angel", "Guardian Angel")).spell(SpellContainerHelper.createForRelic((class_2960)MoreRelicSpells.superior_guardian_angel.id()));

    public static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    private static Function<ItemArgs, class_1792> getFactory() {
        return factory;
    }

    public static void register(Map<String, ItemConfig.Entry> config) {
        for (Entry entry : entries) {
            String key = entry.id().toString();
            ItemConfig.Entry configEntry = config.get(key);
            if (configEntry != null) {
                entry.config(configEntry);
                continue;
            }
            config.put(key, entry.config());
        }
        for (Entry entry : entries) {
            if (!entry.isEnabled()) continue;
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)entry.id(), (Object)entry.item().get());
        }
        ItemGroupEvents.modifyEntriesEvent(Group.KEY).register(content -> {
            for (Entry entry : entries) {
                if (!entry.isEnabled()) continue;
                content.method_45421((class_1935)entry.item().get());
            }
        });
    }

    public static final class Entry {
        private final int tier;
        public String lootTheme;
        private final String name;
        private final String translatedName;
        private ItemConfig.Entry config;
        public ItemConfig.Entry defaults;
        private final Supplier<class_1792> item;
        private SpellContainer spellContainer;

        public Entry(int tier, String name, String translatedName) {
            this(tier, name, translatedName, ItemConfig.Entry.EMPTY);
        }

        public Entry(int tier, String name, String translatedName, ItemConfig.Entry config) {
            this.tier = tier;
            this.name = name;
            this.translatedName = translatedName;
            this.config = config;
            this.defaults = config;
            this.item = Suppliers.memoize(() -> {
                class_1814 rarity;
                class_1792.class_1793 settings = new class_1792.class_1793().method_7889(1);
                class_9285 attributes = this.config().attributes != null && !this.config().attributes.isEmpty() ? ConfigUtil.attributesComponent((class_2960)class_2960.method_60655((String)"more_relics", (String)name), (List)this.config().attributes).method_57486() : null;
                SpellContainer spellContainer = this.spellContainer();
                if (spellContainer != null) {
                    settings = settings.method_57349(SpellDataComponents.SPELL_CONTAINER, (Object)spellContainer);
                }
                if (this.config().durability > 0) {
                    settings = settings.method_7895(this.config().durability);
                }
                if ((rarity = Entry.rarityFrom(tier)) != class_1814.field_8906) {
                    settings = settings.method_7894(rarity);
                }
                return MoreRelicsFactory.getFactory().apply(new MoreRelicsFactory.ItemArgs(settings, attributes));
            });
        }

        private static class_1814 rarityFrom(int tier) {
            return switch (tier) {
                case 0, 1 -> class_1814.field_8906;
                case 2 -> class_1814.field_8907;
                case 3 -> class_1814.field_8903;
                default -> class_1814.field_8904;
            };
        }

        public int tier() {
            return this.tier;
        }

        public class_2960 id() {
            return class_2960.method_60655((String)"more_relics", (String)this.name);
        }

        public String name() {
            return this.name;
        }

        public String translatedName() {
            return this.translatedName;
        }

        public ItemConfig.Entry config() {
            return this.config;
        }

        public Supplier<class_1792> item() {
            return this.item;
        }

        @Nullable
        public SpellContainer spellContainer() {
            return this.spellContainer;
        }

        public Entry config(ItemConfig.Entry config) {
            this.config = config;
            return this;
        }

        public Entry spell(SpellContainer spellContainer) {
            this.spellContainer = spellContainer;
            return this;
        }

        public Entry lootTheme(String lootTheme) {
            this.lootTheme = lootTheme;
            return this;
        }

        public boolean isEnabled() {
            return true;
        }
    }

    public record ItemArgs(class_1792.class_1793 settings, @Nullable class_9285 attributes) {
    }
}

