/*
 * Decompiled with CFR 0.152.
 */
package more_relics.item;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import more_relics.item.Group;
import more_relics.spell.MoreRelicSpells;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.more_rpg_classes.custom.MoreSpellSchools;
import net.more_rpg_classes.entity.attribute.MRPGCEntityAttributes;
import net.relics_rpgs.config.ItemConfig;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.ConfigUtil;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import org.jetbrains.annotations.Nullable;

public class MoreRelicsItems {
    public static final List<Entry> entries = new ArrayList<Entry>();
    public static Function<ItemArgs, Item> factory = args -> {
        Item.Properties settings = args.settings;
        if (args.attributes != null) {
            settings.attributes(args.attributes);
        }
        return new Item(settings);
    };
    private static final float tier_0_multiplier = 0.05f;
    public static final Entry JEWEL_FIGURINE_WATER = MoreRelicsItems.add(new Entry(1, "jewel_figurine_earth", "Citrine Honeybadger Figurine")).config(new ItemConfig.Entry().withAttributes(List.of(new AttributeModifier(MoreSpellSchools.EARTH.id, 0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE))));
    public static final Entry JEWEL_FIGURINE_JADE = MoreRelicsItems.add(new Entry(1, "jewel_figurine_air", "Jade Pegasus Figurine")).config(new ItemConfig.Entry().withAttributes(List.of(new AttributeModifier(MoreSpellSchools.AIR.id, 0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE))));
    public static final Entry JEWEL_FIGURINE_SAPPHIRE = MoreRelicsItems.add(new Entry(1, "jewel_figurine_water", "Sapphire Koi-Carp Figurine")).config(new ItemConfig.Entry().withAttributes(List.of(new AttributeModifier(MoreSpellSchools.WATER.id, 0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE))));
    public static final Entry JEWEL_FIGURINE_RAGE = MoreRelicsItems.add(new Entry(1, "jewel_figurine_rage", "Ruby Wolf Figurine")).config(new ItemConfig.Entry().withAttributes(List.of(new AttributeModifier(MRPGCEntityAttributes.RAGE_MODIFIER.getRegisteredName(), 0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE))));
    public static final Entry LESSER_PROC_AIR_LIGHTNING = MoreRelicsItems.add(new Entry(1, "lesser_proc_air_lightning", "Bottled Storm")).spell(SpellContainerHelper.createForRelic((ResourceLocation)MoreRelicSpells.lesser_proc_air_lightning.id()));
    public static final Entry LESSER_PROC_EARTH_FIRE = MoreRelicsItems.add(new Entry(1, "lesser_proc_earth_fire", "Volcanic Crystal")).spell(SpellContainerHelper.createForRelic((ResourceLocation)MoreRelicSpells.lesser_proc_earth_fire.id()));
    public static final Entry LESSER_PROC_WATER_FROST = MoreRelicsItems.add(new Entry(1, "lesser_proc_water_frost", "Crystallized Tear")).spell(SpellContainerHelper.createForRelic((ResourceLocation)MoreRelicSpells.lesser_proc_water_frost.id()));
    public static final Entry LESSER_USE_RAGE = MoreRelicsItems.add(new Entry(1, "lesser_use_rage", "Rage Powder")).spell(SpellContainerHelper.createForRelic((ResourceLocation)MoreRelicSpells.lesser_use_rage_power.id()));
    public static final Entry MEDIUM_USE_AIR_POWER = MoreRelicsItems.add(new Entry(2, "medium_use_air_power", "Air Orb")).spell(SpellContainerHelper.createForRelic((ResourceLocation)MoreRelicSpells.medium_use_air_power.id()));
    public static final Entry MEDIUM_USE_EARTH_POWER = MoreRelicsItems.add(new Entry(2, "medium_use_earth_power", "Earth Orb")).spell(SpellContainerHelper.createForRelic((ResourceLocation)MoreRelicSpells.medium_use_earth_power.id()));
    public static final Entry MEDIUM_USE_WATER_POWER = MoreRelicsItems.add(new Entry(2, "medium_use_water_power", "Water Orb")).spell(SpellContainerHelper.createForRelic((ResourceLocation)MoreRelicSpells.medium_use_water_power.id()));
    public static final Entry MEDIUM_PROC_RAGE = MoreRelicsItems.add(new Entry(2, "medium_proc_rage", "Mardroeme Mushroom")).spell(SpellContainerHelper.createForRelic((ResourceLocation)MoreRelicSpells.medium_perk_rage.id()));
    public static final Entry MEDIUM_PROC_LIFESTEAL = MoreRelicsItems.add(new Entry(2, "medium_proc_lifesteal", "Vampiric Scepter")).spell(SpellContainerHelper.createForRelic((ResourceLocation)MoreRelicSpells.medium_proc_lifesteal.id()));
    public static final Entry GREATER_FROZEN_HEART = MoreRelicsItems.add(new Entry(3, "greater_frozen_heart", "Frozen Heart")).spell(SpellContainerHelper.createForRelic((ResourceLocation)MoreRelicSpells.greater_frozen_heart.id()));
    public static final Entry GREATER_PROC_RAGE = MoreRelicsItems.add(new Entry(3, "greater_proc_rage", "Svablod's Totem")).spell(SpellContainerHelper.createForRelic((ResourceLocation)MoreRelicSpells.greater_proc_rage.id()));
    public static final Entry GREATER_KIRCHEIS_SHARD = MoreRelicsItems.add(new Entry(3, "greater_kircheis_shard", "Kircheis Shard")).spell(SpellContainerHelper.createForRelic((ResourceLocation)MoreRelicSpells.greater_kircheis_shard.id()));
    public static final Entry GREATER_MADREDS_BLOODRAZOR = MoreRelicsItems.add(new Entry(3, "greater_madreds_bloodrazor", "Madred's Bloodrazor")).spell(SpellContainerHelper.createForRelic((ResourceLocation)MoreRelicSpells.greater_madreds_bloodrazor.id()));
    public static final Entry GREATER_LIANDRYS_TORMENT = MoreRelicsItems.add(new Entry(3, "greater_liandrys_torment", "Liandry's Torment")).spell(SpellContainerHelper.createForRelic((ResourceLocation)MoreRelicSpells.greater_liandrys_torment.id()));
    public static final Entry GREATER_SUNFIRE_CAPE = MoreRelicsItems.add(new Entry(3, "greater_sunfire_cape", "Sunfire Cape")).spell(SpellContainerHelper.createForRelic((ResourceLocation)MoreRelicSpells.greater_sunfire_cape.id()));
    public static final Entry SUPERIOR_MEJAIS_SOULSTEALER = MoreRelicsItems.add(new Entry(4, "superior_mejais_soulstealer", "Mejai's Soulstealer")).spell(SpellContainerHelper.createForRelic((ResourceLocation)MoreRelicSpells.superior_mejais_soulstealer.id()));
    public static final Entry SUPERIOR_ZHONYAS_HOURGLASS = MoreRelicsItems.add(new Entry(4, "superior_zhonyas_hourglass", "Zhonya's Hourglass")).spell(SpellContainerHelper.createForRelic((ResourceLocation)MoreRelicSpells.superior_zhonyas_hourglass.id()));
    public static final Entry SUPERIOR_SHURELYAS_BATTLESONG = MoreRelicsItems.add(new Entry(4, "superior_shurelyas_battlesong", "Shurelya's Battlesong")).spell(SpellContainerHelper.createForRelic((ResourceLocation)MoreRelicSpells.superior_shurelyas_battlesong.id()));
    public static final Entry SUPERIOR_MIKAELS_BLESSING = MoreRelicsItems.add(new Entry(4, "superior_mikaels_blessing", "Mikael's Blessing")).spell(SpellContainerHelper.createForRelic((ResourceLocation)MoreRelicSpells.superior_mikaels_blessing.id()));
    public static final Entry SUPERIOR_GUARDIAN_ANGEL = MoreRelicsItems.add(new Entry(4, "superior_guardian_angel", "Guardian Angel")).spell(SpellContainerHelper.createForRelic((ResourceLocation)MoreRelicSpells.superior_guardian_angel.id()));

    public static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    private static Function<ItemArgs, Item> getFactory() {
        return factory;
    }

    public static void register(Map<String, ItemConfig.Entry> config) {
        for (Entry entry : entries) {
            String key = entry.id().toString();
            ItemConfig.Entry configEntry = config.get(key);
            if (configEntry != null) {
                entry.config(configEntry);
                continue;
            }
            config.put(key, entry.config());
        }
        for (Entry entry : entries) {
            if (!entry.isEnabled()) continue;
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)entry.id(), (Object)entry.item().get());
        }
        ItemGroupEvents.modifyEntriesEvent(Group.KEY).register(content -> {
            for (Entry entry : entries) {
                if (!entry.isEnabled()) continue;
                content.accept((ItemLike)entry.item().get());
            }
        });
    }

    public static final class Entry {
        private final int tier;
        public String lootTheme;
        private final String name;
        private final String translatedName;
        private ItemConfig.Entry config;
        public ItemConfig.Entry defaults;
        private final Supplier<Item> item;
        private SpellContainer spellContainer;

        public Entry(int tier, String name, String translatedName) {
            this(tier, name, translatedName, ItemConfig.Entry.EMPTY);
        }

        public Entry(int tier, String name, String translatedName, ItemConfig.Entry config) {
            this.tier = tier;
            this.name = name;
            this.translatedName = translatedName;
            this.config = config;
            this.defaults = config;
            this.item = Suppliers.memoize(() -> {
                Rarity rarity;
                Item.Properties settings = new Item.Properties().stacksTo(1);
                ItemAttributeModifiers attributes = this.config().attributes != null && !this.config().attributes.isEmpty() ? ConfigUtil.attributesComponent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)name), (List)this.config().attributes).build() : null;
                SpellContainer spellContainer = this.spellContainer();
                if (spellContainer != null) {
                    settings = settings.component(SpellDataComponents.SPELL_CONTAINER, (Object)spellContainer);
                }
                if (this.config().durability > 0) {
                    settings = settings.durability(this.config().durability);
                }
                if ((rarity = Entry.rarityFrom(tier)) != Rarity.COMMON) {
                    settings = settings.rarity(rarity);
                }
                return MoreRelicsItems.getFactory().apply(new ItemArgs(settings, attributes));
            });
        }

        private static Rarity rarityFrom(int tier) {
            return switch (tier) {
                case 0, 1 -> Rarity.COMMON;
                case 2 -> Rarity.UNCOMMON;
                case 3 -> Rarity.RARE;
                default -> Rarity.EPIC;
            };
        }

        public int tier() {
            return this.tier;
        }

        public ResourceLocation id() {
            return ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)this.name);
        }

        public String name() {
            return this.name;
        }

        public String translatedName() {
            return this.translatedName;
        }

        public ItemConfig.Entry config() {
            return this.config;
        }

        public Supplier<Item> item() {
            return this.item;
        }

        @Nullable
        public SpellContainer spellContainer() {
            return this.spellContainer;
        }

        public Entry config(ItemConfig.Entry config) {
            this.config = config;
            return this;
        }

        public Entry spell(SpellContainer spellContainer) {
            this.spellContainer = spellContainer;
            return this;
        }

        public Entry lootTheme(String lootTheme) {
            this.lootTheme = lootTheme;
            return this;
        }

        public boolean isEnabled() {
            return true;
        }
    }

    public record ItemArgs(Item.Properties settings, @Nullable ItemAttributeModifiers attributes) {
    }
}

