/*
 * Decompiled with CFR 0.152.
 */
package more_relics.spell;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import more_relics.spell.effect.CustomStatusEffect;
import more_relics.spell.effect.LiandrysTornmentStatusEffect;
import more_relics.spell.effect.MikaelsBlessingStatusEffect;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.more_rpg_classes.custom.MoreSpellSchools;
import net.more_rpg_classes.entity.attribute.MRPGCEntityAttributes;
import net.relics_rpgs.util.SpellSchoolUtil;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.ConfigFile;
import net.spell_engine.api.config.EffectConfig;
import net.spell_engine.api.effect.ActionImpairing;
import net.spell_engine.api.effect.Effects;
import net.spell_engine.api.effect.EntityActionsAllowed;
import net.spell_engine.api.effect.Synchronized;
import net.spell_engine.api.entity.SpellEngineAttributes;
import net.spell_power.api.SpellSchools;

public class MoreRelicEffects {
    public static final List<Effects.Entry> entries = new ArrayList<Effects.Entry>();
    private static final float T1_BUFF_MULTIPLIER = 0.1f;
    private static final float T2_BUFF_MULTIPLIER = 0.2f;
    private static final float T3_BUFF_MULTIPLIER = 0.3f;
    private static final float T4_BUFF_MULTIPLIER = 0.4f;
    public static Effects.Entry LESSER_RAGE_POWER = MoreRelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"lesser_rage_power"), "Rage Power", "Increases Rage.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(List.of(new AttributeModifier(MRPGCEntityAttributes.RAGE_MODIFIER.getRegisteredName(), 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry LESSER_POWER_AIR_LIGHTNING = MoreRelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"lesser_air_lightning"), "Air and Lightning Power", "Increases Air and Lightning spell power.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(List.of(MoreSpellSchools.AIR, SpellSchools.LIGHTNING).stream().map(school -> new AttributeModifier(school.id.toString(), 0.15f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)).toList())));
    public static Effects.Entry LESSER_POWER_EARTH_FIRE = MoreRelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"lesser_earth_fire"), "Earth and Fire Power", "Increases Earth and Fire spell power.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(List.of(MoreSpellSchools.EARTH, SpellSchools.FIRE).stream().map(school -> new AttributeModifier(school.id.toString(), 0.15f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)).toList())));
    public static Effects.Entry LESSER_POWER_WATER_FROST = MoreRelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"lesser_water_frost"), "Water and Frost Power", "Increases Water and Frost spell power.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(List.of(MoreSpellSchools.WATER, SpellSchools.FROST).stream().map(school -> new AttributeModifier(school.id.toString(), 0.15f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)).toList())));
    public static Effects.Entry MEDIUM_AIR_POWER = MoreRelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"medium_air_power"), "Air Power", "Increases Air spell power.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(List.of(MoreSpellSchools.AIR).stream().map(school -> new AttributeModifier(school.id.toString(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)).toList())));
    public static Effects.Entry MEDIUM_EARTH_POWER = MoreRelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"medium_earth_power"), "Earth Power", "Increases Earth spell power.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(List.of(MoreSpellSchools.EARTH).stream().map(school -> new AttributeModifier(school.id.toString(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)).toList())));
    public static Effects.Entry MEDIUM_WATER_POWER = MoreRelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"medium_water_power"), "Water Power", "Increases Water spell power.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(List.of(MoreSpellSchools.WATER).stream().map(school -> new AttributeModifier(school.id.toString(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)).toList())));
    public static Effects.Entry MEDIUM_RAGE_POWER = MoreRelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"medium_rage_power"), "Mardroeme", "Increases Rage and Attack Speed, but silences the caster.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(List.of(new AttributeModifier(MRPGCEntityAttributes.RAGE_MODIFIER.getRegisteredName(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(Attributes.ATTACK_SPEED.getRegisteredName(), 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry MEDIUM_LIFESTEAL_POWER = MoreRelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"medium_lifesteal_power"), "Vampiric Scepter", "Increases Lifesteal and Spell Vampire.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(List.of(new AttributeModifier(MRPGCEntityAttributes.LIFESTEAL_MODIFIER.getRegisteredName(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(MRPGCEntityAttributes.SPELL_VAMPIRE.getRegisteredName(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry GREATER_RAGE_POWER = MoreRelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"greater_rage_power"), "Svablods Ritual", "Increases Rage and attack speed, also reduces incoming Damage taken.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(List.of(new AttributeModifier(MRPGCEntityAttributes.RAGE_MODIFIER.getRegisteredName(), 0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(SpellEngineAttributes.DAMAGE_TAKEN.id, -0.65f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(Attributes.ATTACK_SPEED.getRegisteredName(), 0.15f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry GREATER_FROZEN_HEART = MoreRelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"greater_frozen_heart"), "Frozen Heart", "Reduces the attack speed drastically.", (MobEffect)new CustomStatusEffect(MobEffectCategory.HARMFUL, 0x888800), new EffectConfig(List.of(new AttributeModifier(Attributes.ATTACK_SPEED.getRegisteredName(), -0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(Attributes.MOVEMENT_SPEED.getRegisteredName(), -0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry GREATER_LIANDRYS_TORMENT = MoreRelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"greater_liandrys_torment"), "Liandry's Torment", "Increases incoming Damage and dealing damage according to the maximum health of the target per second.", (MobEffect)new LiandrysTornmentStatusEffect(MobEffectCategory.HARMFUL, 0x888800), new EffectConfig(List.of(new AttributeModifier(SpellEngineAttributes.DAMAGE_TAKEN.id, 0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry GREATER_MADREDS_BLOODRAZOR = MoreRelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"greater_madreds_bloodrazor"), "Madred' Bloodrazor", "Increases attack speed.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(List.of(new AttributeModifier(Attributes.ATTACK_SPEED.getRegisteredName(), 0.15f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry GREATER_SUNFIRE_CAPE = MoreRelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"greater_sunfire_cape"), "Sunfire Cape", "Deals damage around the user when taking or dealing melee damage.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800)));
    public static Effects.Entry SUPERIOR_ZHONYAS_HOURGLASS = MoreRelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"superior_zhonyas_hourglass"), "Zhonyas Hourglass", "Cant move, jump or cast spells but you're invulnerable.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(List.of(new AttributeModifier(Attributes.KNOCKBACK_RESISTANCE.getRegisteredName(), 10.0f, AttributeModifier.Operation.ADD_VALUE), new AttributeModifier(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE.getRegisteredName(), 10.0f, AttributeModifier.Operation.ADD_VALUE)))));
    public static Effects.Entry SUPERIOR_MEJAIS_SOULSTEALER = MoreRelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"superior_mejais_soulstealer"), "Mejais Soulstealer", "Increases Spell Power on kills.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(SpellSchoolUtil.allOffensiveMagicSchools().stream().map(school -> new AttributeModifier(school.id.toString(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)).toList())));
    public static Effects.Entry SUPERIOR_SHURELYAS_BATTLESONG = MoreRelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"superior_shurelyas_battlesong"), "Shurelya's Battlesong", "Increases Movement Speed.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(List.of(new AttributeModifier(Attributes.MOVEMENT_SPEED.getRegisteredName(), 0.75f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry SUPERIOR_MIKAELS_BLESSING = MoreRelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"superior_mikaels_blessing"), "Mikaels's Blessing", "Clears all harmful effects when applied.", (MobEffect)new MikaelsBlessingStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800)));
    public static Effects.Entry SUPERIOR_GUARDIAN_ANGEL = MoreRelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"superior_guardian_angel"), "Guardian Angel", "Cant move, jump or cast spells but you're invulnerable.", (MobEffect)new MikaelsBlessingStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(List.of(new AttributeModifier(Attributes.KNOCKBACK_RESISTANCE.getRegisteredName(), 10.0f, AttributeModifier.Operation.ADD_VALUE), new AttributeModifier(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE.getRegisteredName(), 10.0f, AttributeModifier.Operation.ADD_VALUE)))));

    private static Effects.Entry add(Effects.Entry entry) {
        entries.add(entry);
        return entry;
    }

    public static void register(ConfigFile.Effects config) {
        ActionImpairing.configure((MobEffect)MoreRelicEffects.GREATER_RAGE_POWER.effect, (EntityActionsAllowed)EntityActionsAllowed.SILENCE);
        ActionImpairing.configure((MobEffect)MoreRelicEffects.SUPERIOR_ZHONYAS_HOURGLASS.effect, (EntityActionsAllowed)EntityActionsAllowed.STUN);
        ActionImpairing.configure((MobEffect)MoreRelicEffects.SUPERIOR_GUARDIAN_ANGEL.effect, (EntityActionsAllowed)EntityActionsAllowed.STUN);
        for (Effects.Entry entry : entries) {
            Synchronized.configure((MobEffect)entry.effect, (boolean)true);
        }
        Effects.register(entries, (Map)config.effects);
    }
}

