/*
 * Decompiled with CFR 0.152.
 */
package more_relics.spell;

import java.util.ArrayList;
import java.util.List;
import more_relics.spell.MoreRelicEffects;
import more_relics.spell.MoreRelicSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.more_rpg_classes.custom.MoreSpellSchools;
import net.more_rpg_classes.sounds.ModSounds;
import net.relics_rpgs.spell.RelicSounds;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.effect.Effects;
import net.spell_engine.api.spell.ExternalSpellSchools;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.client.util.Color;
import net.spell_engine.fx.SpellEngineParticles;
import net.spell_engine.fx.SpellEngineSounds;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoreRelicSpells {
    public static final List<Entry> entries = new ArrayList<Entry>();
    private static final float T1_USE_EFFECT_DURATION = 10.0f;
    private static final float T1_PROC_EFFECT_DURATION = 6.0f;
    private static final float T1_USE_EFFECT_COOLDOWN = 60.0f;
    private static final float T1_PROC_EFFECT_COOLDOWN = 45.0f;
    private static final float T1_PROC_CHANCE = 0.05f;
    private static final float T2_USE_EFFECT_DURATION = 10.0f;
    private static final float T2_PROC_EFFECT_DURATION = 8.0f;
    private static final float T2_USE_EFFECT_COOLDOWN = 60.0f;
    private static final float T2_PROC_EFFECT_COOLDOWN = 45.0f;
    private static final float T2_PROC_CHANCE = 0.06f;
    private static final float T3_TRANCE_CHANCE = 0.1f;
    private static final float T3_TRANCE_DURATION = 10.0f;
    private static final float T3_TRANCE_COOLDOWN = 45.0f;
    private static final float T3_PERK_CC_DURATION = 2.0f;
    private static final float T3_PERK_CC_COOLDOWN = 20.0f;
    private static final float T3_PROC_CHANCE = 0.15f;
    private static final float T3_PROC_EFFECT_COOLDOWN = 30.0f;
    private static final float T3_PROC_EFFECT_DURATION = 10.0f;
    private static final float T3_ZONE_RANGE = 3.0f;
    private static final float T3_ZONE_DURATION = 10.0f;
    private static final float T4_USE_EFFECT_DURATION = 15.0f;
    private static final float T4_USE_EFFECT_COOLDOWN = 90.0f;
    private static final float T4_PROC_EFFECT_COOLDOWN = 60.0f;
    private static final float T4_PROC_EFFECT_DURATION = 15.0f;
    private static final float T4_PROC_CHANCE = 0.3f;
    private static final float T4_AREA_RANGE = 15.0f;
    private static final float T4_ZONE_RANGE = 3.0f;
    private static final ResourceLocation SPARK_DECELERATE = SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.DECELERATE).id();
    private static final ResourceLocation HEALING_PARTICLES = SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.DECELERATE).id();
    public static Entry lesser_proc_air_lightning = MoreRelicSpells.add(MoreRelicSpells.lesser_proc_air_lightning());
    public static Entry lesser_proc_earth_fire = MoreRelicSpells.add(MoreRelicSpells.lesser_proc_earth_fire());
    public static Entry lesser_proc_water_frost = MoreRelicSpells.add(MoreRelicSpells.lesser_proc_water_frost());
    public static Entry lesser_use_rage_power = MoreRelicSpells.add(MoreRelicSpells.lesser_use_rage_power());
    public static Entry medium_use_air_power = MoreRelicSpells.add(MoreRelicSpells.medium_use_air_power());
    public static Entry medium_use_earth_power = MoreRelicSpells.add(MoreRelicSpells.medium_use_earth_power());
    public static Entry medium_use_water_power = MoreRelicSpells.add(MoreRelicSpells.medium_use_water_power());
    public static Entry medium_perk_rage = MoreRelicSpells.add(MoreRelicSpells.medium_perk_rage());
    public static Entry medium_proc_lifesteal = MoreRelicSpells.add(MoreRelicSpells.medium_proc_lifesteal());
    public static Entry greater_proc_rage = MoreRelicSpells.add(MoreRelicSpells.greater_proc_rage());
    public static Entry greater_frozen_heart = MoreRelicSpells.add(MoreRelicSpells.greater_frozen_heart());
    public static Entry greater_kircheis_shard = MoreRelicSpells.add(MoreRelicSpells.greater_kircheis_shard());
    public static Entry greater_madreds_bloodrazor = MoreRelicSpells.add(MoreRelicSpells.greater_madreds_bloodrazor());
    public static Entry greater_liandrys_torment = MoreRelicSpells.add(MoreRelicSpells.greater_liandrys_torment());
    public static Entry greater_sunfire_cape = MoreRelicSpells.add(MoreRelicSpells.greater_sunfire_cape());
    public static Entry superior_zhonyas_hourglass = MoreRelicSpells.add(MoreRelicSpells.superior_zhonyas_hourglass());
    public static Entry superior_mejais_soulstealer = MoreRelicSpells.add(MoreRelicSpells.superior_mejais_soulstealer());
    public static Entry superior_shurelyas_battlesong = MoreRelicSpells.add(MoreRelicSpells.superior_shurelyas_battlesong());
    public static Entry superior_mikaels_blessing = MoreRelicSpells.add(MoreRelicSpells.superior_mikaels_blessing());
    public static Entry superior_guardian_angel = MoreRelicSpells.add(MoreRelicSpells.superior_guardian_angel());

    private static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    private static Spell activeSpellBase() {
        Spell spell = new Spell();
        spell.range = 0.0f;
        spell.tier = 0;
        spell.type = Spell.Type.ACTIVE;
        spell.active = new Spell.Active();
        spell.tooltip = new Spell.Tooltip();
        spell.tooltip.show_header = false;
        spell.tooltip.name = new Spell.Tooltip.LineOptions(false, false);
        spell.tooltip.description.color = ChatFormatting.DARK_GREEN.getSerializedName();
        spell.tooltip.description.show_in_compact = true;
        return spell;
    }

    private static Spell passiveSpellBase() {
        Spell spell = new Spell();
        spell.range = 0.0f;
        spell.tier = 7;
        spell.type = Spell.Type.PASSIVE;
        spell.passive = new Spell.Passive();
        spell.tooltip = new Spell.Tooltip();
        spell.tooltip.show_header = false;
        spell.tooltip.name = new Spell.Tooltip.LineOptions(false, false);
        spell.tooltip.description.color = ChatFormatting.DARK_GREEN.getSerializedName();
        spell.tooltip.description.show_in_compact = true;
        return spell;
    }

    private static Spell.Impact createEffectImpact(String effectIdString, float duration) {
        Spell.Impact buff = new Spell.Impact();
        buff.action = new Spell.Impact.Action();
        buff.action.type = Spell.Impact.Action.Type.STATUS_EFFECT;
        buff.action.status_effect = new Spell.Impact.Action.StatusEffect();
        buff.action.status_effect.effect_id = effectIdString;
        buff.action.status_effect.duration = duration;
        return buff;
    }

    private static void configureCooldown(Spell spell, float duration) {
        if (spell.cost == null) {
            spell.cost = new Spell.Cost();
        }
        if (spell.cost.cooldown == null) {
            spell.cost.cooldown = new Spell.Cost.Cooldown();
        }
        spell.cost.cooldown.duration = duration;
    }

    @NotNull
    private static ParticleBatch lesserActivateParticles(Color color, int count) {
        return MoreRelicSpells.lesserActivateParticles(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.DECELERATE).id().toString(), count).color(color.toRGBA());
    }

    @NotNull
    private static ParticleBatch lesserActivateParticles(String particleId, int count) {
        return new ParticleBatch(particleId, ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, (float)count, 0.14f, 0.15f);
    }

    private static Spell.TargetCondition deadCondition() {
        Spell.TargetCondition deadCondition = new Spell.TargetCondition();
        deadCondition.health_percent_below = 0.0f;
        deadCondition.health_percent_above = 0.0f;
        return deadCondition;
    }

    private static Spell.Trigger killedBySpellTrigger() {
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
        trigger.impact = new Spell.Trigger.ImpactCondition();
        trigger.impact.impact_type = Spell.Impact.Action.Type.DAMAGE.toString();
        Spell.TargetCondition deadCondition = MoreRelicSpells.deadCondition();
        trigger.target_conditions = List.of(deadCondition);
        return trigger;
    }

    private static Spell.Trigger deathPlayer() {
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.type = Spell.Trigger.Type.DAMAGE_TAKEN;
        trigger.impact = new Spell.Trigger.ImpactCondition();
        trigger.impact.impact_type = Spell.Impact.Action.Type.DAMAGE.toString();
        Spell.TargetCondition deadCondition = MoreRelicSpells.deadCondition();
        trigger.target_conditions = List.of(deadCondition);
        return trigger;
    }

    private static Spell.Impact createHeal(float coefficient) {
        Spell.Impact buff = new Spell.Impact();
        buff.action = new Spell.Impact.Action();
        buff.action.type = Spell.Impact.Action.Type.HEAL;
        buff.action.heal = new Spell.Impact.Action.Heal();
        buff.action.heal.spell_power_coefficient = coefficient;
        return buff;
    }

    private static Entry lesser_proc_air_lightning() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"lesser_proc_air_lightning");
        String description = "On spell hit: {trigger_chance} chance to increase air and lightning spell power by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = MoreRelicEffects.LESSER_POWER_AIR_LIGHTNING;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (AttributeModifier.Operation)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = MoreRelicSpells.passiveSpellBase();
        spell.school = MoreSpellSchools.AIR;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 0.05f;
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_ANY;
        trigger.spell = new Spell.Trigger.SpellCondition();
        trigger.spell.archetype = SpellSchool.Archetype.MAGIC;
        spell.passive.triggers = List.of(trigger);
        spell.release.animation = "spell_engine:one_handed_healing_release";
        spell.release.sound = new Sound(RelicSounds.INTELLECT_BUFF.id().toString());
        spell.release.particles = new ParticleBatch[]{MoreRelicSpells.lesserActivateParticles("more_rpg_classes:small_gust", 12), MoreRelicSpells.lesserActivateParticles(SpellEngineParticles.electric_arc_A.id().toString(), 12)};
        spell.impacts = List.of(MoreRelicSpells.createEffectImpact(effect.id.toString(), 6.0f));
        MoreRelicSpells.configureCooldown(spell, 45.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry lesser_proc_earth_fire() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"lesser_proc_earth_fire");
        String description = "On spell hit: {trigger_chance} chance to increase earth and fire spell power by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = MoreRelicEffects.LESSER_POWER_EARTH_FIRE;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (AttributeModifier.Operation)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = MoreRelicSpells.passiveSpellBase();
        spell.school = MoreSpellSchools.EARTH;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 0.05f;
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_ANY;
        trigger.spell = new Spell.Trigger.SpellCondition();
        trigger.spell.archetype = SpellSchool.Archetype.MAGIC;
        spell.passive.triggers = List.of(trigger);
        spell.release.animation = "spell_engine:one_handed_healing_release";
        spell.release.sound = new Sound(RelicSounds.INTELLECT_BUFF.id().toString());
        spell.release.particles = new ParticleBatch[]{MoreRelicSpells.lesserActivateParticles("more_rpg_classes:stone_particle", 12), MoreRelicSpells.lesserActivateParticles(SpellEngineParticles.flame_spark.id().toString(), 12)};
        spell.impacts = List.of(MoreRelicSpells.createEffectImpact(effect.id.toString(), 6.0f));
        MoreRelicSpells.configureCooldown(spell, 45.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry lesser_proc_water_frost() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"lesser_proc_water_frost");
        String description = "On spell hit: {trigger_chance} chance to increase water and frost spell power by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = MoreRelicEffects.LESSER_POWER_WATER_FROST;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (AttributeModifier.Operation)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = MoreRelicSpells.passiveSpellBase();
        spell.school = MoreSpellSchools.WATER;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 0.05f;
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_ANY;
        trigger.spell = new Spell.Trigger.SpellCondition();
        trigger.spell.archetype = SpellSchool.Archetype.MAGIC;
        spell.passive.triggers = List.of(trigger);
        spell.release.animation = "spell_engine:one_handed_healing_release";
        spell.release.sound = new Sound(RelicSounds.INTELLECT_BUFF.id().toString());
        spell.release.particles = new ParticleBatch[]{MoreRelicSpells.lesserActivateParticles("more_rpg_classes:big_splash", 12), MoreRelicSpells.lesserActivateParticles(Color.FROST, 12)};
        spell.impacts = List.of(MoreRelicSpells.createEffectImpact(effect.id.toString(), 6.0f));
        MoreRelicSpells.configureCooldown(spell, 45.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry lesser_use_rage_power() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"lesser_use_rage_power");
        String description = "Use: Increases rage by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = MoreRelicEffects.LESSER_RAGE_POWER;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (AttributeModifier.Operation)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = MoreRelicSpells.activeSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        spell.release.animation = "spell_engine:dual_handed_ground_release";
        spell.release.sound = new Sound(MoreRelicSounds.RAGE_POWDER.id().toString());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.smoke_medium.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.1f, 0.1f).color(Color.RAGE.toRGBA()), new ParticleBatch(SpellEngineParticles.smoke_medium.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 25.0f, 0.1f, 0.5f, 0.0f, 2.0f).color(Color.RAGE.toRGBA())};
        spell.impacts = List.of(MoreRelicSpells.createEffectImpact(effect.id.toString(), 10.0f));
        MoreRelicSpells.configureCooldown(spell, 60.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry medium_use_air_power() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"medium_use_air_power");
        String description = "Use: Increases air spell power by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = MoreRelicEffects.MEDIUM_AIR_POWER;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (AttributeModifier.Operation)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = MoreRelicSpells.activeSpellBase();
        spell.school = MoreSpellSchools.AIR;
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = new Sound(RelicSounds.INTELLECT_BUFF.id().toString());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch("more_rpg_classes:small_gust", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.1f, 0.1f), new ParticleBatch("more_rpg_classes:small_gust", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.12f, 0.12f)};
        spell.impacts = List.of(MoreRelicSpells.createEffectImpact(effect.id.toString(), 10.0f));
        MoreRelicSpells.configureCooldown(spell, 60.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry medium_use_earth_power() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"medium_use_earth_power");
        String description = "Use: Increases earth spell power by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = MoreRelicEffects.MEDIUM_EARTH_POWER;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (AttributeModifier.Operation)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = MoreRelicSpells.activeSpellBase();
        spell.school = MoreSpellSchools.EARTH;
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = new Sound(RelicSounds.INTELLECT_BUFF.id().toString());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch("more_rpg_classes:stone_particle", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.1f, 0.1f), new ParticleBatch("more_rpg_classes:stone_particle", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.12f, 0.12f)};
        spell.impacts = List.of(MoreRelicSpells.createEffectImpact(effect.id.toString(), 10.0f));
        MoreRelicSpells.configureCooldown(spell, 60.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry medium_use_water_power() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"medium_use_water_power");
        String description = "Use: Increases water spell power by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = MoreRelicEffects.MEDIUM_WATER_POWER;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (AttributeModifier.Operation)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = MoreRelicSpells.activeSpellBase();
        spell.school = MoreSpellSchools.WATER;
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = new Sound(RelicSounds.INTELLECT_BUFF.id().toString());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch("more_rpg_classes:bubble", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.1f, 0.1f), new ParticleBatch("more_rpg_classes:big_splash", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.12f, 0.12f)};
        spell.impacts = List.of(MoreRelicSpells.createEffectImpact(effect.id.toString(), 10.0f));
        MoreRelicSpells.configureCooldown(spell, 60.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry medium_perk_rage() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"medium_perk_rage");
        String title = "Mardroeme Mushroom";
        String description = "On melee hit: {trigger_chance} chance to get into a berserk stage for {effect_duration} seconds.";
        Spell spell = MoreRelicSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.type = Spell.Trigger.Type.MELEE_IMPACT;
        trigger.chance = 0.06f;
        spell.passive.triggers = List.of(trigger);
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.smoke_medium.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.GROUND, ParticleBatch.Rotation.LOOK, 0.4f, 1.0f, 1.0f, 0.0f, 2.0f).color(Color.RAGE.toRGBA())};
        spell.impacts = List.of(MoreRelicSpells.createEffectImpact(MoreRelicEffects.MEDIUM_RAGE_POWER.id.toString(), 8.0f));
        MoreRelicSpells.configureCooldown(spell, 45.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry medium_proc_lifesteal() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"medium_proc_lifesteal");
        String description = "On melee and spell hit: {trigger_chance_1} chance to increase lifesteal and spell vampire by {bonus} for {effect_duration} seconds.";
        Effects.Entry effect = MoreRelicEffects.MEDIUM_LIFESTEAL_POWER;
        String title = effect.title;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (AttributeModifier.Operation)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = MoreRelicSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 0.06f;
        trigger.type = Spell.Trigger.Type.MELEE_IMPACT;
        Spell.Trigger trigger2 = new Spell.Trigger();
        trigger2.chance = 0.06f;
        trigger2.type = Spell.Trigger.Type.SPELL_IMPACT_ANY;
        spell.passive.triggers = List.of(trigger, trigger2);
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = new Sound(RelicSounds.BLOODLUST_ACTIVATE.id().toString());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.dripping_blood.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 20.0f, 0.2f, 0.8f), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.FLOAT).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.CENTER, 15.0f, 0.02f, 0.1f).color(Color.RAGE.toRGBA())};
        spell.impacts = List.of(MoreRelicSpells.createEffectImpact(effect.id.toString(), 8.0f));
        MoreRelicSpells.configureCooldown(spell, 45.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry greater_proc_rage() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"greater_proc_rage");
        Effects.Entry effect = MoreRelicEffects.GREATER_RAGE_POWER;
        String title = "Svablod's Ritual";
        float health_threshold = 0.25f;
        String description = "Taking damage below {health_threshold} health, reduces incoming damage by {bonus}, increases rage by {bonus2} and attack speed by {bonus3} for {effect_duration} seconds.";
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = (AttributeModifier)effect.config().attributes().get(1);
            AttributeModifier modifier2 = (AttributeModifier)effect.config().attributes().get(0);
            AttributeModifier modifier3 = (AttributeModifier)effect.config().attributes().get(2);
            String bonus = SpellTooltip.bonus((float)modifier.value, (AttributeModifier.Operation)modifier.operation);
            String bonus2 = SpellTooltip.bonus((float)modifier2.value, (AttributeModifier.Operation)modifier2.operation);
            String bonus3 = SpellTooltip.bonus((float)modifier3.value, (AttributeModifier.Operation)modifier3.operation);
            return args.description().replace("{health_threshold}", SpellTooltip.percent((float)health_threshold)).replace("{bonus}", bonus).replace("{bonus2}", bonus2).replace("{bonus3}", bonus3);
        };
        Spell spell = MoreRelicSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        Spell.Trigger trigger = new Spell.Trigger();
        Spell.TargetCondition healthCondition = new Spell.TargetCondition();
        healthCondition.health_percent_below = health_threshold;
        trigger.caster_conditions = List.of(healthCondition);
        trigger.type = Spell.Trigger.Type.DAMAGE_TAKEN;
        trigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        spell.passive.triggers = List.of(trigger);
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.smoke_medium.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.GROUND, 50.0f, 1.0f, 1.8f).color(Color.RAGE.toRGBA()), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.STRIPE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.FLOAT).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, ParticleBatch.Rotation.LOOK, 20.0f, 1.0f, 1.0f, 0.0f, 2.5f).color(Color.RAGE.toRGBA())};
        spell.impacts = List.of(MoreRelicSpells.createEffectImpact(MoreRelicEffects.GREATER_RAGE_POWER.id.toString(), 5.0f));
        MoreRelicSpells.configureCooldown(spell, 45.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry greater_frozen_heart() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"greater_frozen_heart");
        Effects.Entry effect = MoreRelicEffects.GREATER_FROZEN_HEART;
        String title = effect.title;
        String description = "On taking damage: {trigger_chance} chance to reduce the attack and movement speed of nearby enemies by {bonus} for {effect_duration} seconds.";
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (AttributeModifier.Operation)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = MoreRelicSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        spell.range = 5.0f;
        spell.release.sound = new Sound(ModSounds.FROST_CRACKLE_ID.toString());
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 0.3f;
        trigger.type = Spell.Trigger.Type.DAMAGE_TAKEN;
        spell.passive.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.AREA;
        spell.target.area = new Spell.Target.Area();
        spell.target.area.vertical_range_multiplier = 1.0f;
        Spell.Impact debuff = MoreRelicSpells.createEffectImpact(effect.id.toString(), 10.0f);
        debuff.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.frost_shard.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.55f, 0.8f), new ParticleBatch(SpellEngineParticles.snowflake.id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 15.0f, 0.2f, 0.2f)};
        spell.impacts = List.of(debuff);
        MoreRelicSpells.configureCooldown(spell, 30.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry greater_kircheis_shard() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"greater_kircheis_shard");
        String description = "On arrow hit: {trigger_chance} chance to create a electric field for {cloud_duration} seconds dealing {damage} damage.";
        String title = "Kircheis Shard";
        Spell spell = MoreRelicSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_RANGED;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 0.15f;
        trigger.type = Spell.Trigger.Type.ARROW_IMPACT;
        spell.passive.triggers = List.of(trigger);
        spell.deliver.type = Spell.Delivery.Type.CLOUD;
        spell.deliver.delay = 5;
        Spell.Delivery.Cloud cloud = new Spell.Delivery.Cloud();
        cloud.volume.radius = 3.0f;
        cloud.volume.area.vertical_range_multiplier = 0.5f;
        cloud.time_to_live_seconds = 10.0f;
        cloud.impact_tick_interval = 20;
        cloud.client_data = new Spell.Delivery.Cloud.ClientData();
        cloud.client_data.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.electric_arc_A.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 5.0f, 0.0f, 0.0f), new ParticleBatch(SpellEngineParticles.electric_arc_B.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 5.0f, 0.0f, 0.0f)};
        spell.deliver.clouds = List.of(cloud);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        spell.release.sound = new Sound(MoreRelicSounds.KIRCHEIS_SHARD_PROC.id());
        Spell.Impact damage = new Spell.Impact();
        damage.action = new Spell.Impact.Action();
        damage.action.type = Spell.Impact.Action.Type.DAMAGE;
        damage.action.damage = new Spell.Impact.Action.Damage();
        damage.action.damage.spell_power_coefficient = 0.35f;
        damage.sound = Sound.withVolume((ResourceLocation)MoreRelicSounds.KIRCHEIS_SHARD_IMPACT.id(), (float)0.5f);
        spell.impacts = List.of(damage);
        MoreRelicSpells.configureCooldown(spell, 30.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry greater_madreds_bloodrazor() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"greater_madreds_bloodrazor");
        String description = "On melee hit: {trigger_chance_1} to receive increased attack speed by {bonus} and deal additional damage according to {max_health_damage} of the targets max health every hit.";
        String title = "Madred's Bloodrazor";
        Effects.Entry effect = MoreRelicEffects.GREATER_MADREDS_BLOODRAZOR;
        Spell spell = MoreRelicSpells.passiveSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier_effect = effect.config().firstModifier();
            String bonus_effect = SpellTooltip.bonus((float)modifier_effect.value, (AttributeModifier.Operation)modifier_effect.operation);
            String modifiedDescription = args.description();
            Spell.Impact.Action.Damage max_health_damage = ((Spell.Impact)spell.impacts.get((int)0)).action.damage;
            if (max_health_damage != null) {
                modifiedDescription = modifiedDescription.replace("{max_health_damage}", SpellTooltip.percent((float)max_health_damage.spell_power_coefficient));
            }
            return modifiedDescription.replace("{bonus}", bonus_effect);
        };
        Spell.Trigger trigger_passive = new Spell.Trigger();
        trigger_passive.chance = 0.15f;
        trigger_passive.type = Spell.Trigger.Type.MELEE_IMPACT;
        trigger_passive.target_override = Spell.Trigger.TargetSelector.CASTER;
        spell.passive.triggers = List.of(trigger_passive);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Trigger trigger_stash = new Spell.Trigger();
        trigger_stash.type = Spell.Trigger.Type.MELEE_IMPACT;
        spell.deliver.type = Spell.Delivery.Type.STASH_EFFECT;
        spell.deliver.stash_effect = new Spell.Delivery.StashEffect();
        spell.deliver.stash_effect.id = effect.id.toString();
        spell.deliver.stash_effect.consume = 0;
        spell.deliver.stash_effect.duration = 10.0f;
        spell.deliver.stash_effect.triggers = List.of(trigger_stash);
        Spell.Impact damage = new Spell.Impact();
        damage.attribute = Attributes.MAX_HEALTH.getRegisteredName();
        damage.attribute_from_target = true;
        damage.action = new Spell.Impact.Action();
        damage.action.type = Spell.Impact.Action.Type.DAMAGE;
        damage.action.damage = new Spell.Impact.Action.Damage();
        damage.action.damage.spell_power_coefficient = 0.03f;
        damage.sound = Sound.withVolume((ResourceLocation)MoreRelicSounds.MADREDS_BLOODRAZOR_IMPACT.id(), (float)1.25f);
        damage.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.dripping_blood.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 20.0f, 0.2f, 0.8f), new ParticleBatch("more_rpg_classes:blood_drop", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, 20.0f, 0.2f, 0.8f)};
        spell.impacts = List.of(damage);
        MoreRelicSpells.configureCooldown(spell, 45.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry greater_liandrys_torment() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"greater_liandrys_torment");
        String title = "Liandry's Torment";
        String description = "On spell hit: {trigger_chance} chance to torment the target for {effect_duration} seconds, damaging according to 3%% of the targets max health per second.";
        Spell spell = MoreRelicSpells.passiveSpellBase();
        spell.school = SpellSchools.ARCANE;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
        trigger.impact = new Spell.Trigger.ImpactCondition();
        trigger.impact.impact_type = Spell.Impact.Action.Type.DAMAGE.toString();
        trigger.chance = 0.15f;
        spell.passive.triggers = List.of(trigger);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Impact debuff = MoreRelicSpells.createEffectImpact(MoreRelicEffects.GREATER_LIANDRYS_TORMENT.id.toString(), 10.0f);
        debuff.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.ADD;
        debuff.action.status_effect.amplifier = 1;
        debuff.action.status_effect.amplifier_cap = 4;
        debuff.sound = new Sound(MoreRelicSounds.LIANDRYS_TORMENT_PROC.id());
        debuff.action.status_effect.refresh_duration = false;
        spell.impacts = List.of(debuff);
        MoreRelicSpells.configureCooldown(spell, 45.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry greater_sunfire_cape() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"greater_sunfire_cape");
        String description = "On damage taken and dealt: {trigger_chance_1} to deal {max_health_damage} damage of your max health around you. ";
        Effects.Entry effect = MoreRelicEffects.GREATER_SUNFIRE_CAPE;
        String title = effect.title;
        Spell spell = MoreRelicSpells.passiveSpellBase();
        spell.range = 4.0f;
        spell.school = SpellSchools.FIRE;
        SpellTooltip.DescriptionMutator mutator = args -> {
            String modifiedDescription = args.description();
            Spell.Impact.Action.Damage max_health_damage = ((Spell.Impact)spell.impacts.get((int)0)).action.damage;
            if (max_health_damage != null) {
                modifiedDescription = modifiedDescription.replace("{max_health_damage}", SpellTooltip.percent((float)max_health_damage.spell_power_coefficient));
            }
            return modifiedDescription;
        };
        Spell.Trigger trigger_damage_taken = new Spell.Trigger();
        trigger_damage_taken.chance = 0.15f;
        trigger_damage_taken.type = Spell.Trigger.Type.DAMAGE_TAKEN;
        trigger_damage_taken.target_override = Spell.Trigger.TargetSelector.CASTER;
        Spell.Trigger trigger_damage_dealt = new Spell.Trigger();
        trigger_damage_dealt.chance = 0.15f;
        trigger_damage_dealt.type = Spell.Trigger.Type.MELEE_IMPACT;
        trigger_damage_dealt.target_override = Spell.Trigger.TargetSelector.CASTER;
        spell.passive.triggers = List.of(trigger_damage_taken, trigger_damage_dealt);
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Trigger trigger_stash_damage_dealt = new Spell.Trigger();
        trigger_stash_damage_dealt.type = Spell.Trigger.Type.MELEE_IMPACT;
        Spell.Trigger trigger_stash_damage_taken = new Spell.Trigger();
        trigger_stash_damage_taken.type = Spell.Trigger.Type.DAMAGE_TAKEN;
        spell.deliver.type = Spell.Delivery.Type.STASH_EFFECT;
        spell.deliver.stash_effect = new Spell.Delivery.StashEffect();
        spell.deliver.stash_effect.duration = 10.0f;
        spell.deliver.stash_effect.id = effect.id.toString();
        spell.deliver.stash_effect.consume = 0;
        spell.deliver.stash_effect.triggers = List.of(trigger_stash_damage_dealt, trigger_stash_damage_taken);
        Spell.Impact damage = new Spell.Impact();
        damage.attribute = Attributes.MAX_HEALTH.getRegisteredName();
        damage.attribute_from_target = false;
        damage.action = new Spell.Impact.Action();
        damage.action.type = Spell.Impact.Action.Type.DAMAGE;
        damage.action.damage = new Spell.Impact.Action.Damage();
        damage.action.damage.spell_power_coefficient = 0.04f;
        damage.sound = Sound.withVolume((ResourceLocation)SpellEngineSounds.GENERIC_FIRE_IGNITE.id(), (float)1.0f);
        damage.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.flame.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 20.0f, 0.2f, 0.8f)};
        spell.impacts = List.of(damage);
        spell.area_impact = new Spell.AreaImpact();
        spell.area_impact.radius = 4.0f;
        MoreRelicSpells.configureCooldown(spell, 45.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry superior_zhonyas_hourglass() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"superior_zhonyas_hourglass");
        String description = "Use: Become invulnerable for {effect_duration} seconds, you cant move, attack or cast spells.";
        Effects.Entry effect = MoreRelicEffects.SUPERIOR_ZHONYAS_HOURGLASS;
        String title = effect.title;
        Spell spell = MoreRelicSpells.activeSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        spell.release.animation = "spell_engine:dual_handed_weapon_charge";
        spell.release.sound = Sound.withVolume((ResourceLocation)MoreRelicSounds.ZHONYAS_HOURGLASS.id(), (float)0.75f);
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.HOLY, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 20.0f, 0.1f, 0.4f)};
        spell.impacts = List.of(MoreRelicSpells.createEffectImpact(effect.id.toString(), 3.0f));
        MoreRelicSpells.configureCooldown(spell, 90.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry superior_mejais_soulstealer() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"superior_mejais_soulstealer");
        Effects.Entry effect = MoreRelicEffects.SUPERIOR_MEJAIS_SOULSTEALER;
        String title = effect.title;
        String description = "Defeating enemies grants you spell power by {bonus}, stacking up to {effect_amplifier_cap} times for {effect_duration} seconds.";
        Spell spell = MoreRelicSpells.passiveSpellBase();
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)Math.abs(modifier.value), (AttributeModifier.Operation)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        spell.school = SpellSchools.ARCANE;
        Spell.Trigger trigger = MoreRelicSpells.killedBySpellTrigger();
        trigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        spell.passive.triggers = List.of(trigger);
        spell.deliver.type = Spell.Delivery.Type.STASH_EFFECT;
        spell.deliver.stash_effect = new Spell.Delivery.StashEffect();
        spell.deliver.stash_effect.id = effect.id.toString();
        spell.deliver.stash_effect.consume = 0;
        Spell.Trigger stashTrigger = MoreRelicSpells.killedBySpellTrigger();
        stashTrigger.type = Spell.Trigger.Type.SPELL_IMPACT_ANY;
        stashTrigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        spell.deliver.stash_effect.triggers = List.of(stashTrigger);
        Spell.Impact buff = MoreRelicSpells.createEffectImpact(MoreRelicEffects.SUPERIOR_MEJAIS_SOULSTEALER.id.toString(), 20.0f);
        buff.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.ADD;
        buff.action.status_effect.amplifier = 1;
        buff.action.status_effect.amplifier_cap = 9;
        buff.action.status_effect.refresh_duration = false;
        spell.impacts = List.of(buff);
        MoreRelicSpells.configureCooldown(spell, 60.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry superior_shurelyas_battlesong() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"superior_shurelyas_battlesong");
        Effects.Entry effect = MoreRelicEffects.SUPERIOR_SHURELYAS_BATTLESONG;
        String title = effect.title;
        String description = "Use: Increase movement speed by {bonus} for {effect_duration} seconds and reduces spell cooldowns for allies.";
        SpellTooltip.DescriptionMutator mutator = args -> {
            AttributeModifier modifier = effect.config().firstModifier();
            String bonus = SpellTooltip.bonus((float)modifier.value, (AttributeModifier.Operation)modifier.operation);
            return args.description().replace("{bonus}", bonus);
        };
        Spell spell = MoreRelicSpells.activeSpellBase();
        spell.range = 10.0f;
        spell.school = SpellSchools.HEALING;
        spell.release.sound = new Sound(MoreRelicSounds.SHURELYAS_BATTLESONG_ACTIVATE.id());
        spell.target.type = Spell.Target.Type.AREA;
        spell.target.area = new Spell.Target.Area();
        spell.target.area.vertical_range_multiplier = 1.0f;
        spell.target.area.include_caster = true;
        Spell.Impact buff = MoreRelicSpells.createEffectImpact(effect.id.toString(), 7.5f);
        buff.particles = new ParticleBatch[0];
        Spell.Impact impact = new Spell.Impact();
        impact.action = new Spell.Impact.Action();
        impact.action.type = Spell.Impact.Action.Type.COOLDOWN;
        impact.action.cooldown = new Spell.Impact.Action.Cooldown();
        impact.action.cooldown.actives = new Spell.Impact.Action.Cooldown.Modify();
        impact.action.cooldown.actives.duration_multiplier = 0.8f;
        impact.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.sign_speed.id().toString(), ParticleBatch.Shape.LINE_VERTICAL, ParticleBatch.Origin.CENTER, 1.0f, 0.75f, 0.75f).scale(1.2f).color(Color.WHITE.toRGBA()).followEntity(true)};
        spell.impacts = List.of(buff, impact);
        MoreRelicSpells.configureCooldown(spell, 90.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry superior_mikaels_blessing() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"superior_mikaels_blessing");
        Effects.Entry effect = MoreRelicEffects.SUPERIOR_MIKAELS_BLESSING;
        String title = effect.title;
        String description = "Use: Heals you or the targeted ally for {heal_percent} of your max health and cleanses all harmful effects.";
        SpellTooltip.DescriptionMutator mutator = args -> {
            String modifiedDescription = args.description();
            Spell spell = (Spell)args.spellEntry().value();
            Spell.Impact.Action.Heal heal = ((Spell.Impact)spell.impacts.get((int)0)).action.heal;
            if (heal != null) {
                modifiedDescription = modifiedDescription.replace("{heal_percent}", SpellTooltip.percent((float)heal.spell_power_coefficient));
            }
            return modifiedDescription;
        };
        Spell spell = MoreRelicSpells.activeSpellBase();
        spell.school = SpellSchools.HEALING;
        spell.range = 16.0f;
        spell.release.animation = "spell_engine:one_handed_healing_release";
        spell.release.sound = new Sound(MoreRelicSounds.MIKAELS_BLESSING_ACTIVATE.id());
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.target.aim.use_caster_as_fallback = true;
        Spell.Impact buff = MoreRelicSpells.createEffectImpact(effect.id.toString(), 1.0f);
        Spell.Impact heal = MoreRelicSpells.createHeal(0.15f);
        heal.attribute = Attributes.MAX_HEALTH.getRegisteredName();
        heal.sound = new Sound(SpellEngineSounds.GENERIC_HEALING_IMPACT_1.id());
        heal.particles = new ParticleBatch[]{new ParticleBatch(HEALING_PARTICLES.toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 20.0f, 0.02f, 0.15f), new ParticleBatch(SPARK_DECELERATE.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 40.0f, 0.3f, 0.3f).color(Color.HOLY.toRGBA())};
        spell.impacts = List.of(heal, buff);
        MoreRelicSpells.configureCooldown(spell, 90.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry superior_guardian_angel() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"more_relics", (String)"superior_guardian_angel");
        String title = "Guardian Angel";
        Effects.Entry effect = MoreRelicEffects.SUPERIOR_GUARDIAN_ANGEL;
        float health_threshold = 0.15f;
        String description = "Taking damage below {health_threshold} health, makes you invulnerable for {effect_duration} seconds and heals you for {health_percent} of your maximum health.";
        SpellTooltip.DescriptionMutator mutator = args -> {
            String modifiedDescription = args.description();
            Spell spell = (Spell)args.spellEntry().value();
            Spell.Impact.Action.Heal heal = ((Spell.Impact)spell.impacts.get((int)0)).action.heal;
            if (heal != null) {
                modifiedDescription = modifiedDescription.replace("{health_percent}", SpellTooltip.percent((float)heal.spell_power_coefficient));
            }
            return modifiedDescription.replace("{health_threshold}", SpellTooltip.percent((float)health_threshold));
        };
        Spell spell = MoreRelicSpells.passiveSpellBase();
        spell.school = SpellSchools.HEALING;
        spell.release.animation = "more_relics:guardian_angel";
        spell.release.sound = Sound.withVolume((ResourceLocation)MoreRelicSounds.GUARDIAN_ANGEL_ACTIVATE.id(), (float)1.25f);
        Spell.Trigger trigger = new Spell.Trigger();
        Spell.TargetCondition healthCondition = new Spell.TargetCondition();
        healthCondition.health_percent_below = health_threshold;
        trigger.caster_conditions = List.of(healthCondition);
        trigger.type = Spell.Trigger.Type.DAMAGE_TAKEN;
        trigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        spell.passive.triggers = List.of(trigger);
        Spell.Impact heal = MoreRelicSpells.createHeal(0.65f);
        heal.attribute = Attributes.MAX_HEALTH.getRegisteredName();
        heal.sound = new Sound(SpellEngineSounds.GENERIC_HEALING_IMPACT_1.id());
        heal.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.area_circle_1.id().toString(), ParticleBatch.Shape.LINE_VERTICAL, ParticleBatch.Origin.FEET, 1.0f, 0.2f, 0.2f).followEntity(true).scale(0.8f).maxAge(0.8f).color(Color.WHITE.toRGBA())};
        Spell.Impact buff = MoreRelicSpells.createEffectImpact(effect.id.toString(), 4.0f);
        spell.impacts = List.of(heal, buff);
        MoreRelicSpells.configureCooldown(spell, 90.0f);
        return new Entry(id, spell, title, description, mutator);
    }

    public record Entry(ResourceLocation id, Spell spell, String title, String description, @Nullable SpellTooltip.DescriptionMutator mutator) {
    }
}

