/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.models.bbmodel;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelParts;
import com.razz.decocraft.models.bbmodel.BlockbenchBakery;
import com.razz.decocraft.models.bbmodel.BlockbenchLoader;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.SimpleUnbakedGeometry;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;

public class BlockbenchModel
extends SimpleUnbakedGeometry<BlockbenchModel> {
    private final BlockbenchBakery BAKERY = new BlockbenchBakery();
    private final BlockbenchLoader.BlockbenchSetting settings;
    private final List<BBModelParts.Element> elements;
    private final BBModelParts.Resolution resolution;

    public BlockbenchModel(BlockbenchLoader.BlockbenchSetting settings, BBModel model) {
        this.settings = settings;
        this.elements = model.elements;
        this.resolution = model.resolution;
    }

    protected void addQuads(IGeometryBakingContext owner, IModelBuilder<?> modelBuilder, ModelBakery baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
        BBModelParts.Element rootNode = null;
        for (BBModelParts.Element element : this.elements) {
            if (!Objects.equals(element.name.toLowerCase(), "root_node") || !Objects.equals(element.type, "locator")) continue;
            rootNode = element;
        }
        for (BBModelParts.Element element : this.elements) {
            if (element.faces == null) continue;
            for (Direction direction : element.faces.keySet()) {
                BBModelParts.Face face = element.faces.get(direction);
                String textureString = this.settings.material;
                Material renderMaterial = UnbakedGeometryHelper.resolveDirtyMaterial((String)textureString, (IGeometryBakingContext)owner);
                TextureAtlasSprite texture = spriteGetter.apply(renderMaterial);
                modelBuilder.addUnculledFace(this.BAKERY.bakeQuad(element, this.settings, rootNode, face.uv, this.resolution, texture, direction, modelTransform));
            }
        }
    }

    public Collection<Material> getMaterials(IGeometryBakingContext owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet textures = Sets.newHashSet();
        for (BBModelParts.Element element : this.elements) {
            if (element.faces == null) continue;
            for (BBModelParts.Face face : element.faces.values()) {
                String textureString = this.settings.material;
                Material texture = UnbakedGeometryHelper.resolveDirtyMaterial((String)textureString, (IGeometryBakingContext)owner);
                if (Objects.equals(texture, MissingTextureAtlasSprite.m_118071_().toString())) {
                    missingTextureErrors.add((Pair<String, String>)Pair.of((Object)textureString, (Object)owner.getModelName()));
                }
                textures.add(texture);
            }
        }
        return textures;
    }
}

