/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.items;

import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.ModuleBlocks;
import com.razz.decocraft.common.blocks.DecoAnimatedBlock;
import com.razz.decocraft.common.blocks.DecoBedBlock;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import com.razz.decocraft.common.underlay.UnderlayData;
import com.razz.decocraft.common.underlay.UnderlayManager;
import com.razz.decocraft.network.DecocraftPacketHandler;
import com.razz.decocraft.network.server.SSyncUnderlayAdd;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ToolModelSwitch
extends Item {
    public ToolModelSwitch(Item.Properties settings) {
        super(settings);
    }

    public InteractionResult useOn(UseOnContext context) {
        Direction clickedSide;
        BlockPos underlayPos;
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = world.getBlockState(pos);
        UnderlayManager underlayManager = UnderlayManager.get(world);
        if (underlayManager.hasUnderlay(underlayPos = pos.relative(clickedSide = context.getClickedFace()))) {
            if (world.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            return this.switchUnderlayUsingScript(world, underlayPos, underlayManager);
        }
        if (underlayManager.hasUnderlay(pos)) {
            if (world.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            return this.switchUnderlayUsingScript(world, pos, underlayManager);
        }
        Block block = state.getBlock();
        if (block instanceof DecocraftBlock) {
            DecocraftBlock block2 = (DecocraftBlock)block;
            if (world.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            block2.onToolModelSwitch(state, world, pos);
            return InteractionResult.CONSUME;
        }
        block = state.getBlock();
        if (block instanceof DecoAnimatedBlock) {
            DecoAnimatedBlock animatedBlock = (DecoAnimatedBlock)block;
            if (world.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            animatedBlock.onToolModelSwitch(state, world, pos);
            return InteractionResult.CONSUME;
        }
        block = state.getBlock();
        if (block instanceof DecoBedBlock) {
            DecoBedBlock bedBlock = (DecoBedBlock)block;
            if (world.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            bedBlock.onToolModelSwitch(state, world, pos);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private InteractionResult switchUnderlayUsingScript(Level world, BlockPos pos, UnderlayManager manager) {
        UnderlayData current = manager.getUnderlay(pos);
        if (!current.isValid()) {
            return InteractionResult.PASS;
        }
        String currentMaterial = current.getMaterialId();
        JsonContainer.Entry currentEntry = ModuleBlocks.MAT_TO_ENTRY.get(currentMaterial);
        if (currentEntry == null) {
            return InteractionResult.PASS;
        }
        if (currentEntry.script == null || currentEntry.script.tool_modelswitch == null || currentEntry.script.tool_modelswitch.link == null) {
            return InteractionResult.PASS;
        }
        String nextMaterialId = currentEntry.script.tool_modelswitch.link;
        if (!ModuleBlocks.MAT_TO_ENTRY.containsKey(nextMaterialId)) {
            return InteractionResult.PASS;
        }
        JsonContainer.Entry nextEntry = ModuleBlocks.MAT_TO_ENTRY.get(nextMaterialId);
        UnderlayData newUnderlay = new UnderlayData(nextEntry.model, nextMaterialId, current.getFacing());
        manager.setUnderlay(pos, newUnderlay);
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            SSyncUnderlayAdd packet = SSyncUnderlayAdd.createPacket(pos, newUnderlay);
            for (ServerPlayer serverPlayer : serverWorld.players()) {
                DecocraftPacketHandler.sendToPlayer(packet, serverPlayer);
            }
        }
        world.playSound(null, pos, SoundEvents.WOOL_PLACE, SoundSource.BLOCKS, 0.5f, 1.2f);
        return InteractionResult.CONSUME;
    }
}

