/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.underlay;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;

public class UnderlayData {
    public static final UnderlayData NONE = new UnderlayData("", "", Direction.UP);
    private final String modelId;
    private final String materialId;
    private final Direction facing;

    public UnderlayData(String modelId, String materialId, Direction facing) {
        this.modelId = modelId != null ? modelId : "";
        this.materialId = materialId != null ? materialId : "";
        this.facing = facing != null ? facing : Direction.UP;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getMaterialId() {
        return this.materialId;
    }

    public Direction getFacing() {
        return this.facing;
    }

    public boolean isValid() {
        return !this.modelId.isEmpty() && !this.materialId.isEmpty();
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("modelId", this.modelId);
        nbt.putString("materialId", this.materialId);
        nbt.putString("facing", this.facing.getName());
        return nbt;
    }

    public static UnderlayData fromNbt(CompoundTag nbt) {
        if (nbt == null) {
            return NONE;
        }
        String facingName = nbt.getString("facing");
        Direction facing = Direction.UP;
        try {
            facing = Direction.byName((String)facingName);
            if (facing == null) {
                facing = Direction.UP;
            }
        }
        catch (Exception e) {
            facing = Direction.UP;
        }
        return new UnderlayData(nbt.getString("modelId"), nbt.getString("materialId"), facing);
    }
}

