/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.models.bbmodel;

import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelParts;
import com.razz.decocraft.models.libgdx.Matrix4;
import com.razz.decocraft.models.libgdx.Quaternion;
import com.razz.decocraft.models.libgdx.Vector3;
import java.util.Objects;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BBHitBox {
    private static final Matrix4[] TRANSFORM = new Matrix4[]{new Matrix4(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}), new Matrix4(new float[]{-1.0f, 0.0f, 8.742278E-8f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -8.742278E-8f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}), new Matrix4(new float[]{5.9604645E-8f, 0.0f, 0.99999994f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -0.99999994f, 0.0f, 5.9604645E-8f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}), new Matrix4(new float[]{5.9604645E-8f, 0.0f, -0.99999994f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.99999994f, 0.0f, 5.9604645E-8f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f})};
    private static final Vector3 HALF = new Vector3(0.5f, 0.5f, 0.5f);

    public static VoxelShape[] parse(float scale, BBModel model) {
        BBModelParts.Locator rootNode = null;
        for (BBModelParts.ElementBase elementBase : model.elements) {
            if (!(elementBase instanceof BBModelParts.Locator)) continue;
            BBModelParts.Locator locator = (BBModelParts.Locator)elementBase;
            if (!Objects.equals(locator.name.toLowerCase(), "root_node")) continue;
            rootNode = locator;
        }
        VoxelShape[] shapeDir = new VoxelShape[4];
        for (int dir = 0; dir < 4; ++dir) {
            Double[] boundingBox = new Double[]{Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, -1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308};
            for (BBModelParts.ElementBase elementBase : model.elements) {
                if (!(elementBase instanceof BBModelParts.Element)) continue;
                BBModelParts.Element element = (BBModelParts.Element)elementBase;
                if (element.faces == null) continue;
                AABB bounds = BBHitBox.getHitBox(element, rootNode, scale, TRANSFORM[dir]);
                boundingBox[0] = Math.min(bounds.minX, boundingBox[0]);
                boundingBox[1] = Math.min(bounds.minY, boundingBox[1]);
                boundingBox[2] = Math.min(bounds.minZ, boundingBox[2]);
                boundingBox[3] = Math.max(bounds.maxX, boundingBox[3]);
                boundingBox[4] = Math.max(bounds.maxY, boundingBox[4]);
                boundingBox[5] = Math.max(bounds.maxZ, boundingBox[5]);
            }
            shapeDir[dir] = Shapes.box((double)boundingBox[0], (double)boundingBox[1], (double)boundingBox[2], (double)boundingBox[3], (double)boundingBox[4], (double)boundingBox[5]);
        }
        return shapeDir;
    }

    private static AABB getHitBox(BBModelParts.Element element, BBModelParts.Locator rootNode, float scale, Matrix4 transform) {
        Vector3 from = new Vector3(element.from.x / 16.0f, element.from.y / 16.0f, element.from.z / 16.0f);
        Vector3 to = new Vector3(element.to.x / 16.0f, element.to.y / 16.0f, element.to.z / 16.0f);
        BBHitBox.applyElementRotation(from, element);
        BBHitBox.applyElementRotation(to, element);
        Matrix4 mat4 = new Matrix4();
        mat4.setToScaling(scale, scale, scale);
        BBHitBox.applyTransform(from, mat4);
        BBHitBox.applyTransform(to, mat4);
        mat4.setToTranslation(0.5f, 0.0f, 0.5f);
        BBHitBox.applyTransform(from, mat4);
        BBHitBox.applyTransform(to, mat4);
        if (rootNode != null && rootNode.position != null) {
            mat4.setToTranslation(-rootNode.position.x / 16.0f, -rootNode.position.y / 16.0f, -rootNode.position.z / 16.0f);
            BBHitBox.applyTransform(from, mat4);
            BBHitBox.applyTransform(to, mat4);
        }
        BBHitBox.rotateVertexBy(from, HALF, transform);
        BBHitBox.rotateVertexBy(to, HALF, transform);
        return new AABB((double)Math.min(from.x, to.x), (double)Math.min(from.y, to.y), (double)Math.min(from.z, to.z), (double)Math.max(from.x, to.x), (double)Math.max(from.y, to.y), (double)Math.max(from.z, to.z));
    }

    private static void applyTransform(Vector3 pos, Matrix4 trans) {
        pos.set(trans.val[0] * pos.x + trans.val[4] * pos.y + trans.val[8] * pos.z + trans.val[12] * 1.0f, trans.val[1] * pos.x + trans.val[5] * pos.y + trans.val[9] * pos.z + trans.val[13] * 1.0f, trans.val[2] * pos.x + trans.val[6] * pos.y + trans.val[10] * pos.z + trans.val[14] * 1.0f);
    }

    private static void rotateVertexBy(Vector3 pos, Vector3 origin, Matrix4 mat4) {
        Vector3 delta = new Vector3(pos.x - origin.x, pos.y - origin.y, pos.z - origin.z);
        BBHitBox.applyTransform(delta, mat4);
        pos.set(delta.x + origin.x, delta.y + origin.y, delta.z + origin.z);
    }

    private static void applyElementRotation(Vector3 pos, BBModelParts.Element element) {
        Vector3 origin = new Vector3(element.origin.x, element.origin.y, element.origin.z);
        Vector3 rotation = element.rotation;
        BBModelParts.OutlinerGroup parent = element.parent;
        Quaternion quaternion = new Quaternion();
        while (true) {
            if (rotation.x != 0.0f) {
                quaternion.set(Vector3.X, rotation.x);
                BBHitBox.rotateVertexBy(pos, new Vector3(origin.x / 16.0f, origin.y / 16.0f, origin.z / 16.0f), new Matrix4(quaternion));
            }
            if (rotation.y != 0.0f) {
                quaternion.set(Vector3.Y, rotation.y);
                BBHitBox.rotateVertexBy(pos, new Vector3(origin.x / 16.0f, origin.y / 16.0f, origin.z / 16.0f), new Matrix4(quaternion));
            }
            if (rotation.z != 0.0f) {
                quaternion.set(Vector3.Z, rotation.z);
                BBHitBox.rotateVertexBy(pos, new Vector3(origin.x / 16.0f, origin.y / 16.0f, origin.z / 16.0f), new Matrix4(quaternion));
            }
            if (parent == null) break;
            origin = parent.origin;
            rotation = parent.rotation;
            parent = parent.parent;
        }
    }
}

