/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.models.bbmodel;

import com.google.common.collect.Sets;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelParts;
import com.razz.decocraft.models.bbmodel.BlockbenchBakery;
import com.razz.decocraft.models.bbmodel.BlockbenchLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;

public class BlockbenchModel
implements BakedModel {
    private final BlockbenchBakery BAKERY = new BlockbenchBakery();
    private final BlockbenchLoader.BlockbenchSetting settings;
    private final List<BBModelParts.ElementBase> elements;
    private final BBModelParts.Resolution resolution;
    private final List<BakedQuad> bakedQuads;
    private final Map<Direction, List<BakedQuad>> faceQuads;
    private final TextureAtlasSprite particleSprite;
    private final ModelState bakeSettings;

    public BlockbenchModel(BlockbenchLoader.BlockbenchSetting settings, BBModel model, Function<ResourceLocation, TextureAtlasSprite> spriteGetter) {
        this(settings, model, spriteGetter, null);
    }

    public BlockbenchModel(BlockbenchLoader.BlockbenchSetting settings, BBModel model, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ModelState bakeSettings) {
        this.settings = settings;
        this.elements = model.elements;
        this.resolution = model.resolution;
        this.bakeSettings = bakeSettings;
        ResourceLocation particleId = ResourceLocation.parse((String)settings.material);
        this.particleSprite = spriteGetter.apply(particleId);
        this.faceQuads = new HashMap<Direction, List<BakedQuad>>();
        this.bakedQuads = this.buildQuads(spriteGetter);
    }

    private List<BakedQuad> buildQuads(Function<ResourceLocation, TextureAtlasSprite> spriteGetter) {
        ArrayList<BakedQuad> quadList = new ArrayList<BakedQuad>();
        for (Direction dir : Direction.values()) {
            this.faceQuads.put(dir, new ArrayList());
        }
        BBModelParts.Locator rootNode = null;
        for (BBModelParts.ElementBase elementBase : this.elements) {
            if (!(elementBase instanceof BBModelParts.Locator)) continue;
            BBModelParts.Locator locator = (BBModelParts.Locator)elementBase;
            if (!Objects.equals(locator.name.toLowerCase(), "root_node")) continue;
            rootNode = locator;
        }
        ResourceLocation textureId = ResourceLocation.parse((String)this.settings.material);
        TextureAtlasSprite texture = spriteGetter.apply(textureId);
        for (BBModelParts.ElementBase elementBase : this.elements) {
            if (!(elementBase instanceof BBModelParts.Element)) continue;
            BBModelParts.Element element = (BBModelParts.Element)elementBase;
            if (element.faces == null) continue;
            for (Direction direction : element.faces.keySet()) {
                BakedQuad quad;
                BBModelParts.Face face = element.faces.get(direction);
                if (face.texture < 0 || face.uv == null || texture == null || (quad = this.BAKERY.bakeQuad(element, this.settings, rootNode, face.uv, this.resolution, texture, direction, this.bakeSettings != null ? this.bakeSettings.getRotation().getMatrix() : new Matrix4f())) == null) continue;
                quadList.add(quad);
                if (!this.faceQuads.containsKey(direction)) continue;
                this.faceQuads.get(direction).add(quad);
            }
        }
        return quadList;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction face, RandomSource random) {
        if (face == null) {
            if (state != null && state.getBlock() instanceof DecocraftBlock) {
                DecocraftBlock decoBlock = (DecocraftBlock)state.getBlock();
                if (decoBlock.meta.flipbook != null && decoBlock.meta.flipbook.images > 1) {
                    return this.bakedQuads;
                }
            }
            return this.bakedQuads;
        }
        return this.faceQuads.getOrDefault(face, Collections.emptyList());
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return true;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.particleSprite;
    }

    public ItemTransforms getTransforms() {
        return ItemTransforms.NO_TRANSFORMS;
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public Collection<ResourceLocation> getTextures() {
        HashSet textures = Sets.newHashSet();
        for (BBModelParts.ElementBase elementBase : this.elements) {
            if (!(elementBase instanceof BBModelParts.Element)) continue;
            BBModelParts.Element element = (BBModelParts.Element)elementBase;
            if (element.faces == null) continue;
            for (BBModelParts.Face face : element.faces.values()) {
                String textureString = this.settings.material;
                String namespace = "decocraft";
                String path = textureString;
                if (textureString.contains(":")) {
                    String[] parts = textureString.split(":", 2);
                    namespace = parts[0];
                    path = parts[1];
                }
                ResourceLocation textureId = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
                textures.add(textureId);
            }
        }
        return textures;
    }
}

