/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.network;

import com.razz.decocraft.network.client.CDecobenchClick;
import com.razz.decocraft.network.client.CDecobenchCraft;
import com.razz.decocraft.network.client.CDecobenchScroll;
import com.razz.decocraft.network.client.CDecobenchSearch;
import com.razz.decocraft.network.client.CDecobenchSelectTab;
import com.razz.decocraft.network.client.CDecomposerCraft;
import com.razz.decocraft.network.server.SSyncAllUnderlays;
import com.razz.decocraft.network.server.SSyncUnderlayAdd;
import com.razz.decocraft.network.server.SSyncUnderlayRemove;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class DecocraftPacketHandler {
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("decocraft").versioned("1.0").optional();
        DecocraftPacketHandler.registerClientToServer(registrar);
        DecocraftPacketHandler.registerServerToClient(registrar);
    }

    private static void registerClientToServer(PayloadRegistrar registrar) {
        registrar.playToServer(CDecobenchClick.TYPE, CDecobenchClick.STREAM_CODEC, CDecobenchClick::handle);
        registrar.playToServer(CDecobenchCraft.TYPE, CDecobenchCraft.STREAM_CODEC, CDecobenchCraft::handle);
        registrar.playToServer(CDecobenchScroll.TYPE, CDecobenchScroll.STREAM_CODEC, CDecobenchScroll::handle);
        registrar.playToServer(CDecobenchSearch.TYPE, CDecobenchSearch.STREAM_CODEC, CDecobenchSearch::handle);
        registrar.playToServer(CDecobenchSelectTab.TYPE, CDecobenchSelectTab.STREAM_CODEC, CDecobenchSelectTab::handle);
        registrar.playToServer(CDecomposerCraft.TYPE, CDecomposerCraft.STREAM_CODEC, CDecomposerCraft::handle);
    }

    private static void registerServerToClient(PayloadRegistrar registrar) {
        registrar.playToClient(SSyncUnderlayAdd.TYPE, SSyncUnderlayAdd.STREAM_CODEC, SSyncUnderlayAdd::handle);
        registrar.playToClient(SSyncUnderlayRemove.TYPE, SSyncUnderlayRemove.STREAM_CODEC, SSyncUnderlayRemove::handle);
        registrar.playToClient(SSyncAllUnderlays.TYPE, SSyncAllUnderlays.STREAM_CODEC, SSyncAllUnderlays::handle);
    }

    public static <T extends CustomPacketPayload> void sendToServer(T payload) {
        PacketDistributor.sendToServer(payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <T extends CustomPacketPayload> void sendToPlayer(T payload, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

