/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.network.server;

import com.razz.decocraft.common.underlay.UnderlayData;
import com.razz.decocraft.common.underlay.UnderlayManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SSyncAllUnderlays(Map<BlockPos, UnderlayData> underlays) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SSyncAllUnderlays> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"decocraft", (String)"sync_all_underlays"));
    public static final StreamCodec<FriendlyByteBuf, SSyncAllUnderlays> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, SSyncAllUnderlays>(){

        public void encode(FriendlyByteBuf buf, SSyncAllUnderlays payload) {
            buf.writeInt(payload.underlays.size());
            for (Map.Entry<BlockPos, UnderlayData> entry : payload.underlays.entrySet()) {
                BlockPos pos = entry.getKey();
                UnderlayData data = entry.getValue();
                buf.writeBlockPos(pos);
                buf.writeUtf(data.getModelId());
                buf.writeUtf(data.getMaterialId());
                buf.writeEnum((Enum)data.getFacing());
            }
        }

        public SSyncAllUnderlays decode(FriendlyByteBuf buf) {
            int count = buf.readInt();
            HashMap<BlockPos, UnderlayData> underlays = new HashMap<BlockPos, UnderlayData>();
            for (int i = 0; i < count; ++i) {
                BlockPos pos = buf.readBlockPos();
                String modelId = buf.readUtf();
                String materialId = buf.readUtf();
                Direction facing = (Direction)buf.readEnum(Direction.class);
                underlays.put(pos, new UnderlayData(modelId, materialId, facing));
            }
            return new SSyncAllUnderlays(underlays);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static SSyncAllUnderlays createPacket(Map<BlockPos, UnderlayData> underlays) {
        return new SSyncAllUnderlays(underlays);
    }

    public static void handle(SSyncAllUnderlays payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft client = Minecraft.getInstance();
            if (client.level == null) {
                return;
            }
            UnderlayManager manager = UnderlayManager.get((Level)client.level);
            for (Map.Entry<BlockPos, UnderlayData> entry : payload.underlays.entrySet()) {
                manager.setUnderlay(entry.getKey(), entry.getValue());
            }
        });
    }
}

