/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.network.server;

import com.razz.decocraft.common.underlay.UnderlayData;
import com.razz.decocraft.common.underlay.UnderlayManager;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SSyncUnderlayAdd(BlockPos pos, String modelId, String materialId, Direction facing) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SSyncUnderlayAdd> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"decocraft", (String)"sync_underlay_add"));
    public static final StreamCodec<FriendlyByteBuf, SSyncUnderlayAdd> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SSyncUnderlayAdd::pos, (StreamCodec)StreamCodec.of((buf, str) -> buf.writeUtf(str), FriendlyByteBuf::readUtf), SSyncUnderlayAdd::modelId, (StreamCodec)StreamCodec.of((buf, str) -> buf.writeUtf(str), FriendlyByteBuf::readUtf), SSyncUnderlayAdd::materialId, (StreamCodec)Direction.STREAM_CODEC, SSyncUnderlayAdd::facing, SSyncUnderlayAdd::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static SSyncUnderlayAdd createPacket(BlockPos pos, UnderlayData data) {
        return new SSyncUnderlayAdd(pos, data.getModelId(), data.getMaterialId(), data.getFacing());
    }

    public static void handle(SSyncUnderlayAdd payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft client = Minecraft.getInstance();
            if (client.level == null) {
                return;
            }
            UnderlayData data = new UnderlayData(payload.modelId, payload.materialId, payload.facing);
            UnderlayManager manager = UnderlayManager.get((Level)client.level);
            manager.setUnderlay(payload.pos, data);
        });
    }
}

