/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft;

import com.razz.decocraft.client.ClientHandler;
import com.razz.decocraft.common.DecoBedSleepHandler;
import com.razz.decocraft.common.ModuleBlocks;
import com.razz.decocraft.common.ModuleEntities;
import com.razz.decocraft.common.ModuleItems;
import com.razz.decocraft.common.ModuleScreenHandlers;
import com.razz.decocraft.common.ModuleSounds;
import com.razz.decocraft.common.ModuleTileEntities;
import com.razz.decocraft.common.blocks.DecoBedBlock;
import com.razz.decocraft.common.groups.GroupSelector;
import com.razz.decocraft.network.DecocraftPacketHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Decofabric
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"decocraft");
    private static final Map<UUID, class_2338> DECOCRAFT_SPAWN_POINTS = new HashMap<UUID, class_2338>();

    public void onInitialize() {
        LOGGER.info("Initializing Decocraft mod");
        LOGGER.info("Initializing ModuleBlocks...");
        ModuleBlocks.initialize();
        LOGGER.info("ModuleBlocks initialized successfully");
        LOGGER.info("Initializing ModuleItems...");
        ModuleItems.initialize();
        LOGGER.info("ModuleItems initialized successfully");
        LOGGER.info("Registering creative mode tabs...");
        GroupSelector.onCreativeModeTabRegister();
        LOGGER.info("Creative mode tabs registered successfully");
        LOGGER.info("Initializing ModuleEntities...");
        ModuleEntities.initialize();
        LOGGER.info("ModuleEntities initialized successfully");
        LOGGER.info("Initializing ModuleTileEntities...");
        ModuleTileEntities.initialize();
        LOGGER.info("ModuleTileEntities initialized successfully");
        LOGGER.info("Initializing ModuleSounds...");
        ModuleSounds.initialize();
        LOGGER.info("ModuleSounds initialized successfully");
        LOGGER.info("Initializing ModuleScreenHandlers...");
        ModuleScreenHandlers.initialize();
        LOGGER.info("ModuleScreenHandlers initialized successfully");
        LOGGER.info("Registering packet handlers...");
        DecocraftPacketHandler.registerServerReceivers();
        LOGGER.info("Packet handlers registered successfully");
        LOGGER.info("Registering bed sleep handler...");
        DecoBedSleepHandler.register();
        LOGGER.info("Bed sleep handler registered successfully");
        LOGGER.info("Registering player respawn events...");
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            if (!alive) {
                Decofabric.handleDecoBedRespawn(newPlayer);
            }
        });
        LOGGER.info("Player respawn events registered successfully");
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            LOGGER.info("Initializing client-side components...");
            this.initializeClient();
            LOGGER.info("Client-side components initialized successfully");
        }
        LOGGER.info("Decocraft mod initialization complete");
    }

    @Environment(value=EnvType.CLIENT)
    private void initializeClient() {
        ClientHandler.setup();
    }

    private static void handleDecoBedRespawn(class_3222 player) {
        UUID playerId = player.method_5667();
        class_2338 decoBedPos = DECOCRAFT_SPAWN_POINTS.get(playerId);
        if (decoBedPos != null) {
            class_3218 world = player.method_51469();
            class_2248 block = world.method_8320(decoBedPos).method_26204();
            if (block instanceof DecoBedBlock) {
                class_243 respawnPos = Decofabric.findSafeRespawnPosition((class_1937)world, decoBedPos);
                if (respawnPos != null) {
                    player.method_14251(world, respawnPos.field_1352, respawnPos.field_1351, respawnPos.field_1350, player.method_36454(), player.method_36455());
                    player.method_18799(class_243.field_1353);
                    player.field_6017 = 0.0f;
                }
            } else {
                DECOCRAFT_SPAWN_POINTS.remove(playerId);
            }
        }
    }

    public static void setDecoBedSpawnPoint(UUID playerId, class_2338 bedPos) {
        DECOCRAFT_SPAWN_POINTS.put(playerId, bedPos);
    }

    private static class_243 findSafeRespawnPosition(class_1937 world, class_2338 bedPos) {
        class_243[] positions;
        for (class_243 pos : positions = new class_243[]{class_243.method_24955((class_2382)bedPos.method_10084()), class_243.method_24955((class_2382)bedPos.method_10095().method_10084()), class_243.method_24955((class_2382)bedPos.method_10072().method_10084()), class_243.method_24955((class_2382)bedPos.method_10078().method_10084()), class_243.method_24955((class_2382)bedPos.method_10067().method_10084()), class_243.method_24955((class_2382)bedPos.method_10086(2))}) {
            class_2338 checkPos = class_2338.method_49638((class_2374)pos);
            if (!world.method_8320(checkPos).method_26215() || !world.method_8320(checkPos.method_10084()).method_26215() || world.method_8320(checkPos.method_10074()).method_26215()) continue;
            return pos;
        }
        return class_243.method_24955((class_2382)bedPos.method_10084());
    }

    public static class_2960 getResource(String name) {
        return class_2960.method_60655((String)"decocraft", (String)name);
    }
}

