/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.items;

import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.blocks.DecoWaterBlock;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import java.lang.reflect.Field;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DecoBlockItem
extends BlockItem {
    private static final float CRAFTING_SCALE = 32.0f;
    private int material = -1;
    private int red = -1;
    private int green = -1;
    private int blue = -1;

    public DecoBlockItem(Block block, Item.Properties settings) {
        super(block, settings);
        JsonContainer.Entry meta = null;
        try {
            Field metaField = null;
            Class<?> currentClass = block.getClass();
            while (currentClass != null && metaField == null) {
                try {
                    metaField = currentClass.getDeclaredField("meta");
                }
                catch (NoSuchFieldException e) {
                    currentClass = currentClass.getSuperclass();
                }
            }
            if (metaField != null) {
                metaField.setAccessible(true);
                Object metaObj = metaField.get(block);
                if (metaObj instanceof JsonContainer.Entry) {
                    meta = (JsonContainer.Entry)metaObj;
                }
            }
        }
        catch (Exception metaField) {
            // empty catch block
        }
        if (meta == null) {
            this.red = -1;
            this.green = -1;
            this.blue = -1;
            this.material = 1;
            return;
        }
        if (meta != null && meta.crafting_color[0] >= 0.0f && meta.crafting_color[1] >= 0.0f && meta.crafting_color[2] >= 0.0f) {
            this.red = Math.round(meta.crafting_color[0] / 100.0f * 32.0f);
            this.green = Math.round(meta.crafting_color[1] / 100.0f * 32.0f);
            this.blue = Math.round(meta.crafting_color[2] / 100.0f * 32.0f);
        } else if (meta != null) {
            // empty if block
        }
        if (block instanceof DecocraftBlock) {
            DecocraftBlock decoblock = (DecocraftBlock)block;
            try {
                AABB bounds = decoblock.getShape()[0].bounds();
                this.material = Math.min(Math.max((int)Math.ceil((bounds.maxX - bounds.minX) * (bounds.maxY - bounds.minY) * (bounds.maxZ - bounds.minZ)), 1), 10);
            }
            catch (UnsupportedOperationException e) {
                this.material = 1;
            }
        } else {
            this.material = 1;
        }
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getMaterial() {
        return this.material;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        BlockHitResult blockHitResult;
        BlockPos pos;
        if (!(this.getBlock() instanceof DecoWaterBlock)) {
            return super.use(world, player, hand);
        }
        ItemStack itemStack = player.getItemInHand(hand);
        BlockHitResult hitResult = DecoBlockItem.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hitResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (hitResult.getType() == HitResult.Type.BLOCK && (world.getBlockState(pos = (blockHitResult = hitResult).getBlockPos()).is(Blocks.WATER) || world.getFluidState(pos).is((Fluid)Fluids.WATER))) {
            BlockPlaceContext placementContext;
            InteractionResult result;
            BlockPos surfacePos = pos;
            while (world.getBlockState(surfacePos.above()).is(Blocks.WATER)) {
                surfacePos = surfacePos.above();
            }
            BlockPos placePos = surfacePos.above();
            if ((world.getBlockState(placePos).isAir() || world.getBlockState(placePos).canBeReplaced()) && (result = this.place(placementContext = new BlockPlaceContext(player, hand, itemStack, new BlockHitResult(Vec3.atCenterOf((Vec3i)placePos), Direction.UP, placePos, false)))).consumesAction()) {
                return InteractionResultHolder.success((Object)itemStack);
            }
        }
        return super.use(world, player, hand);
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        if (this.getBlock() instanceof DecoWaterBlock) {
            return this.canPlaceWaterBlock(context, state);
        }
        return super.canPlace(context, state);
    }

    public BlockPlaceContext updatePlacementContext(BlockPlaceContext context) {
        return context;
    }

    private boolean canPlaceWaterBlock(BlockPlaceContext context, BlockState state) {
        BlockPos belowPos;
        BlockPos targetPos = context.getClickedPos();
        Level world = context.getLevel();
        BlockState targetBlockState = world.getBlockState(targetPos);
        if (targetBlockState.is(Blocks.WATER) || world.getFluidState(targetPos).is((Fluid)Fluids.WATER)) {
            return true;
        }
        if (targetBlockState.isAir() && (world.getBlockState(belowPos = targetPos.below()).is(Blocks.WATER) || world.getFluidState(belowPos).is((Fluid)Fluids.WATER))) {
            return true;
        }
        belowPos = targetPos.below();
        BlockState belowState = world.getBlockState(belowPos);
        return belowState.isSolidRender((BlockGetter)world, belowPos);
    }
}

