/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common;

import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.blocks.DecoAnimatedBlock;
import com.razz.decocraft.common.blocks.DecoBedBlock;
import com.razz.decocraft.common.blocks.DecoSeatBlock;
import com.razz.decocraft.common.blocks.DecoStorageBlock;
import com.razz.decocraft.common.blocks.DecoWaterBlock;
import com.razz.decocraft.common.blocks.DecobenchBlock;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import com.razz.decocraft.common.blocks.DecomposerBlock;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelLoader;
import com.razz.decocraft.utils.JsonParser;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ModuleBlocks {
    public static Map<String, class_2248> DECOBLOCKS = Collections.synchronizedMap(new HashMap());
    public static final List<class_2248> DECOBLOCKS_TABS = new ArrayList<class_2248>();
    public static final Map<String, List<class_2248>> BLOCKS_PER_GROUP = Collections.synchronizedMap(new HashMap());
    public static class_2248[] SCRIPT_FLIPBOOK_TE_NEEDED = new class_2248[0];
    public static class_2248[] ANIMATED_TE_NEEDED = new class_2248[0];
    public static class_2248[] STORAGE_TE_NEEDED = new class_2248[0];
    public static class_2248[] DECOBENCH_TE_NEEDED = new class_2248[0];
    public static class_2248[] DECOMPOSER_TE_NEEDED = new class_2248[0];
    public static Map<String, BBModel> MAT_TO_BB_MODEL = Collections.synchronizedMap(new HashMap());
    public static Map<String, JsonContainer.Entry> MAT_TO_ENTRY = Collections.synchronizedMap(new HashMap());
    public static class_2248 DECOFAKE;
    private static final ConcurrentHashMap<String, BBModel> MODEL_CACHE;
    private static final int BATCH_SIZE = 50;
    private static List<class_2248> scriptTeNeeded;
    private static List<class_2248> animatedTeNeeded;
    private static List<class_2248> storageTeNeeded;
    private static List<class_2248> decobenchTeNeeded;
    private static List<class_2248> decomposerTeNeeded;

    public static void initialize() {
        System.out.println("Starting Decofabric block registration...");
        ModuleBlocks.registerDynamicBlocks();
    }

    private static void registerDynamicBlocks() {
        try {
            ModuleBlocks.loadBlocksFromResources();
        }
        catch (Exception e) {
            System.err.println("Failed to load dynamic blocks: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void loadBlocksFromResources() {
        List<JsonContainer.Entry> blockEntries = ModuleBlocks.loadFromCentralizedRegistry();
        System.out.println("Starting batched async model loading for " + blockEntries.size() + " entries...");
        long startTime = System.currentTimeMillis();
        ModuleBlocks.loadModelsInBatches(blockEntries);
        long modelLoadTime = System.currentTimeMillis();
        System.out.println("Model loading completed in " + (modelLoadTime - startTime) + "ms");
        for (JsonContainer.Entry entry : blockEntries) {
            ModuleBlocks.registerDynamicBlockWithCachedModel(entry);
        }
        SCRIPT_FLIPBOOK_TE_NEEDED = scriptTeNeeded.toArray(new class_2248[0]);
        ANIMATED_TE_NEEDED = animatedTeNeeded.toArray(new class_2248[0]);
        STORAGE_TE_NEEDED = storageTeNeeded.toArray(new class_2248[0]);
        DECOBENCH_TE_NEEDED = decobenchTeNeeded.toArray(new class_2248[0]);
        DECOMPOSER_TE_NEEDED = decomposerTeNeeded.toArray(new class_2248[0]);
        long totalTime = System.currentTimeMillis();
        System.out.println("Decofabric block registration complete - processed " + blockEntries.size() + " entries in " + (totalTime - startTime) + "ms");
    }

    private static List<JsonContainer.Entry> loadFromCentralizedRegistry() {
        ArrayList<JsonContainer.Entry> entries = new ArrayList<JsonContainer.Entry>();
        ArrayList<JsonContainer.Entry> boundingBoxes = new ArrayList<JsonContainer.Entry>();
        try {
            String registryPath = "assets/decocraft/decocraft.json";
            String[] paths = JsonParser.parseFiles(registryPath);
            if (paths != null) {
                for (String path : paths) {
                    try {
                        String fullPath = "assets/decocraft/" + path;
                        JsonContainer container = JsonParser.parseDecocraft(fullPath);
                        if (container.models != null) {
                            entries.addAll(Arrays.asList(container.models));
                        }
                        if (container.bounding_boxes == null) continue;
                        boundingBoxes.addAll(Arrays.asList(container.bounding_boxes));
                    }
                    catch (Exception e) {
                        System.err.println("Failed to load JSON file: " + path + " - " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load centralized registry: " + e.getMessage());
            e.printStackTrace();
        }
        ModuleBlocks.readBoundingBoxes(boundingBoxes);
        return entries;
    }

    private static void loadModelsInBatches(List<JsonContainer.Entry> blockEntries) {
        Set uniqueModels = blockEntries.stream().map(entry -> entry.model).filter(Objects::nonNull).collect(Collectors.toSet());
        ArrayList modelNames = new ArrayList(uniqueModels);
        System.out.println("Loading " + modelNames.size() + " unique models in batches of 50");
        for (int i = 0; i < modelNames.size(); i += 50) {
            int endIndex = Math.min(i + 50, modelNames.size());
            List batch = modelNames.subList(i, endIndex);
            System.out.println("Loading batch " + (i / 50 + 1) + "/" + (modelNames.size() + 50 - 1) / 50 + " (" + batch.size() + " models)");
            List<CompletableFuture> batchFutures = batch.stream().map(modelName -> CompletableFuture.runAsync(() -> {
                try {
                    BBModel model = ModuleBlocks.loadBBModelFromFile(modelName);
                    if (model != null) {
                        MODEL_CACHE.put((String)modelName, model);
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to load model " + modelName + " in batch: " + e.getMessage());
                }
            }, ForkJoinPool.commonPool())).collect(Collectors.toList());
            CompletableFuture<Void> batchCompletion = CompletableFuture.allOf(batchFutures.toArray(new CompletableFuture[0]));
            try {
                batchCompletion.join();
                continue;
            }
            catch (Exception e) {
                System.err.println("Error completing model loading batch: " + e.getMessage());
            }
        }
        System.out.println("Successfully cached " + MODEL_CACHE.size() + " models");
    }

    private static void registerDynamicBlockWithCachedModel(JsonContainer.Entry entry) {
        try {
            String uniqueId;
            if (entry == null || entry.material == null || entry.material.trim().isEmpty()) {
                return;
            }
            BBModel model = MODEL_CACHE.get(entry.model);
            if (model == null) {
                System.err.println("Model not found in cache: " + entry.model + " for entry: " + entry.material);
                return;
            }
            String string = uniqueId = entry.decoref != null ? entry.decoref : entry.material;
            if (uniqueId == null || uniqueId.trim().isEmpty()) {
                return;
            }
            if ("air".equals(uniqueId) || "minecraft:air".equals(uniqueId)) {
                return;
            }
            if (entry.script != null && entry.script.light > 0) {
                entry.lighting = entry.script.light;
            }
            MAT_TO_BB_MODEL.put(uniqueId, model);
            MAT_TO_ENTRY.put(uniqueId, entry);
            class_2248 block = ModuleBlocks.createBlock(entry, model);
            if (block == null || block == class_2246.field_10124) {
                return;
            }
            class_2960 blockId = class_2960.method_43902((String)"decocraft", (String)uniqueId);
            class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)blockId, (Object)block);
            DECOBLOCKS.put(uniqueId, block);
            DECOBLOCKS_TABS.add(block);
            if (!entry.hidden && !Objects.equals(entry.type, "fake_block")) {
                BLOCKS_PER_GROUP.computeIfAbsent(entry.tabs, k -> new ArrayList()).add(block);
            }
            if ("decobench".equals(uniqueId) || "decobench".equals(entry.type) || "nature_bench".equals(entry.type)) {
                decobenchTeNeeded.add(block);
            } else if ("decomposer".equals(uniqueId) || "decomposer".equals(entry.type) || "sprouting_table".equals(entry.type)) {
                decomposerTeNeeded.add(block);
            } else if (entry.script != null && entry.script.on_use != null && entry.script.on_use.storage != null && entry.script.on_use.storage.length == 2) {
                storageTeNeeded.add(block);
            } else if (Objects.equals(entry.type, "animated")) {
                animatedTeNeeded.add(block);
            } else if (entry.script != null && (entry.script.trigger != null || entry.script.on_use != null)) {
                scriptTeNeeded.add(block);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to register block " + entry.material + ": " + e.getMessage());
        }
    }

    private static void registerSimpleLightingVariants(JsonContainer.Entry originalEntry) {
        try {
            String unlitMaterial;
            String litMaterial = originalEntry.material + "_lit";
            if (!DECOBLOCKS.containsKey(litMaterial)) {
                ModuleBlocks.registerDynamicBlock(ModuleBlocks.createLightingVariant(originalEntry, litMaterial, true));
            }
            if (!DECOBLOCKS.containsKey(unlitMaterial = originalEntry.material + "_unlit")) {
                ModuleBlocks.registerDynamicBlock(ModuleBlocks.createLightingVariant(originalEntry, unlitMaterial, false));
            }
        }
        catch (Exception e) {
            System.err.println("Failed to register lighting variants for " + originalEntry.material + ": " + e.getMessage());
        }
    }

    private static JsonContainer.Entry createLightingVariant(JsonContainer.Entry original, String newMaterial, boolean isLit) {
        JsonContainer.Entry variant = new JsonContainer.Entry(original);
        variant.material = newMaterial;
        variant.hidden = true;
        if (variant.script == null) {
            variant.script = new JsonContainer.Script();
        }
        variant.lighting = isLit ? original.lighting : 0;
        return variant;
    }

    private static void registerDynamicBlock(JsonContainer.Entry entry) {
        try {
            String uniqueId;
            if (entry == null || entry.material == null || entry.material.trim().isEmpty()) {
                return;
            }
            BBModel model = ModuleBlocks.loadBBModelFromFile(entry.model);
            if (model == null) {
                return;
            }
            String string = uniqueId = entry.decoref != null ? entry.decoref : entry.material;
            if (uniqueId == null || uniqueId.trim().isEmpty()) {
                return;
            }
            if ("air".equals(uniqueId) || "minecraft:air".equals(uniqueId)) {
                return;
            }
            if (entry.script != null && entry.script.light > 0) {
                entry.lighting = entry.script.light;
            }
            MAT_TO_BB_MODEL.put(uniqueId, model);
            MAT_TO_ENTRY.put(uniqueId, entry);
            class_2248 block = ModuleBlocks.createBlock(entry, model);
            if (block == null || block == class_2246.field_10124) {
                return;
            }
            class_2960 blockId = class_2960.method_43902((String)"decocraft", (String)uniqueId);
            class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)blockId, (Object)block);
            DECOBLOCKS.put(uniqueId, block);
            DECOBLOCKS_TABS.add(block);
            if (!entry.hidden && !Objects.equals(entry.type, "fake_block")) {
                BLOCKS_PER_GROUP.computeIfAbsent(entry.tabs, k -> new ArrayList()).add(block);
            }
            if ("decobench".equals(uniqueId) || "decobench".equals(entry.type) || "nature_bench".equals(entry.type)) {
                decobenchTeNeeded.add(block);
            } else if ("decomposer".equals(uniqueId) || "decomposer".equals(entry.type) || "sprouting_table".equals(entry.type)) {
                decomposerTeNeeded.add(block);
            } else if (entry.script != null && entry.script.on_use != null && entry.script.on_use.storage != null && entry.script.on_use.storage.length == 2) {
                storageTeNeeded.add(block);
            } else if (Objects.equals(entry.type, "animated")) {
                animatedTeNeeded.add(block);
            } else if (entry.script != null && (entry.script.trigger != null || entry.script.on_use != null)) {
                scriptTeNeeded.add(block);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to register block " + entry.material + ": " + e.getMessage());
        }
    }

    private static void generateItemModelFile(String materialName) {
        try {
            Path texturePath = Paths.get("src/main/resources/assets/decocraft_nature/textures/item/" + materialName + ".png", new String[0]);
            if (!Files.exists(texturePath, new LinkOption[0])) {
                return;
            }
            String itemModelJson = String.format("{\n  \"parent\": \"item/generated\",\n  \"textures\": {\n    \"layer0\": \"decocraft_nature:item/%s\"\n  }\n}", materialName);
            Path itemModelPath = Paths.get("src/main/resources/assets/decocraft_nature/models/item/" + materialName + ".json", new String[0]);
            Files.createDirectories(itemModelPath.getParent(), new FileAttribute[0]);
            Files.write(itemModelPath, itemModelJson.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception e) {
            System.err.println("Failed to generate item model for " + materialName + ": " + e.getMessage());
        }
    }

    private static void generateBlockModelFile(String variantMaterial, String originalMaterial) {
        try {
            String blockModelJson = String.format("{\n  \"parent\": \"decocraft:block/%s\"\n}", originalMaterial);
            Path blockModelPath = Paths.get("src/main/resources/assets/decocraft_nature/models/block/" + variantMaterial + ".json", new String[0]);
            Files.createDirectories(blockModelPath.getParent(), new FileAttribute[0]);
            Files.write(blockModelPath, blockModelJson.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception e) {
            System.err.println("Failed to generate block model for " + variantMaterial + ": " + e.getMessage());
        }
    }

    private static BBModel loadBBModelFromFile(String modelName) {
        BBModel bBModel;
        block9: {
            String resourcePath = "assets/decocraft/models/bbmodel/" + modelName + ".bbmodel";
            InputStream stream = ModuleBlocks.class.getClassLoader().getResourceAsStream(resourcePath);
            if (stream == null) {
                System.err.println("Could not find BBModel resource: " + resourcePath);
                return null;
            }
            InputStream inputStream = stream;
            try {
                BBModel model;
                BBModelLoader loader = new BBModelLoader();
                bBModel = model = loader.loadModel(stream);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    System.err.println("Failed to load BBModel " + modelName + ": " + e.getMessage());
                    return null;
                }
            }
            inputStream.close();
        }
        return bBModel;
    }

    private static void collectModels(List<JsonContainer.Entry> models, List<JsonContainer.Entry> boundingBoxes) {
        try {
            String[] paths;
            for (String path : paths = JsonParser.parseFiles("assets/decocraft/decocraft.json")) {
                JsonContainer entries = JsonParser.parseDecocraft("assets/decocraft/" + path);
                if (entries.models != null) {
                    models.addAll(Arrays.asList(entries.models));
                }
                if (entries.bounding_boxes == null) continue;
                boundingBoxes.addAll(Arrays.asList(entries.bounding_boxes));
            }
        }
        catch (Exception e) {
            System.err.println("Failed to collect models: " + e.getMessage());
        }
    }

    private static void registerFlipbooks(List<JsonContainer.Entry> models) {
        ArrayList<JsonContainer.Entry> toAdd = new ArrayList<JsonContainer.Entry>();
        ArrayList<JsonContainer.Entry> toRemove = new ArrayList<JsonContainer.Entry>();
        for (JsonContainer.Entry meta : models) {
            if (meta.flipbook == null || meta.flipbook.images < 2) continue;
            for (int i = 0; i < meta.flipbook.images; ++i) {
                JsonContainer.Entry entry = new JsonContainer.Entry(meta);
                entry.material = String.format("%s.%02d", meta.material, i);
                if (i != 0) {
                    entry.hidden = true;
                }
                toAdd.add(entry);
            }
            toRemove.add(meta);
        }
        models.removeAll(toRemove);
        models.addAll(toAdd);
    }

    private static void readModels(List<JsonContainer.Entry> models, Map<String, BBModel> matToModel) {
        try {
            for (JsonContainer.Entry meta : models) {
                BBModel model = JsonParser.parseModel("assets/decocraft/models/bbmodel/" + meta.model + ".bbmodel");
                if (meta.shape == null) {
                    meta.shape = meta.material;
                }
                matToModel.put(meta.material, model);
                MAT_TO_BB_MODEL.put(meta.material, model);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to read models: " + e.getMessage());
        }
    }

    private static void readBoundingBoxes(List<JsonContainer.Entry> boundingBoxes) {
        try {
            for (JsonContainer.Entry meta : boundingBoxes) {
                BBModel model = JsonParser.parseModel("assets/decocraft/bounding_boxes/bbmodel/" + meta.model + ".bbmodel");
                String key = meta.material != null ? meta.material : meta.model;
                MAT_TO_BB_MODEL.put(key, model);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to read bounding boxes: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void registerModels(List<JsonContainer.Entry> models, Map<String, BBModel> matToModel) {
        ArrayList<class_2248> localScriptTeNeeded = new ArrayList<class_2248>();
        ArrayList<class_2248> localAnimatedTeNeeded = new ArrayList<class_2248>();
        for (JsonContainer.Entry meta : models) {
            BBModel model = matToModel.get(meta.material);
            class_2248 block = ModuleBlocks.createBlock(meta, model);
            class_2960 blockId = class_2960.method_43902((String)"decocraft", (String)meta.material);
            class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)blockId, (Object)block);
            DECOBLOCKS.put(meta.material, block);
            if (Objects.equals(meta.type, "fake_block")) {
                DECOFAKE = block;
            }
            if (meta.script != null && meta.script.trigger != null || meta.flipbook != null && meta.flipbook.images > 1) {
                localScriptTeNeeded.add(block);
                continue;
            }
            if (!Objects.equals(meta.type, "animated")) continue;
            localAnimatedTeNeeded.add(block);
        }
        SCRIPT_FLIPBOOK_TE_NEEDED = localScriptTeNeeded.toArray(new class_2248[0]);
        ANIMATED_TE_NEEDED = localAnimatedTeNeeded.toArray(new class_2248[0]);
        STORAGE_TE_NEEDED = storageTeNeeded.toArray(new class_2248[0]);
    }

    private static class_2248 createBlock(JsonContainer.Entry meta, BBModel model) {
        try {
            String uniqueId;
            String string = uniqueId = meta.decoref != null ? meta.decoref : meta.material;
            if ("decobench".equals(uniqueId)) {
                return new DecobenchBlock(meta, model);
            }
            if ("decomposer".equals(uniqueId)) {
                return new DecomposerBlock(meta, model);
            }
            if (meta.script != null && meta.script.on_use != null && meta.script.on_use.storage != null && meta.script.on_use.storage.length == 2) {
                return new DecoStorageBlock(meta, model);
            }
            if (meta.type != null) {
                switch (meta.type) {
                    case "painting": {
                        return new DecocraftBlock(meta, model);
                    }
                    case "bed": {
                        return new DecoBedBlock(meta, model);
                    }
                    case "seat": {
                        return new DecoSeatBlock(meta, model);
                    }
                    case "animated": {
                        return new DecoAnimatedBlock(meta, model);
                    }
                    case "water": {
                        return new DecoWaterBlock(meta, model);
                    }
                    case "decobench": {
                        return new DecobenchBlock(meta, model);
                    }
                    case "nature_bench": {
                        return new DecobenchBlock(meta, model);
                    }
                    case "decomposer": {
                        return new DecomposerBlock(meta, model);
                    }
                    case "sprouting_table": {
                        return new DecomposerBlock(meta, model);
                    }
                }
            }
            return new DecocraftBlock(meta, model);
        }
        catch (Exception e) {
            System.err.println("Error creating block for " + (meta.decoref != null ? meta.decoref : meta.material) + ": " + e.getMessage());
            return null;
        }
    }

    static {
        MODEL_CACHE = new ConcurrentHashMap();
        scriptTeNeeded = new ArrayList<class_2248>();
        animatedTeNeeded = new ArrayList<class_2248>();
        storageTeNeeded = new ArrayList<class_2248>();
        decobenchTeNeeded = new ArrayList<class_2248>();
        decomposerTeNeeded = new ArrayList<class_2248>();
    }
}

