/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.models.bbmodel;

import com.razz.decocraft.models.bbmodel.BBModelParts;
import com.razz.decocraft.models.bbmodel.BlockbenchLoader;
import com.razz.decocraft.models.libgdx.Matrix4;
import com.razz.decocraft.models.libgdx.Quaternion;
import com.razz.decocraft.models.libgdx.Vector3;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_777;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class BlockbenchBakery {
    private final Quaternion reusableQuaternion = new Quaternion();
    private final Matrix4 reusableMatrix = new Matrix4();
    private final Vector3 reusableVector = new Vector3();
    private static final Vector3 MODEL_ROTATION_CENTER = new Vector3(0.5f, 0.5f, 0.5f);
    private static final int MIN_X = 0;
    private static final int MIN_Y = 1;
    private static final int MIN_Z = 2;
    private static final int MAX_X = 3;
    private static final int MAX_Y = 4;
    private static final int MAX_Z = 5;
    private static final int[] FLIP_U = new int[]{3, 2, 1, 0};
    private static final int[] FLIP_V = new int[]{1, 0, 3, 2};

    private static VI[] faceVerts(class_2350 f) {
        switch (f) {
            case field_11033: {
                return new VI[]{new VI(0, 1, 5), new VI(0, 1, 2), new VI(3, 1, 2), new VI(3, 1, 5)};
            }
            case field_11036: {
                return new VI[]{new VI(0, 4, 5), new VI(3, 4, 5), new VI(3, 4, 2), new VI(0, 4, 2)};
            }
            case field_11043: {
                return new VI[]{new VI(3, 1, 2), new VI(0, 1, 2), new VI(0, 4, 2), new VI(3, 4, 2)};
            }
            case field_11035: {
                return new VI[]{new VI(0, 1, 5), new VI(3, 1, 5), new VI(3, 4, 5), new VI(0, 4, 5)};
            }
            case field_11039: {
                return new VI[]{new VI(0, 1, 2), new VI(0, 1, 5), new VI(0, 4, 5), new VI(0, 4, 2)};
            }
            case field_11034: {
                return new VI[]{new VI(3, 1, 5), new VI(3, 1, 2), new VI(3, 4, 2), new VI(3, 4, 5)};
            }
        }
        throw new IllegalArgumentException();
    }

    private static Axes faceAxes(class_2350 f) {
        switch (f) {
            case field_11033: {
                return new Axes(new Vector3(1.0f, 0.0f, 0.0f), new Vector3(0.0f, 0.0f, -1.0f));
            }
            case field_11036: {
                return new Axes(new Vector3(1.0f, 0.0f, 0.0f), new Vector3(0.0f, 0.0f, 1.0f));
            }
            case field_11043: {
                return new Axes(new Vector3(-1.0f, 0.0f, 0.0f), new Vector3(0.0f, -1.0f, 0.0f));
            }
            case field_11035: {
                return new Axes(new Vector3(1.0f, 0.0f, 0.0f), new Vector3(0.0f, -1.0f, 0.0f));
            }
            case field_11039: {
                return new Axes(new Vector3(0.0f, 0.0f, 1.0f), new Vector3(0.0f, -1.0f, 0.0f));
            }
            case field_11034: {
                return new Axes(new Vector3(0.0f, 0.0f, -1.0f), new Vector3(0.0f, -1.0f, 0.0f));
            }
        }
        throw new IllegalArgumentException();
    }

    private static int[] computeCornerMap(class_2350 direction, float[] positions) {
        Axes axes = BlockbenchBakery.faceAxes(direction);
        VI[] verts = BlockbenchBakery.faceVerts(direction);
        Vector3[] worldPositions = new Vector3[4];
        for (int i = 0; i < 4; ++i) {
            VI vi = verts[i];
            worldPositions[i] = new Vector3(positions[vi.x], positions[vi.y], positions[vi.z]);
        }
        float[] uCoords = new float[4];
        float[] vCoords = new float[4];
        for (int i = 0; i < 4; ++i) {
            uCoords[i] = worldPositions[i].dot(axes.u);
            vCoords[i] = worldPositions[i].dot(axes.v);
        }
        float minU = Float.MAX_VALUE;
        float maxU = -3.4028235E38f;
        float minV = Float.MAX_VALUE;
        float maxV = -3.4028235E38f;
        for (int i = 0; i < 4; ++i) {
            minU = Math.min(minU, uCoords[i]);
            maxU = Math.max(maxU, uCoords[i]);
            minV = Math.min(minV, vCoords[i]);
            maxV = Math.max(maxV, vCoords[i]);
        }
        int[] cornerMap = new int[4];
        for (int i = 0; i < 4; ++i) {
            boolean isBottom;
            boolean isLeft = Math.abs(uCoords[i] - minU) < Math.abs(uCoords[i] - maxU);
            boolean bl = isBottom = Math.abs(vCoords[i] - minV) < Math.abs(vCoords[i] - maxV);
            cornerMap[i] = isLeft && isBottom ? 0 : (isLeft && !isBottom ? 1 : (!isLeft && !isBottom ? 2 : 3));
        }
        return cornerMap;
    }

    private static Vector3 vec3iToVec3(class_2382 vec3i) {
        return new Vector3(vec3i.method_10263(), vec3i.method_10264(), vec3i.method_10260());
    }

    public class_777 bakeQuad(BBModelParts.Element element, BlockbenchLoader.BlockbenchSetting settings, BBModelParts.Element rootNode, BBModelParts.UVCoordinate uvs, BBModelParts.Resolution resolution, class_1058 texture, class_2350 direc, Matrix4f modelTransform) {
        float vHeight;
        float minUVArea = 0.1f;
        float uWidth = Math.abs(uvs.u1 - uvs.u0);
        if (uWidth * (vHeight = Math.abs(uvs.v1 - uvs.v0)) < minUVArea) {
            return null;
        }
        Vector3 geometryFrom = new Vector3(element.from.x, element.from.y, element.from.z);
        Vector3 geometryTo = new Vector3(element.to.x, element.to.y, element.to.z);
        class_2350 faceDirection = direc;
        int[] vertices = this.makeVertices(element, settings, rootNode, uvs, resolution, texture, faceDirection, this.setupShape(geometryFrom, geometryTo, element.inflate), modelTransform);
        class_2350 direction = faceDirection;
        this.fillNormals(vertices, direction);
        return new class_777(vertices, -1, direction, texture, true);
    }

    private int[] makeVertices(BBModelParts.Element element, BlockbenchLoader.BlockbenchSetting setting, BBModelParts.Element rootNode, BBModelParts.UVCoordinate uvs, BBModelParts.Resolution resolution, class_1058 texture, class_2350 direction, float[] positions, Matrix4f transformationMatrix) {
        int[] vertices = new int[32];
        int[] cornerMap = BlockbenchBakery.computeCornerMap(direction, positions);
        for (int i = 0; i < 4; ++i) {
            this.bakeVertexWithCorner(vertices, i, cornerMap[i], rootNode, direction, setting, uvs, resolution, positions, texture, transformationMatrix, element);
        }
        return vertices;
    }

    private void bakeVertexWithCorner(int[] vertices, int index, int uvCorner, BBModelParts.Element rootNode, class_2350 direction, BlockbenchLoader.BlockbenchSetting setting, BBModelParts.UVCoordinate uvs, BBModelParts.Resolution resolution, float[] positions, class_1058 texture, Matrix4f transformationMatrix, BBModelParts.Element element) {
        VI vi = BlockbenchBakery.faceVerts(direction)[index];
        Vector3 pos = new Vector3(positions[vi.x], positions[vi.y], positions[vi.z]);
        this.applyElementRotation(pos, element);
        this.applyTransform(pos, this.reusableMatrix.setToScaling(setting.scale, setting.scale, setting.scale));
        this.applyTransform(pos, this.reusableMatrix.setToTranslation(0.5f, 0.0f, 0.5f));
        if (rootNode != null) {
            if (rootNode.position != null) {
                this.applyTransform(pos, this.reusableMatrix.setToTranslation(-rootNode.position.x / 16.0f, -rootNode.position.y / 16.0f, -rootNode.position.z / 16.0f));
            } else if (rootNode.from != null) {
                this.applyTransform(pos, this.reusableMatrix.setToTranslation(-rootNode.from.x / 16.0f, -rootNode.from.y / 16.0f, -rootNode.from.z / 16.0f));
            }
        }
        this.applyModelRotation(pos, MODEL_ROTATION_CENTER, transformationMatrix);
        this.fillVertexWithCorner(vertices, index, uvCorner, direction, setting, pos, texture, uvs, resolution, element);
    }

    private void applyTransform(Vector3 pos, Matrix4 trans) {
        pos.set(trans.val[0] * pos.x + trans.val[4] * pos.y + trans.val[8] * pos.z + trans.val[12] * 1.0f, trans.val[1] * pos.x + trans.val[5] * pos.y + trans.val[9] * pos.z + trans.val[13] * 1.0f, trans.val[2] * pos.x + trans.val[6] * pos.y + trans.val[10] * pos.z + trans.val[14] * 1.0f);
    }

    private void rotateVertexBy(Vector3 pos, Vector3 origin, Matrix4 mat4) {
        Vector3 delta = new Vector3(pos.x - origin.x, pos.y - origin.y, pos.z - origin.z);
        this.applyTransform(delta, mat4);
        pos.set(delta.x + origin.x, delta.y + origin.y, delta.z + origin.z);
    }

    private void rotateVertexBy(Vector3 pos, Vector3 origin, Matrix4f mat4) {
        Vector4f delta = new Vector4f(pos.x - origin.x, pos.y - origin.y, pos.z - origin.z, 1.0f);
        delta.mul((Matrix4fc)mat4);
        pos.set(delta.x + origin.x, delta.y + origin.y, delta.z + origin.z);
    }

    private void applyModelRotation(Vector3 pos, Vector3 rot, Matrix4f transformationMatrix) {
        Matrix4f identity = new Matrix4f();
        if (!transformationMatrix.equals((Object)identity)) {
            this.rotateVertexBy(pos, rot, transformationMatrix);
        }
    }

    private void applyElementRotation(Vector3 pos, BBModelParts.Element element) {
        Vector3 origin = new Vector3(element.origin.x, element.origin.y, element.origin.z);
        Vector3 rotation = element.rotation;
        BBModelParts.OutlinerGroup parent = element.parent;
        while (true) {
            this.reusableVector.set(origin.x / 16.0f, origin.y / 16.0f, origin.z / 16.0f);
            if (rotation.x != 0.0f) {
                this.reusableQuaternion.set(Vector3.X, rotation.x);
                this.reusableMatrix.set(this.reusableQuaternion);
                this.rotateVertexBy(pos, this.reusableVector, this.reusableMatrix);
            }
            if (rotation.y != 0.0f) {
                this.reusableQuaternion.set(Vector3.Y, rotation.y);
                this.reusableMatrix.set(this.reusableQuaternion);
                this.rotateVertexBy(pos, this.reusableVector, this.reusableMatrix);
            }
            if (rotation.z != 0.0f) {
                this.reusableQuaternion.set(Vector3.Z, rotation.z);
                this.reusableMatrix.set(this.reusableQuaternion);
                this.rotateVertexBy(pos, this.reusableVector, this.reusableMatrix);
            }
            if (parent == null) break;
            origin = parent.origin;
            rotation = parent.rotation;
            parent = parent.parent;
        }
    }

    private void fillVertexWithCorner(int[] vertices, int index, int uvCorner, class_2350 faceDirection, BlockbenchLoader.BlockbenchSetting setting, Vector3 pos, class_1058 texture, BBModelParts.UVCoordinate uvs, BBModelParts.Resolution resolution, BBModelParts.Element element) {
        boolean isInvertedGeometry;
        int i = index * 8;
        boolean flipU = uvs.u0 > uvs.u1;
        boolean flipV = uvs.v0 > uvs.v1 ^ setting.flipV;
        class_2382 normal = faceDirection.method_10163();
        float nx = normal.method_10263();
        float ny = normal.method_10264();
        float nz = normal.method_10260();
        boolean hasNegativeX = element.to.x < element.from.x;
        boolean hasNegativeY = element.to.y < element.from.y;
        boolean hasNegativeZ = element.to.z < element.from.z;
        int negativeAxesCount = (hasNegativeX ? 1 : 0) + (hasNegativeY ? 1 : 0) + (hasNegativeZ ? 1 : 0);
        boolean bl = isInvertedGeometry = negativeAxesCount % 2 == 1;
        if (Math.abs(nx) > 0.5f || Math.abs(nz) > 0.5f) {
            boolean shouldMirror = false;
            if (isInvertedGeometry) {
                if (faceDirection == class_2350.field_11043 || faceDirection == class_2350.field_11035) {
                    if (hasNegativeX && !hasNegativeY) {
                        shouldMirror = true;
                    } else if (hasNegativeY && !hasNegativeX) {
                        shouldMirror = false;
                    }
                } else if (faceDirection == class_2350.field_11034 || faceDirection == class_2350.field_11039) {
                    if (hasNegativeY) {
                        shouldMirror = false;
                    } else if (hasNegativeZ && !hasNegativeY) {
                        shouldMirror = true;
                    }
                }
            } else {
                boolean bl2 = shouldMirror = !shouldMirror;
            }
            if (!shouldMirror) {
                boolean bl3 = flipU = !flipU;
            }
        }
        if (isInvertedGeometry && hasNegativeY) {
            boolean bl4 = flipV = !flipV;
        }
        if (flipU) {
            uvCorner = FLIP_U[uvCorner];
        }
        if (flipV) {
            uvCorner = FLIP_V[uvCorner];
        }
        float uMin = Math.min(uvs.u0, uvs.u1);
        float uMax = Math.max(uvs.u0, uvs.u1);
        float vMin = Math.min(uvs.v0, uvs.v1);
        float vMax = Math.max(uvs.v0, uvs.v1);
        float[] cornerU = new float[]{uMin, uMin, uMax, uMax};
        float[] cornerV = new float[]{vMin, vMax, vMax, vMin};
        float u = cornerU[uvCorner];
        float v = cornerV[uvCorner];
        float normalizedU = u / (float)resolution.width;
        float normalizedV = v / (float)resolution.height;
        float spriteU = texture.method_4594() + (texture.method_4577() - texture.method_4594()) * normalizedU;
        float spriteV = texture.method_4593() + (texture.method_4575() - texture.method_4593()) * normalizedV;
        vertices[i] = Float.floatToRawIntBits(pos.x);
        vertices[i + 1] = Float.floatToRawIntBits(pos.y);
        vertices[i + 2] = Float.floatToRawIntBits(pos.z);
        vertices[i + 3] = -1;
        vertices[i + 4] = Float.floatToRawIntBits(spriteU);
        vertices[i + 5] = Float.floatToRawIntBits(spriteV);
        vertices[i + 6] = 0;
        vertices[i + 7] = 0;
    }

    private float[] setupShape(Vector3 from, Vector3 to, float inflate) {
        float[] afloat = new float[class_2350.values().length];
        afloat[0] = (from.x - inflate / 2.0f) / 16.0f;
        afloat[1] = (from.y - inflate / 2.0f) / 16.0f;
        afloat[2] = (from.z - inflate / 2.0f) / 16.0f;
        afloat[3] = (to.x + inflate / 2.0f) / 16.0f;
        afloat[4] = (to.y + inflate / 2.0f) / 16.0f;
        afloat[5] = (to.z + inflate / 2.0f) / 16.0f;
        return afloat;
    }

    private class_2350 calculateFacing(int[] vertices) {
        Vector3 pos1 = new Vector3(Float.intBitsToFloat(vertices[0]), Float.intBitsToFloat(vertices[1]), Float.intBitsToFloat(vertices[2]));
        Vector3 pos2 = new Vector3(Float.intBitsToFloat(vertices[8]), Float.intBitsToFloat(vertices[9]), Float.intBitsToFloat(vertices[10]));
        Vector3 pos3 = new Vector3(Float.intBitsToFloat(vertices[16]), Float.intBitsToFloat(vertices[17]), Float.intBitsToFloat(vertices[18]));
        Vector3 delta1 = pos1.cpy();
        delta1.sub(pos2);
        Vector3 delta2 = pos3.cpy();
        delta2.sub(pos2);
        Vector3 cross = delta2.cpy();
        cross.crs(delta1);
        cross.nor();
        class_2350 direction = null;
        float f = 0.0f;
        for (class_2350 direc : class_2350.values()) {
            Vector3 normal = BlockbenchBakery.vec3iToVec3(direc.method_10163());
            float f1 = cross.dot(normal);
            if (!(f1 >= 0.0f) || !(f1 > f)) continue;
            f = f1;
            direction = direc;
        }
        return direction == null ? class_2350.field_11036 : direction;
    }

    private int packNormal(float x, float y, float z) {
        int nx = (int)(x * 127.0f) & 0xFF;
        int ny = (int)(y * 127.0f) & 0xFF;
        int nz = (int)(z * 127.0f) & 0xFF;
        return nx | ny << 8 | nz << 16;
    }

    private void fillNormals(int[] vertices, class_2350 direction) {
        class_2382 normal = direction.method_10163();
        int packedNormal = this.packNormal(normal.method_10263(), normal.method_10264(), normal.method_10260());
        for (int i = 0; i < 4; ++i) {
            int offset = i * 8;
            vertices[offset + 6] = 0;
            vertices[offset + 7] = packedNormal;
        }
    }

    private int packLightmapCoords(int blockLight, int skyLight) {
        return skyLight << 16 | blockLight;
    }

    private static class VI {
        final int x;
        final int y;
        final int z;

        VI(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    private static class Axes {
        final Vector3 u;
        final Vector3 v;

        Axes(Vector3 u, Vector3 v) {
            this.u = u;
            this.v = v;
        }
    }
}

