/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.client;

import com.razz.decocraft.client.particles.ParticleFallingLiquid;
import com.razz.decocraft.client.particles.ParticleFlame;
import com.razz.decocraft.client.particles.ParticleSmoke;
import com.razz.decocraft.client.render.AnimatedRenderer;
import com.razz.decocraft.common.ModuleBlocks;
import com.razz.decocraft.common.ModuleParticleTypes;
import com.razz.decocraft.common.ModuleTileEntities;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import com.razz.decocraft.models.bbmodel.BlockbenchLoader;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="decocraft", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        RenderType cutoutCulling = RenderType.m_110463_();
        RenderType translucentCulling = RenderType.m_110466_();
        for (Map.Entry<String, Block> entry : ModuleBlocks.DECOBLOCKS.entrySet()) {
            DecocraftBlock block = (DecocraftBlock)entry.getValue();
            if (!Objects.equals(block.meta.type, "animated")) {
                RenderType renderer = !block.meta.transparency ? cutoutCulling : translucentCulling;
                ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)renderer);
                continue;
            }
            ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)translucentCulling);
        }
        BlockEntityRenderers.m_173590_(ModuleTileEntities.ANIMATED_TE, AnimatedRenderer::new);
    }

    @SubscribeEvent
    public static void onRegisterGeometryLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("bbmodel", (IGeometryLoader)BlockbenchLoader.INSTANCE);
    }

    @SubscribeEvent
    static void onRegisterParticleProviders(RegisterParticleProvidersEvent event) {
        event.register((ParticleType)ModuleParticleTypes.SMOKE_NORMAL, ParticleSmoke.ProviderNormal::new);
        event.register((ParticleType)ModuleParticleTypes.SMOKE_SMALL, ParticleSmoke.ProviderSmall::new);
        event.register((ParticleType)ModuleParticleTypes.FLAME_NORMAL, ParticleFlame.ProviderNormal::new);
        event.register((ParticleType)ModuleParticleTypes.FLAME_SMALL, ParticleFlame.ProviderSmall::new);
        event.register((ParticleType)ModuleParticleTypes.FALLING_WATER, ParticleFallingLiquid.FactoryWaterRandom::new);
    }
}

