/*
 * Decompiled with CFR 0.152.
 */
package com.razz.essentialpartnermod.modal;

import com.mojang.blaze3d.vertex.PoseStack;
import com.razz.essentialpartnermod.Draw;
import com.razz.essentialpartnermod.EssentialPartner;
import com.razz.essentialpartnermod.EssentialUtil;
import com.razz.essentialpartnermod.Resources;
import com.razz.essentialpartnermod.Tooltip;
import com.razz.essentialpartnermod.UDesktop;
import com.razz.essentialpartnermod.data.ModalData;
import com.razz.essentialpartnermod.data.PartnerModData;
import com.razz.essentialpartnermod.mc.Font;
import com.razz.essentialpartnermod.modal.InstallButton;
import com.razz.essentialpartnermod.modal.LinkButton;
import com.razz.essentialpartnermod.modal.Modal;
import com.razz.essentialpartnermod.modal.ModalManager;
import com.razz.essentialpartnermod.modal.TextureButton;
import com.razz.essentialpartnermod.modal.TwoButtonModal;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

public class AdModal
extends Modal {
    private static final ResourceLocation X_ICON = Resources.load("x.png");
    private static final ResourceLocation ESSENTIAL_LOGO = Resources.load("essential.png");
    private static final ResourceLocation REMOVE_INTEGRATION = Resources.load("removeintegration.png");
    private final Map<FeatureEntry, ResourceLocation> iconTextures = new HashMap<FeatureEntry, ResourceLocation>();
    private final ModalData modalData;
    private final String parterModsTooltip;
    private final List<FeatureEntry> features = new ArrayList<FeatureEntry>();
    private int featuresOffset;

    public AdModal(ModalData modalData, List<PartnerModData.PartnerMod> partnerMods) {
        this.modalData = modalData;
        this.parterModsTooltip = this.getTooltip(partnerMods);
        for (ModalData.Feature feature : modalData.getFeatures()) {
            this.features.add(FeatureEntry.fromInfra(feature));
        }
    }

    @Override
    public void init() {
        super.init();
        int height = 49;
        height += Font.getMultilineStringHeight(this.modalData.getSubtitle("en_us"), 10);
        this.featuresOffset = height += 7;
        height += 13 * this.features.size();
        int learnMoreOffset = height += 6;
        int installOffset = height += 24;
        height += 20;
        this.setDimensions(194, height += 17);
        this.buttonList.add(new LinkButton(this.centreX - (Font.getStringWidth("Learn more") + 10) / 2, this.startY + learnMoreOffset, "Learn more", () -> UDesktop.browse(this.modalData.getLink("learn_more"))));
        this.buttonList.add(new InstallButton(this.centreX - 70, this.startY + installOffset, () -> {
            boolean success = EssentialUtil.installContainer();
            if (success) {
                ModalManager.INSTANCE.setModal(TwoButtonModal.postInstall());
            } else {
                ModalManager.INSTANCE.setModal(TwoButtonModal.installFailed());
            }
        }));
        this.buttonList.add(new TextureButton(this.centreX - 64, this.startY + height + 8, 128, 8, REMOVE_INTEGRATION, -10724260, -9079435, false, () -> ModalManager.INSTANCE.setModal(TwoButtonModal.removeAds(this))));
        this.buttonList.add(new TextureButton(this.startX + this.width - 8 - 5, this.startY + 8, 5, 5, X_ICON, -9079435, -6710887, true, () -> ModalManager.INSTANCE.setModal(null)));
    }

    @Override
    public void draw(Draw draw) {
        super.draw(draw);
        Minecraft mc = Minecraft.m_91087_();
        draw.rect(this.centreX - 49 + 1, this.startY + 20 + 1, this.centreX + 49 + 1, this.startY + 20 + 19 + 1, -16777216);
        draw.rect(this.centreX - 49, this.startY + 20, this.centreX + 49, this.startY + 20 + 19, -14995119);
        draw.texturedRect(ESSENTIAL_LOGO, this.centreX - 40, this.startY + 20 + 7, 80, 6, 0, 0, 80, 6, -1710619);
        draw.multilineCentredString(this.modalData.getSubtitle("en_us"), this.centreX, this.startY + 49, 10, -4210753, -16777216);
        int maxWidth = 0;
        for (FeatureEntry feature : this.features) {
            maxWidth = Math.max(Font.getStringWidth(feature.getDisplayedText()), maxWidth);
        }
        int featureX = this.centreX - (maxWidth + 15) / 2;
        int featureY = this.startY + this.featuresOffset;
        for (FeatureEntry feature : this.features) {
            ResourceLocation location = this.iconTextures.computeIfAbsent(feature, AdModal::loadIconTexture);
            draw.texturedRect(location, featureX + 1, featureY + 1, 10, 10, 0, 0, 10, 10, -16777216);
            draw.texturedRect(location, featureX, featureY, 10, 10, 0, 0, 10, 10, -16088323);
            int textX = featureX + 15;
            int textY = featureY + 1;
            String text = feature.text;
            FeatureTooltip tooltip = feature.tooltip;
            if (tooltip != null) {
                int tooltipStart = tooltip.tooltipStart;
                int tooltipEnd = tooltip.tooltipEnd;
                String beforeTooltip = text.substring(0, tooltipStart);
                int beforeTooltipWidth = Font.getStringWidth(beforeTooltip);
                String withTooltip = text.substring(tooltipStart + 2, tooltipEnd);
                int withTooltipWidth = Font.getStringWidth(withTooltip);
                String afterTooltip = text.substring(tooltipEnd + 2);
                if (!beforeTooltip.isEmpty()) {
                    draw.string(beforeTooltip, textX, textY, -1710619, -16777216);
                    textX += beforeTooltipWidth;
                }
                draw.string(withTooltip, textX, textY, -1710619, -16777216);
                draw.rect(textX, textY + 8, textX + withTooltipWidth, textY + 9, -1710619);
                draw.rect(textX + 1, textY + 9, textX + withTooltipWidth + 1, textY + 10, -16777216);
                if (draw.hovered(textX, textY, withTooltipWidth, 10)) {
                    int finalX = textX;
                    String tooltipText = tooltip.text.equals("MOD_PARTNERS") ? this.parterModsTooltip : tooltip.text;
                    Draw.deferred(d -> Tooltip.drawTooltip(d, tooltipText, Tooltip.Position.BELOW, finalX, textY, withTooltipWidth, 10));
                }
                textX += withTooltipWidth;
                if (!afterTooltip.isEmpty()) {
                    draw.string(afterTooltip, textX, textY, -1710619, -16777216);
                }
            } else {
                draw.string(text, textX, textY, -1710619, -16777216);
            }
            featureY += 13;
        }
    }

    @Override
    protected void drawBackground(Draw draw) {
        draw.rect(this.startX, this.startY, this.startX + this.width, this.startY + this.height, -14800324);
        AdModal.m_93179_((PoseStack)draw.matrixStack, (int)(this.startX + 1), (int)(this.startY + 1), (int)(this.startX + this.width - 1), (int)(this.startY + this.height - 1), (int)-15326673, (int)-15657698);
    }

    private String getTooltip(List<PartnerModData.PartnerMod> partnerMods) {
        partnerMods = new ArrayList<PartnerModData.PartnerMod>(partnerMods);
        Collections.shuffle(partnerMods);
        if (partnerMods.size() > 5) {
            partnerMods = partnerMods.subList(0, 5);
        }
        return String.format(switch (partnerMods.size()) {
            case 0 -> "Partnered mods receive\na share of purchases";
            case 1 -> "%s and other\npartnered mods receive\na share of purchases";
            case 2 -> "%s, %s,\nand other partnered mods\nreceive a share of purchases";
            case 3 -> "%s, %s,\n%s, and other partnered mods\nreceive a share of purchases";
            case 4 -> "%s, %s,\n%s, %s,\nand other partnered mods\nreceive a share of purchases";
            case 5 -> "%s, %s,\n%s, %s,\n%s, and other partnered mods\nreceive a share of purchases";
            default -> throw new IllegalStateException();
        }, partnerMods.stream().map(PartnerModData.PartnerMod::getDisplayName).toArray());
    }

    @Override
    public void close() {
        for (ResourceLocation location : this.iconTextures.values()) {
            Minecraft.m_91087_().m_91097_().m_118513_(location);
        }
        this.iconTextures.clear();
        super.close();
    }

    private static ResourceLocation loadIconTexture(FeatureEntry feature) {
        byte[] bytes = Base64.getDecoder().decode(feature.icon);
        return Resources.load(new ByteArrayInputStream(bytes));
    }

    private static class FeatureEntry {
        private final String text;
        private final String icon;
        private final FeatureTooltip tooltip;

        public FeatureEntry(String text, String icon, FeatureTooltip tooltip) {
            this.text = text;
            this.icon = icon;
            this.tooltip = tooltip;
        }

        public String getDisplayedText() {
            if (this.tooltip != null) {
                return this.text.substring(0, this.tooltip.tooltipStart) + this.text.substring(this.tooltip.tooltipStart + 2, this.tooltip.tooltipEnd) + this.text.substring(this.tooltip.tooltipEnd + 2);
            }
            return this.text;
        }

        public static FeatureEntry fromInfra(ModalData.Feature feature) {
            String text = feature.getText("en_us");
            String tooltipText = feature.getTooltip("en_us");
            FeatureTooltip tooltip = null;
            if (tooltipText != null) {
                tooltip = FeatureTooltip.parse(text, tooltipText);
            }
            return new FeatureEntry(text, feature.getIcon(), tooltip);
        }
    }

    private static class FeatureTooltip {
        private final String text;
        private final int tooltipStart;
        private final int tooltipEnd;

        public FeatureTooltip(String text, int tooltipStart, int tooltipEnd) {
            this.text = text;
            this.tooltipStart = tooltipStart;
            this.tooltipEnd = tooltipEnd;
        }

        public static FeatureTooltip parse(String text, String tooltipText) {
            int tooltipStart = text.indexOf("__");
            if (tooltipStart == -1) {
                EssentialPartner.LOGGER.warn("Invalid tooltip for string: {}", (Object)text);
                return null;
            }
            int tooltipEnd = text.indexOf("__", tooltipStart + 2);
            if (tooltipEnd == -1) {
                EssentialPartner.LOGGER.warn("Invalid tooltip for string: {}", (Object)text);
                return null;
            }
            return new FeatureTooltip(tooltipText, tooltipStart, tooltipEnd);
        }
    }
}

