/*
 * Decompiled with CFR 0.152.
 */
package com.razz.essentialpartnermod.modal;

import com.mojang.blaze3d.vertex.PoseStack;
import com.razz.essentialpartnermod.Draw;
import com.razz.essentialpartnermod.UMouse;
import com.razz.essentialpartnermod.UResolution;
import com.razz.essentialpartnermod.mixins.MouseHelperAccessor;
import com.razz.essentialpartnermod.modal.Modal;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ModalManager {
    public static final ModalManager INSTANCE = new ModalManager();
    private static final double FAKE_MOUSE_POS = -1000000.0;
    private Modal currentModal = null;
    private MousePosition mousePosition = null;
    private int previousWidth = -1;
    private int previousHeight = -1;

    public void setModal(Modal modal) {
        Modal previous = this.currentModal;
        this.previousWidth = -1;
        this.previousHeight = -1;
        this.currentModal = modal;
        if (previous != null) {
            previous.close();
        }
    }

    public MousePosition getMousePosition() {
        return this.mousePosition;
    }

    private void setMousePosisiton(double x, double y) {
        this.mousePosition = new MousePosition(x, y, UMouse.getRawX(), UMouse.getRawY());
        GlobalMouseOverride.set(x, y);
    }

    private void resetMousePosition() {
        if (this.mousePosition == null) {
            return;
        }
        GlobalMouseOverride.set(this.mousePosition.originalMouseX, this.mousePosition.originalMouseY);
        this.mousePosition = null;
    }

    private void handlePreDraw(DrawEvent event) {
        if (this.currentModal == null) {
            return;
        }
        this.setMousePosisiton(-1000000.0, -1000000.0);
        event.mouseX = -1000000;
        event.mouseY = -1000000;
    }

    private void handleDraw(PoseStack stack) {
        this.resetMousePosition();
        stack.m_85836_();
        stack.m_252880_(0.0f, 0.0f, 10.0f);
        Draw draw = new Draw((int)UMouse.getScaledX(), (int)UMouse.getScaledY(), stack);
        Draw.flushDeferred(draw);
        this.handleDraw(draw);
        Draw.flushDeferred(draw);
        stack.m_85849_();
    }

    private void handleDraw(Draw draw) {
        if (this.currentModal == null) {
            return;
        }
        int width = UResolution.getScaledWidth();
        int height = UResolution.getScaledHeight();
        if (this.previousWidth != width || this.previousHeight != height) {
            this.currentModal.init();
        }
        this.currentModal.draw(draw);
    }

    private boolean handleMouseClick(double mouseX, double mouseY) {
        if (this.currentModal == null) {
            return false;
        }
        this.currentModal.mouseClicked((int)mouseX, (int)mouseY);
        return true;
    }

    private boolean handleKeyTyped(int key) {
        if (this.currentModal == null) {
            return false;
        }
        this.currentModal.keyPressed(key);
        return true;
    }

    @SubscribeEvent
    public void preDraw(ScreenEvent.Render.Pre event) {
        this.handlePreDraw(new DrawEvent(event.getMouseX(), event.getMouseY()));
    }

    @SubscribeEvent
    public void draw(ScreenEvent.Render.Post event) {
        this.handleDraw(event.getPoseStack());
    }

    @SubscribeEvent
    public void mouseClicked(ScreenEvent.MouseButtonPressed.Pre event) {
        event.setCanceled(this.handleMouseClick(event.getMouseX(), event.getMouseY()));
    }

    @SubscribeEvent
    public void keyPressed(ScreenEvent.KeyPressed.Pre event) {
        event.setCanceled(this.handleKeyTyped(event.getKeyCode()));
    }

    public static class MousePosition {
        public final double mouseX;
        public final double mouseY;
        public final double originalMouseX;
        public final double originalMouseY;

        public MousePosition(double mouseX, double mouseY, double originalMouseX, double originalMouseY) {
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.originalMouseX = originalMouseX;
            this.originalMouseY = originalMouseY;
        }
    }

    private static class GlobalMouseOverride {
        private GlobalMouseOverride() {
        }

        public static void set(double mouseX, double mouseY) {
            MouseHelperAccessor accessor = (MouseHelperAccessor)Minecraft.m_91087_().f_91067_;
            accessor.setMouseX(mouseX);
            accessor.setMouseY(mouseY);
        }
    }

    public static class DrawEvent {
        public int mouseX;
        public int mouseY;
        int originalMouseX;
        int originalMouseY;

        public DrawEvent(int mouseX, int mouseY) {
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.originalMouseX = mouseX;
            this.originalMouseY = mouseY;
        }

        public boolean mouseXChanged() {
            return this.mouseX != this.originalMouseX;
        }

        public boolean mouseYChanged() {
            return this.mouseY != this.originalMouseY;
        }
    }
}

