/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.client;

import com.razz.decocraft.client.particles.ParticleFallingLiquid;
import com.razz.decocraft.client.particles.ParticleFlame;
import com.razz.decocraft.client.particles.ParticleSmoke;
import com.razz.decocraft.client.render.AnimatedRenderer;
import com.razz.decocraft.common.ModuleBlocks;
import com.razz.decocraft.common.ModuleParticleTypes;
import com.razz.decocraft.common.ModuleTileEntities;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import com.razz.decocraft.models.bbmodel.BlockbenchLoader;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="decocraft", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        RenderType cutoutCulling = RenderType.m_110463_();
        RenderType translucentCulling = RenderType.m_110466_();
        for (Map.Entry<String, Block> entry : ModuleBlocks.DECOBLOCKS.entrySet()) {
            DecocraftBlock block = (DecocraftBlock)entry.getValue();
            if (!Objects.equals(block.meta.type, "animated")) {
                RenderType renderer = !block.meta.transparency ? cutoutCulling : translucentCulling;
                ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)renderer);
                continue;
            }
            ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)ForgeRenderTypes.ITEM_LAYERED_CUTOUT.get());
        }
        BlockEntityRenderers.m_173590_(ModuleTileEntities.ANIMATED_TE, AnimatedRenderer::new);
    }

    @SubscribeEvent
    static void modelRegistry(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("decocraft", "bbmodel"), (IModelLoader)BlockbenchLoader.INSTANCE);
    }

    @SubscribeEvent
    static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ModuleParticleTypes.SMOKE_NORMAL, ParticleSmoke.ProviderNormal::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ModuleParticleTypes.SMOKE_SMALL, ParticleSmoke.ProviderSmall::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ModuleParticleTypes.FLAME_NORMAL, ParticleFlame.ProviderNormal::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ModuleParticleTypes.FLAME_SMALL, ParticleFlame.ProviderSmall::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ModuleParticleTypes.FALLING_WATER, ParticleFallingLiquid.FactoryWaterRandom::new);
    }
}

