/*
 * Decompiled with CFR 0.152.
 */
package com.razz.essentialpartnermod;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.razz.essentialpartnermod.Draw;
import com.razz.essentialpartnermod.Resources;
import com.razz.essentialpartnermod.UButton;
import com.razz.essentialpartnermod.UResolution;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class AdButton
extends Button {
    public static ResourceLocation TEXTURE_MAIN_MENU = Resources.load("button_mainmenu.png");
    public static ResourceLocation TEXTURE_MULTIPLAYER = Resources.load("button_multiplayer.png");
    public static ResourceLocation TEXTURE_SINGLEPLAYER = Resources.load("button_singleplayer.png");
    private static final int BUTTON_ID = -457087759;
    private final ResourceLocation texture;
    private final String tooltip;

    public AdButton(int x, int y, ResourceLocation texture, Consumer<Button> onPress, String tooltip) {
        super(x, y, 20, 20, TextComponent.f_131282_, onPress::accept);
        this.texture = texture;
        this.tooltip = tooltip;
    }

    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93624_) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
            int x = 0;
            if (this.m_198029_()) {
                x += this.f_93618_;
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            AdButton.m_93143_((PoseStack)matrixStack, (int)this.f_93620_, (int)this.f_93621_, (int)0, (float)x, (float)0.0f, (int)this.f_93618_, (int)this.f_93619_, (int)(this.f_93618_ * 2), (int)this.f_93619_);
            if (this.m_198029_()) {
                Draw.deferred(it -> this.drawTooltip((Draw)it, Minecraft.m_91087_(), TooltipPosition.ABOVE));
            }
        }
    }

    private void drawTooltip(Draw draw, Minecraft mc, TooltipPosition position) {
        int y;
        int x;
        String[] lines = this.tooltip.split("\n");
        int maxWidth = 0;
        for (String line : lines) {
            maxWidth = Math.max(maxWidth, mc.f_91062_.m_92895_(line));
        }
        int width = maxWidth + 8;
        int height = 10 * lines.length + 4;
        int buttonX = UButton.getX(this);
        int buttonY = UButton.getY(this);
        int windowPadding = 2;
        switch (position) {
            case ABOVE: {
                x = buttonX + this.f_93618_ / 2 - width / 2;
                y = buttonY - height - 5;
                if (y >= windowPadding) break;
                position = TooltipPosition.BELOW;
                y = buttonY + this.f_93619_ + 5;
                break;
            }
            case BELOW: {
                x = buttonX + this.f_93618_ / 2 - width / 2;
                y = buttonY + this.f_93619_ + 5;
                if (y + height <= UResolution.getScaledHeight() - windowPadding) break;
                position = TooltipPosition.ABOVE;
                y = buttonY - height - 5;
                break;
            }
            case LEFT: {
                x = buttonX - width - 5;
                y = buttonY + this.f_93619_ / 2 - height / 2;
                if (x >= windowPadding) break;
                position = TooltipPosition.RIGHT;
                x = buttonX + this.f_93618_ + 5;
                break;
            }
            case RIGHT: {
                x = buttonX + this.f_93618_ + 5;
                y = buttonY + this.f_93619_ / 2 - height / 2;
                if (x + width <= UResolution.getScaledWidth() - windowPadding) break;
                position = TooltipPosition.LEFT;
                x = buttonX - width - 5;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (position) {
            case ABOVE: 
            case BELOW: {
                x = Math.max(windowPadding, Math.min(x, UResolution.getScaledWidth() - windowPadding - width));
                break;
            }
            case LEFT: 
            case RIGHT: {
                y = Math.max(windowPadding, Math.min(y, UResolution.getScaledHeight() - windowPadding - height));
            }
        }
        int centerX = x + width / 2;
        int centerY = y + height / 2;
        draw.rect(x - 1, y - 1, x + width + 1, y + height + 1, -16777216);
        draw.rect(x, y, x + width, y + height, -14474461);
        int textY = y;
        for (String line : lines) {
            int lineWidth = mc.f_91062_.m_92895_(line);
            draw.string(line, centerX - lineWidth / 2, textY + 3, -1710619, -16777216);
            textY += 10;
        }
        centerX = buttonX + this.f_93618_ / 2;
        centerY = buttonY + this.f_93619_ / 2;
        block18: for (int i = 0; i <= 2; ++i) {
            switch (position) {
                case ABOVE: {
                    draw.rect(centerX - (2 - i) - 1, y + height + i + 1, centerX + (2 - i), y + height + i + 2, -16777216);
                    draw.rect(centerX - (2 - i) - 1, y + height + i, centerX + (2 - i), y + height + i + 1, -14474461);
                    continue block18;
                }
                case BELOW: {
                    draw.rect(centerX - (2 - i) - 1, y - i - 2, centerX + (2 - i), y - i - 1, -16777216);
                    draw.rect(centerX - (2 - i) - 1, y - i - 1, centerX + (2 - i), y - i, -14474461);
                    continue block18;
                }
                case LEFT: {
                    draw.rect(x + width + i + 1, centerY - (2 - i) - 1, x + width + i + 2, centerY + (2 - i), -16777216);
                    draw.rect(x + width + i, centerY - (2 - i) - 1, x + width + i + 1, centerY + (2 - i), -14474461);
                    continue block18;
                }
                case RIGHT: {
                    draw.rect(x - i - 2, centerY - (2 - i) - 1, x - i - 1, centerY + (2 - i), -16777216);
                    draw.rect(x - i - 1, centerY - (2 - i) - 1, x - i, centerY + (2 - i), -14474461);
                }
            }
        }
    }

    static enum TooltipPosition {
        ABOVE,
        BELOW,
        LEFT,
        RIGHT;

    }
}

