/*
 * Decompiled with CFR 0.152.
 */
package com.razz.essentialpartnermod.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.service.IGlobalPropertyService;
import org.spongepowered.asm.service.MixinService;

public class EssentialPartnerLoader {
    private static final boolean VERBOSE = Boolean.getBoolean("essential.partnermod.loader.verbose");
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String OUR_PKG;
    private static final String COMMON_PACKAGE;
    private static final String PROPOSED_VERSION_KEY;
    private static final String ACTIVE_VERSION_KEY;
    public static final String OUR_VERSION;
    private static Boolean isActive;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void propose() {
        Class<System> clazz = System.class;
        synchronized (System.class) {
            String activeVersion = EssentialPartnerLoader.blackboardGet(ACTIVE_VERSION_KEY);
            if (activeVersion != null) {
                throw new IllegalStateException("Tried to load version " + OUR_VERSION + " but version " + activeVersion + " is already active!");
            }
            String proposedVersion = EssentialPartnerLoader.blackboardGet(PROPOSED_VERSION_KEY);
            if (proposedVersion == null || EssentialPartnerLoader.compareVersions(proposedVersion, OUR_VERSION) < 0) {
                if (VERBOSE) {
                    LOGGER.info("{} proposing {}", (Object)OUR_PKG, (Object)OUR_VERSION);
                }
                EssentialPartnerLoader.blackboardSet(PROPOSED_VERSION_KEY, OUR_VERSION);
            } else if (VERBOSE) {
                LOGGER.info("{} version is {}, current proposed is already {}", (Object)OUR_PKG, (Object)OUR_VERSION, (Object)proposedVersion);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isActive() {
        if (isActive != null) {
            return isActive;
        }
        Class<System> clazz = System.class;
        synchronized (System.class) {
            if (isActive != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return isActive;
            }
            String activeVersion = EssentialPartnerLoader.blackboardGet(ACTIVE_VERSION_KEY);
            if (activeVersion != null) {
                if (VERBOSE) {
                    LOGGER.info("{} (version {}) is inactive because {} is already active", (Object)OUR_PKG, (Object)OUR_VERSION, (Object)activeVersion);
                }
                isActive = false;
                // ** MonitorExit[var0] (shouldn't be in output)
                return isActive;
            }
            String proposedVersion = EssentialPartnerLoader.blackboardGet(PROPOSED_VERSION_KEY);
            if (!OUR_VERSION.equals(proposedVersion)) {
                if (VERBOSE) {
                    LOGGER.info("{} (version {}) is inactive because newer {} has been proposed", (Object)OUR_PKG, (Object)OUR_VERSION, (Object)proposedVersion);
                }
                isActive = false;
                // ** MonitorExit[var0] (shouldn't be in output)
                return isActive;
            }
            if (VERBOSE) {
                LOGGER.info("{} (version {}) is now active", (Object)OUR_PKG, (Object)OUR_VERSION);
            }
            EssentialPartnerLoader.blackboardSet(ACTIVE_VERSION_KEY, proposedVersion);
            isActive = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return isActive;
        }
    }

    private static String blackboardGet(String key) {
        IGlobalPropertyService service = MixinService.getGlobalPropertyService();
        Object[] container = (Object[])service.getProperty(service.resolveKey(key));
        return container == null ? null : (String)container[0];
    }

    private static void blackboardSet(String key, String value) {
        IGlobalPropertyService service = MixinService.getGlobalPropertyService();
        Object[] container = (Object[])service.getProperty(service.resolveKey(key));
        if (container == null) {
            container = new Object[1];
            service.setProperty(service.resolveKey(key), (Object)container);
        }
        container[0] = value;
    }

    private static int compareVersions(String a, String b) {
        int aPlusIndex = a.indexOf(43);
        int bPlusIndex = b.indexOf(43);
        if (aPlusIndex == -1) {
            aPlusIndex = a.length();
        }
        if (bPlusIndex == -1) {
            bPlusIndex = b.length();
        }
        String[] aParts = a.substring(0, aPlusIndex).replace('-', '.').split("\\.");
        String[] bParts = b.substring(0, bPlusIndex).replace('-', '.').split("\\.");
        for (int i = 0; i < Math.max(aParts.length, bParts.length); ++i) {
            String aPart = i < aParts.length ? aParts[i] : "0";
            String bPart = i < bParts.length ? bParts[i] : "0";
            Integer aInt = EssentialPartnerLoader.toIntOrNull(aPart);
            Integer bInt = EssentialPartnerLoader.toIntOrNull(bPart);
            int compare = aInt != null && bInt != null ? Integer.compare(aInt, bInt) : (aInt == null && bInt == null ? aPart.compareTo(bPart) : (aInt != null ? 1 : -1));
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    private static Integer toIntOrNull(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static {
        String name = EssentialPartnerLoader.class.getName();
        OUR_PKG = name.substring(0, name.length() - ".loader.EssentialPartnerLoader".length());
        COMMON_PACKAGE = "gg;essential;partnermod".replace(";", ".");
        PROPOSED_VERSION_KEY = COMMON_PACKAGE + ".proposedVersion";
        ACTIVE_VERSION_KEY = COMMON_PACKAGE + ".activeVersion";
        try (InputStream in = EssentialPartnerLoader.class.getResourceAsStream("version.txt");){
            if (in == null) {
                throw new RuntimeException("Failed to find version.txt");
            }
            OUR_VERSION = new BufferedReader(new InputStreamReader(in)).readLine().trim();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

