/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.razz.decocraft.common.blocks.DecoAnimatedBlock;
import com.razz.decocraft.common.blocks.DecoWaterBlock;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import com.razz.decocraft.common.items.DecoBlockItem;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelParts;
import com.razz.decocraft.models.libgdx.Matrix4;
import com.razz.decocraft.models.libgdx.Quaternion;
import com.razz.decocraft.models.libgdx.Vector3;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class DecoPlacementRenderer {
    private static class_2338 lastPos;
    private static class_2350 lastFacing;
    private static BBModel lastModel;
    private static float lastScale;
    private static Map<BBModelParts.Element, Vector3[]> cornerCache;
    private static final Matrix4[] ROTATION_TRANSFORMS;

    public static void renderPlacementPreview(WorldRenderContext context) {
        class_1792 class_17922;
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1687 == null) {
            return;
        }
        class_1799 stack = mc.field_1724.method_6047();
        if (stack.method_7960()) {
            stack = mc.field_1724.method_6079();
        }
        if (!((class_17922 = stack.method_7909()) instanceof DecoBlockItem)) {
            return;
        }
        DecoBlockItem item = (DecoBlockItem)class_17922;
        if (mc.field_1765 == null || mc.field_1765.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        class_3965 hit = (class_3965)mc.field_1765;
        class_2338 pos = hit.method_17777().method_10093(hit.method_17780());
        DecoPlacementRenderer.renderOutline(context, item, pos, mc.field_1724.method_5735().method_10153(), (class_1937)mc.field_1687);
    }

    private static void renderOutline(WorldRenderContext context, DecoBlockItem item, class_2338 pos, class_2350 facing, class_1937 world) {
        class_2680 previewState;
        if (!(item.method_7711() instanceof DecocraftBlock) && !(item.method_7711() instanceof DecoAnimatedBlock)) {
            return;
        }
        BBModel model = null;
        if (item.method_7711() instanceof DecocraftBlock) {
            DecocraftBlock block = (DecocraftBlock)item.method_7711();
            previewState = (class_2680)block.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)facing);
            if (block instanceof DecoWaterBlock) {
                boolean inWater = world.method_8316(pos).method_39360((class_3611)class_3612.field_15910);
                previewState = (class_2680)previewState.method_11657((class_2769)DecoWaterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(inWater));
            }
            model = block.model;
        } else {
            DecoAnimatedBlock animatedBlock = (DecoAnimatedBlock)item.method_7711();
            previewState = (class_2680)animatedBlock.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)facing);
            model = animatedBlock.model;
        }
        class_4587 matrices = context.matrixStack();
        class_4184 camera = context.camera();
        class_243 cameraPos = camera.method_19326();
        matrices.method_22903();
        matrices.method_22904((double)pos.method_10263() - cameraPos.field_1352, (double)pos.method_10264() - cameraPos.field_1351, (double)pos.method_10260() - cameraPos.field_1350);
        if (model != null && model.elements != null && !model.elements.isEmpty()) {
            boolean recalc;
            BBModelParts.Element rootNode = null;
            for (BBModelParts.Element element : model.elements) {
                if (element.name == null || !element.name.toLowerCase().equals("root_node") || !Objects.equals(element.type, "locator")) continue;
                rootNode = element;
                break;
            }
            float scale = 1.0f;
            if (item.method_7711() instanceof DecocraftBlock) {
                DecocraftBlock block = (DecocraftBlock)item.method_7711();
                scale = block.meta != null && block.meta.scale != 0.0f ? block.meta.scale : 1.0f;
            } else if (item.method_7711() instanceof DecoAnimatedBlock) {
                DecoAnimatedBlock animatedBlock = (DecoAnimatedBlock)item.method_7711();
                scale = animatedBlock.meta != null && animatedBlock.meta.scale != 0.0f ? animatedBlock.meta.scale : 1.0f;
            }
            boolean bl = recalc = lastPos == null || !lastPos.equals((Object)pos) || lastFacing != facing || lastModel != model || lastScale != scale;
            if (recalc) {
                lastPos = pos;
                lastFacing = facing;
                lastModel = model;
                lastScale = scale;
                cornerCache = new HashMap<BBModelParts.Element, Vector3[]>();
            }
            DecoPlacementRenderer.renderModelWireframe(matrices, model, facing, cameraPos, scale, rootNode, previewState, recalc);
        } else if (item.method_7711() instanceof DecocraftBlock) {
            DecocraftBlock block = (DecocraftBlock)item.method_7711();
            DecoPlacementRenderer.renderSimpleOutline(matrices, block, previewState, world, pos);
        }
        matrices.method_22909();
    }

    private static void renderSimpleOutline(class_4587 matrices, DecocraftBlock block, class_2680 previewState, class_1937 world, class_2338 pos) {
        class_265 shape = block.method_9530(previewState, (class_1922)world, pos, class_3726.method_16194());
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.depthFunc((int)515);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        int red = 255;
        int green = 255;
        int blue = 255;
        int alpha = 255;
        shape.method_1104((x1, y1, z1, x2, y2, z2) -> {
            buffer.method_22918(matrices.method_23760().method_23761(), (float)x1, (float)y1, (float)z1).method_1336(red, green, blue, alpha);
            buffer.method_22918(matrices.method_23760().method_23761(), (float)x2, (float)y2, (float)z2).method_1336(red, green, blue, alpha);
        });
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.depthFunc((int)515);
    }

    private static void renderModelWireframe(class_4587 matrices, BBModel model, class_2350 facing, class_243 cameraPos, float scale, BBModelParts.Element rootNode, class_2680 blockState, boolean recalculate) {
        if (model == null || model.elements == null) {
            return;
        }
        Vector3 modelCenter = null;
        if (rootNode == null) {
            modelCenter = DecoPlacementRenderer.calculateModelCenter(model);
        }
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.depthFunc((int)519);
        class_289 tessellator = class_289.method_1348();
        int red = 255;
        int green = 255;
        int blue = 255;
        int alpha = 255;
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        Matrix4 rotationMatrix = DecoPlacementRenderer.getRotationMatrix(facing);
        for (BBModelParts.Element element : model.elements) {
            if (element.from == null || element.to == null) continue;
            DecoPlacementRenderer.renderElementWireframe(matrices, buffer, element, rotationMatrix, rootNode, modelCenter, scale, red, green, blue, alpha, blockState, recalculate);
        }
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.depthFunc((int)515);
    }

    private static Vector3 calculateModelCenter(BBModel model) {
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float minZ = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        float maxY = -3.4028235E38f;
        float maxZ = -3.4028235E38f;
        for (BBModelParts.Element element : model.elements) {
            if (element.from == null || element.to == null) continue;
            minX = Math.min(minX, Math.min(element.from.x, element.to.x));
            minY = Math.min(minY, Math.min(element.from.y, element.to.y));
            minZ = Math.min(minZ, Math.min(element.from.z, element.to.z));
            maxX = Math.max(maxX, Math.max(element.from.x, element.to.x));
            maxY = Math.max(maxY, Math.max(element.from.y, element.to.y));
            maxZ = Math.max(maxZ, Math.max(element.from.z, element.to.z));
        }
        float centerX = (minX + maxX) / 2.0f / 16.0f;
        float bottomY = minY / 16.0f;
        float centerZ = (minZ + maxZ) / 2.0f / 16.0f;
        return new Vector3(centerX, bottomY, centerZ);
    }

    private static void renderElementWireframe(class_4587 matrices, class_287 buffer, BBModelParts.Element element, Matrix4 rotationMatrix, BBModelParts.Element rootNode, Vector3 modelCenter, float scale, int red, int green, int blue, int alpha, class_2680 blockState, boolean recalc) {
        Vector3[] corners;
        if (element.from == null || element.to == null) {
            return;
        }
        if (recalc || !cornerCache.containsKey(element)) {
            corners = DecoPlacementRenderer.getBakedElementCorners(element, rootNode, scale, blockState);
            cornerCache.put(element, corners);
        } else {
            corners = cornerCache.get(element);
        }
        DecoPlacementRenderer.drawBoxEdges(matrices, buffer, corners, red, green, blue, alpha);
    }

    private static Vector3[] getBakedElementCorners(BBModelParts.Element element, BBModelParts.Element rootNode, float scale, class_2680 blockState) {
        Vector3[] corners;
        Matrix4f transformationMatrix = DecoPlacementRenderer.getTransformationMatrixFromBlockState(blockState);
        for (Vector3 corner : corners = DecoPlacementRenderer.createElementCorners(element)) {
            DecoPlacementRenderer.applyExactBakeryTransformation(corner, element, rootNode, scale, transformationMatrix);
        }
        return corners;
    }

    private static void applyExactBakeryTransformation(Vector3 pos, BBModelParts.Element element, BBModelParts.Element rootNode, float scale, Matrix4f transform) {
        DecoPlacementRenderer.applyElementRotation(pos, element);
        Matrix4 m = new Matrix4();
        m.setToScaling(scale, scale, scale);
        DecoPlacementRenderer.applyTransform(pos, m);
        m.setToTranslation(0.5f, 0.0f, 0.5f);
        DecoPlacementRenderer.applyTransform(pos, m);
        if (rootNode != null) {
            if (rootNode.position != null) {
                m.setToTranslation(-rootNode.position.x / 16.0f, -rootNode.position.y / 16.0f, -rootNode.position.z / 16.0f);
            } else if (rootNode.from != null) {
                m.setToTranslation(-rootNode.from.x / 16.0f, -rootNode.from.y / 16.0f, -rootNode.from.z / 16.0f);
            }
            DecoPlacementRenderer.applyTransform(pos, m);
        }
        DecoPlacementRenderer.rotateVertexByMatrix4f(pos, new Vector3(0.5f, 0.5f, 0.5f), transform);
    }

    private static Vector3[] createElementCorners(BBModelParts.Element element) {
        float x0 = element.from.x / 16.0f;
        float y0 = element.from.y / 16.0f;
        float z0 = element.from.z / 16.0f;
        float x1 = element.to.x / 16.0f;
        float y1 = element.to.y / 16.0f;
        float z1 = element.to.z / 16.0f;
        return new Vector3[]{new Vector3(x0, y0, z0), new Vector3(x1, y0, z0), new Vector3(x1, y1, z0), new Vector3(x0, y1, z0), new Vector3(x0, y0, z1), new Vector3(x1, y0, z1), new Vector3(x1, y1, z1), new Vector3(x0, y1, z1)};
    }

    private static Matrix4f getTransformationMatrixFromBlockState(class_2680 state) {
        Matrix4f mat = new Matrix4f();
        class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
        switch (facing) {
            case field_11034: {
                mat.rotateY((float)Math.toRadians(-90.0));
                break;
            }
            case field_11035: {
                mat.rotateY((float)Math.toRadians(180.0));
                break;
            }
            case field_11039: {
                mat.rotateY((float)Math.toRadians(90.0));
            }
        }
        return mat;
    }

    private static void drawBoxEdges(class_4587 matrices, class_287 buffer, Vector3[] corners, int r, int g, int b, int a) {
        float thickness = 0.005f;
        DecoPlacementRenderer.addThickLine(matrices, buffer, corners[0], corners[1], thickness, r, g, b, a);
        DecoPlacementRenderer.addThickLine(matrices, buffer, corners[1], corners[2], thickness, r, g, b, a);
        DecoPlacementRenderer.addThickLine(matrices, buffer, corners[2], corners[3], thickness, r, g, b, a);
        DecoPlacementRenderer.addThickLine(matrices, buffer, corners[3], corners[0], thickness, r, g, b, a);
        DecoPlacementRenderer.addThickLine(matrices, buffer, corners[4], corners[5], thickness, r, g, b, a);
        DecoPlacementRenderer.addThickLine(matrices, buffer, corners[5], corners[6], thickness, r, g, b, a);
        DecoPlacementRenderer.addThickLine(matrices, buffer, corners[6], corners[7], thickness, r, g, b, a);
        DecoPlacementRenderer.addThickLine(matrices, buffer, corners[7], corners[4], thickness, r, g, b, a);
        DecoPlacementRenderer.addThickLine(matrices, buffer, corners[0], corners[4], thickness, r, g, b, a);
        DecoPlacementRenderer.addThickLine(matrices, buffer, corners[1], corners[5], thickness, r, g, b, a);
        DecoPlacementRenderer.addThickLine(matrices, buffer, corners[2], corners[6], thickness, r, g, b, a);
        DecoPlacementRenderer.addThickLine(matrices, buffer, corners[3], corners[7], thickness, r, g, b, a);
    }

    private static void addThickLine(class_4587 matrices, class_287 buffer, Vector3 from, Vector3 to, float thickness, int r, int g, int b, int a) {
        Vector3 dir = new Vector3(to.x - from.x, to.y - from.y, to.z - from.z);
        float len = (float)Math.sqrt(dir.x * dir.x + dir.y * dir.y + dir.z * dir.z);
        if (len < 0.001f) {
            return;
        }
        dir.x /= len;
        dir.y /= len;
        dir.z /= len;
        Vector3 perp = Math.abs(dir.y) < 0.9f ? new Vector3(-dir.z, 0.0f, dir.x) : new Vector3(1.0f, -dir.x, 0.0f);
        float perpLen = (float)Math.sqrt(perp.x * perp.x + perp.y * perp.y + perp.z * perp.z);
        if (perpLen > 0.001f) {
            perp.x /= perpLen;
            perp.y /= perpLen;
            perp.z /= perpLen;
        }
        perp.x *= thickness * 0.5f;
        perp.y *= thickness * 0.5f;
        perp.z *= thickness * 0.5f;
        Vector3 p1 = new Vector3(from.x - perp.x, from.y - perp.y, from.z - perp.z);
        Vector3 p2 = new Vector3(from.x + perp.x, from.y + perp.y, from.z + perp.z);
        Vector3 p3 = new Vector3(to.x + perp.x, to.y + perp.y, to.z + perp.z);
        Vector3 p4 = new Vector3(to.x - perp.x, to.y - perp.y, to.z - perp.z);
        Matrix4f mat = matrices.method_23760().method_23761();
        buffer.method_22918(mat, p1.x, p1.y, p1.z).method_1336(r, g, b, a);
        buffer.method_22918(mat, p2.x, p2.y, p2.z).method_1336(r, g, b, a);
        buffer.method_22918(mat, p3.x, p3.y, p3.z).method_1336(r, g, b, a);
        buffer.method_22918(mat, p4.x, p4.y, p4.z).method_1336(r, g, b, a);
    }

    private static Matrix4 getRotationMatrix(class_2350 facing) {
        switch (facing) {
            case field_11043: {
                return ROTATION_TRANSFORMS[0];
            }
            case field_11035: {
                return ROTATION_TRANSFORMS[1];
            }
            case field_11034: {
                return ROTATION_TRANSFORMS[2];
            }
            case field_11039: {
                return ROTATION_TRANSFORMS[3];
            }
        }
        return ROTATION_TRANSFORMS[0];
    }

    private static void applyTransform(Vector3 pos, Matrix4 trans) {
        float x = trans.val[0] * pos.x + trans.val[4] * pos.y + trans.val[8] * pos.z + trans.val[12];
        float y = trans.val[1] * pos.x + trans.val[5] * pos.y + trans.val[9] * pos.z + trans.val[13];
        float z = trans.val[2] * pos.x + trans.val[6] * pos.y + trans.val[10] * pos.z + trans.val[14];
        pos.set(x, y, z);
    }

    private static void rotateVertexBy(Vector3 pos, Vector3 origin, Matrix4 mat4) {
        Vector3 delta = new Vector3(pos.x - origin.x, pos.y - origin.y, pos.z - origin.z);
        DecoPlacementRenderer.applyTransform(delta, mat4);
        pos.set(delta.x + origin.x, delta.y + origin.y, delta.z + origin.z);
    }

    private static void rotateVertexByMatrix4f(Vector3 pos, Vector3 origin, Matrix4f mat4) {
        Vector4f delta = new Vector4f(pos.x - origin.x, pos.y - origin.y, pos.z - origin.z, 1.0f);
        delta.mul((Matrix4fc)mat4);
        pos.set(delta.x + origin.x, delta.y + origin.y, delta.z + origin.z);
    }

    private static void applyElementRotation(Vector3 pos, BBModelParts.Element element) {
        Vector3 origin = new Vector3(element.origin.x, element.origin.y, element.origin.z);
        Vector3 rotation = element.rotation;
        BBModelParts.OutlinerGroup parent = element.parent;
        Quaternion quaternion = new Quaternion();
        while (true) {
            Vector3 originScaled = new Vector3(origin.x / 16.0f, origin.y / 16.0f, origin.z / 16.0f);
            if (rotation.x != 0.0f) {
                quaternion.set(Vector3.X, rotation.x);
                DecoPlacementRenderer.rotateVertexBy(pos, originScaled, new Matrix4(quaternion));
            }
            if (rotation.y != 0.0f) {
                quaternion.set(Vector3.Y, rotation.y);
                DecoPlacementRenderer.rotateVertexBy(pos, originScaled, new Matrix4(quaternion));
            }
            if (rotation.z != 0.0f) {
                quaternion.set(Vector3.Z, rotation.z);
                DecoPlacementRenderer.rotateVertexBy(pos, originScaled, new Matrix4(quaternion));
            }
            if (parent == null) break;
            origin = parent.origin;
            rotation = parent.rotation;
            parent = parent.parent;
        }
    }

    static {
        ROTATION_TRANSFORMS = new Matrix4[]{new Matrix4(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}), new Matrix4(new float[]{-1.0f, 0.0f, 8.742278E-8f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -8.742278E-8f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}), new Matrix4(new float[]{5.9604645E-8f, 0.0f, 0.99999994f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -0.99999994f, 0.0f, 5.9604645E-8f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}), new Matrix4(new float[]{5.9604645E-8f, 0.0f, -0.99999994f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.99999994f, 0.0f, 5.9604645E-8f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f})};
    }
}

