/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.client.screens;

import com.razz.decocraft.common.containers.DecobenchScreenHandler;
import com.razz.decocraft.common.groups.GroupSelector;
import com.razz.decocraft.common.items.DecoBlockItem;
import com.razz.decocraft.network.DecocraftPacketHandler;
import com.razz.decocraft.network.client.CDecobenchClick;
import com.razz.decocraft.network.client.CDecobenchCraft;
import com.razz.decocraft.network.client.CDecobenchScroll;
import com.razz.decocraft.network.client.CDecobenchSearch;
import com.razz.decocraft.network.client.CDecobenchSelectTab;
import com.razz.decocraft.utils.MapUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public class DecobenchScreen
extends AbstractContainerScreen<DecobenchScreenHandler> {
    private static final ResourceLocation DECOBENCH_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"decocraft", (String)"textures/gui/decobench.png");
    private static final int TABS_LEFT = 48;
    private static final int TABS_HSPACING = 127;
    private static final int TABS_TOP = 21;
    private static final int TABS_WIDTH = 9;
    private static final int TABS_HEIGHT = 9;
    private static final int ELEV_LEFT = 185;
    private static final int ELEV_TOP = 39;
    private static final int ELEV_ARROW_WIDTH = 9;
    private static final int ELEV_ARROW_HEIGHT = 8;
    private static final int ELEV_MAIN_WIDTH = 9;
    private static final int ELEV_MAIN_HEIGHT = 49;
    private static final int ELEV_CURSOR_WIDTH = 9;
    private static final int ELEV_CURSOR_HEIGHT = 6;
    private static final int ELEV_ARROW_VSPACING = 57;
    private static final int ELEV_MAIN_VSPACING = 8;
    private static final int ELEV_CURSOR_VSPACING = 9;
    private static final int CLOSE_LEFT = 188;
    private static final int CLOSE_TOP = 3;
    private static final int CLOSE_WIDTH = 11;
    private static final int CLOSE_HEIGHT = 11;
    private static final int CRAFTING_LEFT = 51;
    private static final int CRAFTING_TOP = 120;
    private static final int CRAFTING_WIDTH = 24;
    private static final int CRAFTING_HEIGHT = 11;
    private static final int SEARCH_LEFT = 188;
    private static final int SEARCH_TOP = 21;
    private static final int SEARCH_WIDTH = 11;
    private static final int SEARCH_HEIGHT = 11;
    private static final int INVENTORY_TOP = 140;
    private static final int INVENTORY_WIDTH = 171;
    private static final int INVENTORY_HEIGHT = 29;
    private static final int COLORS_LEFT = 9;
    private static final int COLORS_TOP = 54;
    private static final int COLORS_SPACING = 9;
    private static final int COLORS_HEIGHT = 25;
    private static final int RAW_MATERIAL_TOP = 107;
    private static final int RAW_MATERIAL_LEFT = 15;
    private static final int RAW_MATERIAL_WIDTH = 14;
    private static final int RAW_MATERIAL_HEIGHT = 16;
    private static final int CRAFTING_BAR_TOP = 122;
    private static final int CRAFTING_BAR_LEFT = 103;
    private static final int CRAFTING_BAR_WIDTH = 62;
    private static final int CRAFTING_BAR_HEIGHT = 7;
    private static final float COLORS_MAX_HEIGHT = 25.0f;
    private static final float CRAFTING_MAX_LENGTH = 60.0f;
    private final List<String> tabs = new ArrayList<String>();
    private float scrollOffset;
    private Button currentButton = Button.NONE;
    private boolean searchMode = false;
    private int currentTab = 0;
    private EditBox searchBox;
    private String prevTab = "all";
    private int elevCurVSpacing = 0;
    private Slot lastSlotClicked;
    private int cursorTimer = 0;
    private int[] cursorUV = new int[]{203, 22};
    private int craftTimer = 0;
    private int[] craftUV = new int[]{203, 66};

    public DecobenchScreen(DecobenchScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.imageWidth = 203;
        this.imageHeight = 140;
        this.tabs.add("all");
        MapUtil.sortByKey(GroupSelector.SELECT).forEach((key, value) -> this.tabs.add((String)key));
    }

    protected void init() {
        super.init();
        this.searchBox = new EditBox(this.font, this.leftPos + 49, this.topPos + 21, 133, 9, (Component)Component.translatable((String)"itemGroup.search"));
        this.searchBox.setMaxLength(50);
        this.searchBox.setBordered(true);
        this.searchBox.setVisible(false);
        this.searchBox.setTextColor(0xFFFFFF);
        this.addWidget((GuiEventListener)this.searchBox);
    }

    protected void containerTick() {
        AbstractContainerMenu abstractContainerMenu;
        super.containerTick();
        if (++this.cursorTimer >= 10) {
            this.cursorTimer = 0;
            int n = this.cursorUV[1] = this.cursorUV[1] == 22 ? 44 : 22;
        }
        if (!((abstractContainerMenu = this.menu) instanceof DecobenchScreenHandler)) {
            return;
        }
        DecobenchScreenHandler screenHandler = (DecobenchScreenHandler)abstractContainerMenu;
        if (this.minecraft != null && this.minecraft.level != null && this.minecraft.level.isClientSide()) {
            screenHandler.getColorRed();
        }
        if (screenHandler.crafting[0] == 0) {
            this.craftUV[0] = 203;
        } else if (++this.craftTimer >= 5) {
            this.craftTimer = 0;
            this.craftUV[0] = this.craftUV[0] == 203 ? 222 : 203;
        }
        switch (this.currentButton.ordinal()) {
            case 3: 
            case 5: {
                this.scrolled(1.0);
                break;
            }
            case 4: 
            case 6: {
                this.scrolled(-1.0);
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        AbstractContainerMenu craftingProgress2;
        Object colorsDisplay;
        DecobenchScreenHandler screenHandler;
        super.render(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.blit(DECOBENCH_TEXTURE, this.leftPos + 185, this.topPos + 39, 229, 0, 9, 8);
        guiGraphics.blit(DECOBENCH_TEXTURE, this.leftPos + 185, this.topPos + 39 + 57, 229, 8, 9, 8);
        guiGraphics.blit(DECOBENCH_TEXTURE, this.leftPos + 185, this.topPos + 39 + 8, 247, 0, 9, 49);
        guiGraphics.blit(DECOBENCH_TEXTURE, this.leftPos + 185, this.topPos + 39 + 9 + this.elevCurVSpacing, 247, 49, 9, 6);
        guiGraphics.blit(DECOBENCH_TEXTURE, this.leftPos + 188, this.topPos + 3, 225, 34, 11, 11);
        guiGraphics.blit(DECOBENCH_TEXTURE, this.leftPos + 51, this.topPos + 120, 205, 0, 24, 11);
        guiGraphics.blit(DECOBENCH_TEXTURE, this.leftPos + 188, this.topPos + 21, 225, 45, 11, 11);
        if (this.searchMode) {
            guiGraphics.blit(DECOBENCH_TEXTURE, this.leftPos + 188, this.topPos + 21, 236, 45, 11, 11);
        } else {
            guiGraphics.blit(DECOBENCH_TEXTURE, this.leftPos + 48, this.topPos + 21, 229, 16, 9, 9);
            guiGraphics.blit(DECOBENCH_TEXTURE, this.leftPos + 48 + 127, this.topPos + 21, 229, 25, 9, 9);
        }
        switch (this.currentButton.ordinal()) {
            case 1: {
                guiGraphics.blit(DECOBENCH_TEXTURE, this.leftPos + 48, this.topPos + 21, 238, 16, 9, 9);
                break;
            }
            case 2: {
                guiGraphics.blit(DECOBENCH_TEXTURE, this.leftPos + 48 + 127, this.topPos + 21, 238, 25, 9, 9);
                break;
            }
            case 3: {
                guiGraphics.blit(DECOBENCH_TEXTURE, this.leftPos + 185, this.topPos + 39, 238, 0, 9, 8);
                break;
            }
            case 4: {
                guiGraphics.blit(DECOBENCH_TEXTURE, this.leftPos + 185, this.topPos + 39 + 57, 238, 8, 9, 8);
                break;
            }
            case 7: {
                guiGraphics.blit(DECOBENCH_TEXTURE, this.leftPos + 185, this.topPos + 39 + 9 + this.elevCurVSpacing, 247, 55, 9, 6);
                break;
            }
            case 9: {
                guiGraphics.blit(DECOBENCH_TEXTURE, this.leftPos + 188, this.topPos + 3, 236, 34, 11, 11);
            }
        }
        guiGraphics.blit(DECOBENCH_TEXTURE, this.leftPos + 83, this.topPos + 120, this.craftUV[0], this.craftUV[1], 17, 13);
        AbstractContainerMenu abstractContainerMenu = this.menu;
        if (abstractContainerMenu instanceof DecobenchScreenHandler) {
            screenHandler = (DecobenchScreenHandler)abstractContainerMenu;
            colorsDisplay = new int[]{(int)Math.ceil(25.0f - (float)screenHandler.colors[0] / 256.0f * 25.0f), (int)Math.ceil(25.0f - (float)screenHandler.colors[1] / 256.0f * 25.0f), (int)Math.ceil(25.0f - (float)screenHandler.colors[2] / 256.0f * 25.0f)};
            guiGraphics.fill(this.leftPos + 9, this.topPos + 54 + colorsDisplay[0], this.leftPos + 9 + 9, this.topPos + 54 + 25, -65536);
            guiGraphics.fill(this.leftPos + 9 + 9, this.topPos + 54 + colorsDisplay[1], this.leftPos + 9 + 18, this.topPos + 54 + 25, -16711936);
            guiGraphics.fill(this.leftPos + 9 + 18, this.topPos + 54 + colorsDisplay[2], this.leftPos + 9 + 27, this.topPos + 54 + 25, -16776961);
        }
        guiGraphics.blit(DECOBENCH_TEXTURE, this.leftPos + 7, this.topPos + 53, 203, 108, 30, 33);
        if (this.lastSlotClicked != null) {
            guiGraphics.blit(DECOBENCH_TEXTURE, this.leftPos + this.lastSlotClicked.x - 5, this.topPos + this.lastSlotClicked.y - 2, this.cursorUV[0], this.cursorUV[1], 22, 22);
        }
        if ((colorsDisplay = this.menu) instanceof DecobenchScreenHandler) {
            screenHandler = (DecobenchScreenHandler)((Object)colorsDisplay);
            if (screenHandler.crafting[0] == 1) {
                guiGraphics.blit(DECOBENCH_TEXTURE, this.leftPos + 51, this.topPos + 120, 205, 11, 24, 11);
                int craftingProgress2 = (int)Math.ceil((float)screenHandler.crafting[1] / 40.0f * 60.0f);
                guiGraphics.fill(this.leftPos + 103 + 1, this.topPos + 122 + 1, this.leftPos + 103 + 1 + craftingProgress2, this.topPos + 122 + 6, -256);
                guiGraphics.blit(DECOBENCH_TEXTURE, this.leftPos + 103, this.topPos + 122, 171, 141, 62, 7);
            }
        }
        if ((craftingProgress2 = this.menu) instanceof DecobenchScreenHandler) {
            screenHandler = (DecobenchScreenHandler)craftingProgress2;
            if (screenHandler.rawMaterial[0] > 0) {
                guiGraphics.blit(DECOBENCH_TEXTURE, this.leftPos + 15, this.topPos + 107, 203, 92, 14, 16);
                String msg = String.valueOf(screenHandler.rawMaterial[0]);
                guiGraphics.drawString(this.font, msg, this.leftPos + 22 - this.font.width(msg) / 2, this.topPos + 107 + 16, 0xFFFFFF, false);
            }
        }
        if (this.searchMode) {
            this.searchBox.setVisible(true);
            this.searchBox.setFocused(true);
            this.searchBox.render(guiGraphics, mouseX, mouseY, delta);
        } else {
            this.searchBox.setVisible(false);
            this.searchBox.setFocused(false);
            String tab = StringUtils.capitalize((String)this.tabs.get(this.currentTab));
            int tabX = this.leftPos + 116 - this.font.width(tab) / 2;
            guiGraphics.drawString(this.font, tab, tabX, this.topPos + 21, 0xB0B0B0, false);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float delta, int mouseX, int mouseY) {
        int i = this.leftPos;
        int j = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(DECOBENCH_TEXTURE, i, j, 0, 0, this.imageWidth, this.imageHeight);
        guiGraphics.blit(DECOBENCH_TEXTURE, this.leftPos + this.imageWidth / 2 - 85, this.topPos + 140, 0, 141, 171, 29);
    }

    protected void slotClicked(Slot slot, int slotId, int button, ClickType actionType) {
        if (slotId < 11) {
            super.slotClicked(slot, slotId, button, ClickType.PICKUP);
        } else if (slot != null && slot.hasItem()) {
            this.lastSlotClicked = slot;
            this.cursorTimer = 0;
            DecocraftPacketHandler.sendToServer(new CDecobenchClick(slot.getItem()));
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Object decoItem;
        ItemStack stack;
        Item slotX2;
        Slot hoveredSlot = null;
        for (Slot slot : ((DecobenchScreenHandler)this.menu).slots) {
            int slotX2 = this.leftPos + slot.x;
            int slotY = this.topPos + slot.y;
            if (mouseX < slotX2 || mouseX >= slotX2 + 16 || mouseY < slotY || mouseY >= slotY + 16) continue;
            hoveredSlot = slot;
            break;
        }
        if (hoveredSlot != null && hoveredSlot.hasItem() && (slotX2 = (stack = hoveredSlot.getItem()).getItem()) instanceof DecoBlockItem) {
            int material;
            decoItem = (DecoBlockItem)slotX2;
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(stack.getHoverName());
            int red = ((DecoBlockItem)((Object)decoItem)).getRed();
            int green = ((DecoBlockItem)((Object)decoItem)).getGreen();
            int blue = ((DecoBlockItem)((Object)decoItem)).getBlue();
            if (red >= 0 && green >= 0 && blue >= 0) {
                tooltip.add(Component.literal((String)""));
                tooltip.add(Component.literal((String)("\u00a7cR\u00a72G\u00a79B\u00a7r: \u00a7c" + red + "\u00a7r \u00a72" + green + "\u00a7r \u00a79" + blue + "\u00a7r")));
            }
            if ((material = ((DecoBlockItem)((Object)decoItem)).getMaterial()) > 0) {
                tooltip.add(Component.literal((String)("Materials: " + material)));
            }
            guiGraphics.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
            return;
        }
        decoItem = this.menu;
        if (decoItem instanceof DecobenchScreenHandler) {
            DecobenchScreenHandler screenHandler = (DecobenchScreenHandler)((Object)decoItem);
            int relX = mouseX - this.leftPos;
            int relY = mouseY - this.topPos;
            if (relX >= 9 && relX <= 36 && relY >= 54 && relY <= 79) {
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                tooltip.add(Component.literal((String)("\u00a7cRed\u00a7r: \u00a7c" + screenHandler.colors[0] + "\u00a7r")));
                tooltip.add(Component.literal((String)("\u00a72Green\u00a7r: \u00a72" + screenHandler.colors[1] + "\u00a7r")));
                tooltip.add(Component.literal((String)("\u00a79Blue\u00a7r: \u00a79" + screenHandler.colors[2] + "\u00a7r")));
                guiGraphics.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
                return;
            }
            if (relX >= 15 && relX <= 29 && relY >= 107 && relY <= 123) {
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                tooltip.add(Component.literal((String)("Materials: " + screenHandler.rawMaterial[0])));
                guiGraphics.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
                return;
            }
        }
        super.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            double relX = mouseX - (double)this.leftPos;
            double relY = mouseY - (double)this.topPos;
            if (relX >= 48.0 && relX <= 57.0 && relY >= 21.0 && relY <= 30.0) {
                this.currentButton = Button.TABS_LEFT;
                --this.currentTab;
                if (this.currentTab < 0) {
                    this.currentTab = this.tabs.size() - 1;
                }
                this.updateTab(this.tabs.get(this.currentTab), 0.0f);
            } else if (relX >= 175.0 && relX <= 184.0 && relY >= 21.0 && relY <= 30.0) {
                this.currentButton = Button.TABS_RIGHT;
                ++this.currentTab;
                if (this.currentTab >= this.tabs.size()) {
                    this.currentTab = 0;
                }
                this.updateTab(this.tabs.get(this.currentTab), 0.0f);
            } else if (relX >= 185.0 && relX <= 194.0 && relY >= 39.0 && relY <= 47.0) {
                this.currentButton = Button.ELEV_UP;
            } else if (relX >= 185.0 && relX <= 194.0 && relY >= 96.0 && relY <= 104.0) {
                this.currentButton = Button.ELEV_DOWN;
            } else if (relX >= 186.0 && relX <= 193.0 && relY >= 48.0 && relY <= (double)(48 + this.elevCurVSpacing)) {
                this.currentButton = Button.ELEV_MAIN_TOP;
            } else if (relX >= 186.0 && relX <= 193.0 && relY >= (double)(48 + this.elevCurVSpacing + 6) && relY <= 96.0) {
                this.currentButton = Button.ELEV_MAIN_BOTTOM;
            } else if (relX >= 185.0 && relX <= 194.0 && relY >= (double)(48 + this.elevCurVSpacing) && relY <= (double)(54 + this.elevCurVSpacing)) {
                this.currentButton = Button.ELEV_CURSOR;
            } else if (relX >= 188.0 && relX <= 199.0 && relY >= 3.0 && relY <= 14.0) {
                this.currentButton = Button.CLOSE;
                this.onClose();
            } else if (relX >= 51.0 && relX <= 75.0 && relY >= 120.0 && relY <= 131.0) {
                this.currentButton = Button.CRAFTING;
                AbstractContainerMenu abstractContainerMenu = this.menu;
                if (abstractContainerMenu instanceof DecobenchScreenHandler) {
                    DecobenchScreenHandler screenHandler = (DecobenchScreenHandler)abstractContainerMenu;
                    screenHandler.crafting[0] = screenHandler.crafting[0] == 0 ? 1 : 0;
                    DecocraftPacketHandler.sendToServer(new CDecobenchCraft(screenHandler.crafting[0]));
                }
            } else if (relX >= 188.0 && relX <= 199.0 && relY >= 21.0 && relY <= 32.0) {
                this.currentButton = Button.SEARCH;
                if (this.searchMode) {
                    this.searchMode = false;
                    this.updateTab(this.prevTab, 0.0f);
                } else {
                    this.searchMode = true;
                    this.prevTab = this.tabs.get(this.currentTab);
                    this.updateTab("all", 0.0f);
                    if (this.searchBox != null) {
                        DecocraftPacketHandler.sendToServer(new CDecobenchSearch(this.searchBox.getValue()));
                    }
                }
            } else {
                Slot slot;
                this.currentButton = Button.NONE;
                if (relX >= 0.0 && relX <= (double)this.imageWidth && relY >= 0.0 && relY <= (double)this.imageHeight && (slot = this.getSlotUnderMouse()) == null) {
                    return true;
                }
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.currentButton = Button.NONE;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0 && this.currentButton == Button.ELEV_CURSOR) {
            this.scrolled(-deltaY * 2.0);
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!this.canScroll()) {
            return false;
        }
        this.scrolled(verticalAmount);
        return true;
    }

    private void scrolled(double delta) {
        AbstractContainerMenu abstractContainerMenu = this.menu;
        if (!(abstractContainerMenu instanceof DecobenchScreenHandler)) {
            return;
        }
        DecobenchScreenHandler screenHandler = (DecobenchScreenHandler)abstractContainerMenu;
        int rows = (screenHandler.getItemsSize() + 7 - 1) / 7 - 4;
        this.scrollOffset = Mth.clamp((float)((float)((double)this.scrollOffset - delta / (double)rows)), (float)0.0f, (float)1.0f);
        this.elevCurVSpacing = (int)(this.scrollOffset * 42.0f);
        screenHandler.scrollTo(this.scrollOffset);
        DecocraftPacketHandler.sendToServer(new CDecobenchScroll(this.scrollOffset));
        if (this.lastSlotClicked != null && this.lastSlotClicked.hasItem()) {
            DecocraftPacketHandler.sendToServer(new CDecobenchClick(this.lastSlotClicked.getItem()));
        }
    }

    private void updateTab(String name, float offset) {
        AbstractContainerMenu abstractContainerMenu = this.menu;
        if (abstractContainerMenu instanceof DecobenchScreenHandler) {
            DecobenchScreenHandler handler = (DecobenchScreenHandler)abstractContainerMenu;
            handler.getTabItems(name);
            handler.scrollTo(offset);
        }
        this.scrollOffset = offset;
        this.scrolled(offset);
        DecocraftPacketHandler.sendToServer(new CDecobenchSelectTab(name, offset));
        DecocraftPacketHandler.sendToServer(new CDecobenchScroll(offset));
    }

    private boolean canScroll() {
        AbstractContainerMenu abstractContainerMenu = this.menu;
        if (abstractContainerMenu instanceof DecobenchScreenHandler) {
            DecobenchScreenHandler screenHandler = (DecobenchScreenHandler)abstractContainerMenu;
            return screenHandler.canScroll();
        }
        return false;
    }

    public boolean charTyped(char chr, int modifiers) {
        if (!this.searchMode || this.searchBox == null) {
            return super.charTyped(chr, modifiers);
        }
        this.searchBox.charTyped(chr, modifiers);
        AbstractContainerMenu abstractContainerMenu = this.menu;
        if (abstractContainerMenu instanceof DecobenchScreenHandler) {
            DecobenchScreenHandler handler = (DecobenchScreenHandler)abstractContainerMenu;
            handler.search(this.searchBox.getValue());
        }
        DecocraftPacketHandler.sendToServer(new CDecobenchSearch(this.searchBox.getValue()));
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.searchMode || this.searchBox == null) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        this.searchBox.keyPressed(keyCode, scanCode, modifiers);
        AbstractContainerMenu abstractContainerMenu = this.menu;
        if (abstractContainerMenu instanceof DecobenchScreenHandler) {
            DecobenchScreenHandler handler = (DecobenchScreenHandler)abstractContainerMenu;
            handler.search(this.searchBox.getValue());
        }
        DecocraftPacketHandler.sendToServer(new CDecobenchSearch(this.searchBox.getValue()));
        return true;
    }

    public Slot getSlotUnderMouse() {
        for (int i = 0; i < ((DecobenchScreenHandler)this.menu).slots.size(); ++i) {
            Slot slot = (Slot)((DecobenchScreenHandler)this.menu).slots.get(i);
            if (!this.isHovering(slot.x, slot.y, 16, 16, this.minecraft.mouseHandler.xpos(), this.minecraft.mouseHandler.ypos())) continue;
            return slot;
        }
        return null;
    }

    private static enum Button {
        NONE,
        TABS_LEFT,
        TABS_RIGHT,
        ELEV_UP,
        ELEV_DOWN,
        ELEV_MAIN_TOP,
        ELEV_MAIN_BOTTOM,
        ELEV_CURSOR,
        CRAFTING,
        CLOSE,
        SEARCH;

    }
}

