/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.razz.decocraft.DecoException;
import com.razz.decocraft.client.render.AnimatedModelRenderer;
import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import com.razz.decocraft.common.properties.DecoProperty;
import com.razz.decocraft.common.tileentities.AnimatedTileEntity;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelParts;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;

public class AnimatedRenderer
extends TileEntityRenderer<AnimatedTileEntity> {
    private static final String ROOT = "ROOT";
    private static Map<String, ModelRenderer> CACHE = new HashMap<String, ModelRenderer>();

    public AnimatedRenderer(TileEntityRendererDispatcher p_i226006_1_) {
        super(p_i226006_1_);
    }

    public void render(AnimatedTileEntity tileEntity, float partialTick, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        tileEntity.addTimer(partialTick / 20.0f);
        if (!tileEntity.func_145830_o()) {
            return;
        }
        BlockState blockstate = tileEntity.func_145831_w().func_180495_p(tileEntity.func_174877_v());
        if (!blockstate.func_235901_b_((Property)DecoProperty.FACING)) {
            return;
        }
        Direction facing = (Direction)blockstate.func_177229_b((Property)DecoProperty.FACING);
        DecocraftBlock block = (DecocraftBlock)blockstate.func_177230_c();
        ModelRenderer model = this.parseModel(block.meta, block.model, tileEntity);
        RenderMaterial material = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("decocraft", "block/" + block.meta.material));
        IVertexBuilder vertexUV = material.func_229311_a_(bufferIn, RenderType::func_228644_e_);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229180_c_, facing.func_185119_l(), true));
        matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229178_a_, 180.0f, true));
        matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229182_e_, 180.0f, true));
        switch (facing) {
            case NORTH: {
                matrixStackIn.func_227861_a_(0.5, 0.0, 0.5);
                break;
            }
            case SOUTH: {
                matrixStackIn.func_227861_a_(-0.5, 0.0, -0.5);
                break;
            }
            case EAST: {
                matrixStackIn.func_227861_a_(0.5, 0.0, -0.5);
                break;
            }
            case WEST: {
                matrixStackIn.func_227861_a_(-0.5, 0.0, 0.5);
                break;
            }
        }
        model.func_228308_a_(matrixStackIn, vertexUV, combinedLightIn, combinedOverlayIn);
        matrixStackIn.func_227865_b_();
    }

    private ModelRenderer parseModel(JsonContainer.Entry meta, BBModel bbmodel, AnimatedTileEntity tileEntity) {
        AnimatedModelRenderer model = new AnimatedModelRenderer(bbmodel.resolution.width, bbmodel.resolution.height, null, ROOT);
        Map<String, Map<BBModelParts.Channel, float[]>> keyframes = tileEntity.getKeyframes();
        this.parseOutliners(bbmodel.resolution.width, bbmodel.resolution.height, new BBModelParts.ElementBase(), bbmodel.outliner, bbmodel.uuidMap, model, ROOT, keyframes);
        return model;
    }

    private void parseOutliners(int width, int height, BBModelParts.ElementBase topNode, List<BBModelParts.OutlinerNode> nodes, Map<String, BBModelParts.ElementBase> uuidMap, ModelRenderer topRenderer, String path, Map<String, Map<BBModelParts.Channel, float[]>> keyframes) {
        for (BBModelParts.OutlinerNode outNode : nodes) {
            BBModelParts.ElementBase elementBase;
            if (outNode instanceof BBModelParts.OutlinerGroup) {
                elementBase = (BBModelParts.OutlinerGroup)outNode;
            } else if (outNode instanceof BBModelParts.OutlinerCube) {
                elementBase = uuidMap.get(((BBModelParts.OutlinerCube)outNode).uuid);
            } else {
                throw new DecoException("Error processing the outliners");
            }
            String name = path + "/" + elementBase.name;
            AnimatedModelRenderer modelRenderer = new AnimatedModelRenderer(width, height, Objects.equals(elementBase.type, "cube") ? (BBModelParts.Element)elementBase : null, name);
            float[] animRot = new float[]{0.0f, 0.0f, 0.0f};
            float[] animPos = new float[]{0.0f, 0.0f, 0.0f};
            if (keyframes.get(elementBase.uuid) != null) {
                if (keyframes.get(elementBase.uuid).get((Object)BBModelParts.Channel.ROTATION) != null) {
                    animRot = keyframes.get(elementBase.uuid).get((Object)BBModelParts.Channel.ROTATION);
                }
                if (keyframes.get(elementBase.uuid).get((Object)BBModelParts.Channel.POSITION) != null) {
                    animPos = keyframes.get(elementBase.uuid).get((Object)BBModelParts.Channel.POSITION);
                }
            }
            modelRenderer.func_78793_a(elementBase.origin.x - topNode.origin.x - animPos[0], elementBase.origin.y - topNode.origin.y + animPos[1], elementBase.origin.z - topNode.origin.z + animPos[2]);
            modelRenderer.field_78795_f = elementBase.rotation.x - animRot[0];
            modelRenderer.field_78796_g = elementBase.rotation.y - animRot[1];
            modelRenderer.field_78808_h = elementBase.rotation.z + animRot[2];
            topRenderer.func_78792_a((ModelRenderer)modelRenderer);
            if (Objects.equals(elementBase.type, "cube")) {
                BBModelParts.Element element = (BBModelParts.Element)elementBase;
                modelRenderer.func_228300_a_(element.from.x - element.origin.x, element.from.y - element.origin.y, element.from.z - element.origin.z, element.to.x - element.from.x, element.to.y - element.from.y, element.to.z - element.from.z);
                continue;
            }
            BBModelParts.ElementBase group = elementBase;
            this.parseOutliners(width, height, elementBase, group.children, uuidMap, modelRenderer, name, keyframes);
        }
    }
}

