/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.client.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.razz.decocraft.common.containers.DecobenchContainer;
import com.razz.decocraft.common.groups.GroupSelector;
import com.razz.decocraft.common.items.DecoBlockItem;
import com.razz.decocraft.network.DecocraftPacketHandler;
import com.razz.decocraft.network.client.CDecobenchClick;
import com.razz.decocraft.network.client.CDecobenchCraft;
import com.razz.decocraft.network.client.CDecobenchScroll;
import com.razz.decocraft.network.client.CDecobenchSearch;
import com.razz.decocraft.network.client.CDecobenchSelectTab;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public class DecobenchScreen
extends ContainerScreen<DecobenchContainer> {
    private static final ResourceLocation DECOBENCH_LOCATION = new ResourceLocation("decocraft", "gui/decobench.png");
    private static final ResourceLocation RAW_MATERIAL_LOCATION = new ResourceLocation("decocraft", "textures/item/raw_material.png");
    private static final int TABS_LEFT = 48;
    private static final int TABS_HSPACING = 127;
    private static final int TABS_TOP = 21;
    private static final int TABS_WIDTH = 9;
    private static final int TABS_HEIGHT = 9;
    private static final int ELEV_LEFT = 185;
    private static final int ELEV_TOP = 39;
    private static final int ELEV_ARROW_WIDTH = 9;
    private static final int ELEV_ARROW_HEIGHT = 8;
    private static final int ELEV_MAIN_WIDTH = 9;
    private static final int ELEV_MAIN_HEIGHT = 49;
    private static final int ELEV_CURSOR_WIDTH = 9;
    private static final int ELEV_CURSOR_HEIGHT = 6;
    private static final int ELEV_ARROW_VSPACING = 57;
    private static final int ELEV_MAIN_VSPACING = 8;
    private static final int ELEV_CURSOR_VSPACING = 9;
    private static final int CLOSE_LEFT = 188;
    private static final int CLOSE_TOP = 3;
    private static final int CLOSE_WIDTH = 11;
    private static final int CLOSE_HEIGHT = 11;
    private static final int CRAFTING_LEFT = 51;
    private static final int CRAFTING_TOP = 120;
    private static final int CRAFTING_WIDTH = 24;
    private static final int CRAFTING_HEIGHT = 11;
    private static final int SEARCH_LEFT = 188;
    private static final int SEARCH_TOP = 21;
    private static final int SEARCH_WIDTH = 11;
    private static final int SEARCH_HEIGHT = 11;
    private static final int INVENTORY_TOP = 140;
    private static final int INVENTORY_WIDTH = 171;
    private static final int INVENTORY_HEIGHT = 29;
    private static final int COLORS_LEFT = 9;
    private static final int COLORS_TOP = 54;
    private static final int COLORS_SPACING = 9;
    private static final int COLORS_HEIGHT = 25;
    private static final int RAW_MATERIAL_TOP = 107;
    private static final int RAW_MATERIAL_LEFT = 15;
    private static final int RAW_MATERIAL_WIDTH = 14;
    private static final int RAW_MATERIAL_HEIGTH = 16;
    private static final int CRAFTING_BAR_TOP = 122;
    private static final int CRAFTING_BAR_LEFT = 103;
    private static final int CRAFTING_BAR_WIDTH = 62;
    private static final int CRAFTING_BAR_HEIGHT = 7;
    private static final float COLORS_MAX_HEIGHT = 25.0f;
    private static final float CRAFTING_MAX_LENGHT = 60.0f;
    private final List<String> tabs = new ArrayList<String>();
    private float scrollOffset;
    private Button currentButton = Button.NONE;
    private boolean searchMode = false;
    private int currentTab = 0;
    private TextFieldWidget searchBox;
    private String prevTab = "all";
    private int elevCurVSpacing = 0;
    private Slot lastSlotClicked;
    private int cursorTimer = 0;
    private int[] cursorUV = new int[]{203, 22};
    private int craftTimer = 0;
    private int[] craftUV = new int[]{203, 66};

    public DecobenchScreen(DecobenchContainer container, PlayerInventory inventory, ITextComponent title) {
        super((Container)container, inventory, title);
        this.field_146999_f = 203;
        this.field_147000_g = 140;
        this.tabs.add("all");
        GroupSelector.SELECT.forEach((key, value) -> this.tabs.add((String)key));
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.searchBox = new TextFieldWidget(this.field_230712_o_, this.field_147003_i + 49, this.field_147009_r + 21, 133, 9, (ITextComponent)new TranslationTextComponent("itemGroup.search"));
        this.searchBox.func_146203_f(50);
        this.searchBox.func_146185_a(true);
        this.searchBox.func_146189_e(false);
        this.searchBox.func_146193_g(0xFFFFFF);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        ++this.cursorTimer;
        if (this.cursorTimer >= 10) {
            this.cursorTimer = 0;
            int n = this.cursorUV[1] = this.cursorUV[1] == 22 ? 44 : 22;
        }
        if (((DecobenchContainer)this.field_147002_h).crafting[0] == 0) {
            this.craftUV[0] = 203;
        } else {
            ++this.craftTimer;
            if (this.craftTimer >= 5) {
                this.craftTimer = 0;
                this.craftUV[0] = this.craftUV[0] == 203 ? 222 : 203;
            }
        }
        switch (this.currentButton) {
            case ELEV_UP: 
            case ELEV_MAIN_TOP: {
                this.scrolled(1.0);
                break;
            }
            case ELEV_DOWN: 
            case ELEV_MAIN_BOTTOM: {
                this.scrolled(-1.0);
            }
        }
    }

    public void func_230430_a_(MatrixStack matrix, int x, int y, float partialTicks) {
        this.func_230446_a_(matrix);
        super.func_230430_a_(matrix, x, y, partialTicks);
        this.field_230706_i_.func_110434_K().func_110577_a(DECOBENCH_LOCATION);
        DecobenchScreen.func_238463_a_((MatrixStack)matrix, (int)(this.field_147003_i + 185), (int)(this.field_147009_r + 39), (float)229.0f, (float)0.0f, (int)9, (int)8, (int)256, (int)256);
        DecobenchScreen.func_238463_a_((MatrixStack)matrix, (int)(this.field_147003_i + 185), (int)(this.field_147009_r + 39 + 57), (float)229.0f, (float)8.0f, (int)9, (int)8, (int)256, (int)256);
        DecobenchScreen.func_238463_a_((MatrixStack)matrix, (int)(this.field_147003_i + 185), (int)(this.field_147009_r + 39 + 8), (float)247.0f, (float)0.0f, (int)9, (int)49, (int)256, (int)256);
        DecobenchScreen.func_238463_a_((MatrixStack)matrix, (int)(this.field_147003_i + 185), (int)(this.field_147009_r + 39 + 9 + this.elevCurVSpacing), (float)247.0f, (float)49.0f, (int)9, (int)6, (int)256, (int)256);
        DecobenchScreen.func_238463_a_((MatrixStack)matrix, (int)(this.field_147003_i + 188), (int)(this.field_147009_r + 3), (float)225.0f, (float)34.0f, (int)11, (int)11, (int)256, (int)256);
        DecobenchScreen.func_238463_a_((MatrixStack)matrix, (int)(this.field_147003_i + 51), (int)(this.field_147009_r + 120), (float)205.0f, (float)0.0f, (int)24, (int)11, (int)256, (int)256);
        DecobenchScreen.func_238463_a_((MatrixStack)matrix, (int)(this.field_147003_i + 188), (int)(this.field_147009_r + 21), (float)225.0f, (float)45.0f, (int)11, (int)11, (int)256, (int)256);
        if (this.searchMode) {
            DecobenchScreen.func_238463_a_((MatrixStack)matrix, (int)(this.field_147003_i + 188), (int)(this.field_147009_r + 21), (float)236.0f, (float)45.0f, (int)11, (int)11, (int)256, (int)256);
        } else {
            DecobenchScreen.func_238463_a_((MatrixStack)matrix, (int)(this.field_147003_i + 48), (int)(this.field_147009_r + 21), (float)229.0f, (float)16.0f, (int)9, (int)9, (int)256, (int)256);
            DecobenchScreen.func_238463_a_((MatrixStack)matrix, (int)(this.field_147003_i + 48 + 127), (int)(this.field_147009_r + 21), (float)229.0f, (float)25.0f, (int)9, (int)9, (int)256, (int)256);
        }
        switch (this.currentButton) {
            case TABS_LEFT: {
                DecobenchScreen.func_238463_a_((MatrixStack)matrix, (int)(this.field_147003_i + 48), (int)(this.field_147009_r + 21), (float)238.0f, (float)16.0f, (int)9, (int)9, (int)256, (int)256);
                break;
            }
            case TABS_RIGHT: {
                DecobenchScreen.func_238463_a_((MatrixStack)matrix, (int)(this.field_147003_i + 48 + 127), (int)(this.field_147009_r + 21), (float)238.0f, (float)25.0f, (int)9, (int)9, (int)256, (int)256);
                break;
            }
            case ELEV_UP: {
                DecobenchScreen.func_238463_a_((MatrixStack)matrix, (int)(this.field_147003_i + 185), (int)(this.field_147009_r + 39), (float)238.0f, (float)0.0f, (int)9, (int)8, (int)256, (int)256);
                break;
            }
            case ELEV_DOWN: {
                DecobenchScreen.func_238463_a_((MatrixStack)matrix, (int)(this.field_147003_i + 185), (int)(this.field_147009_r + 39 + 57), (float)238.0f, (float)8.0f, (int)9, (int)8, (int)256, (int)256);
                break;
            }
            case ELEV_CURSOR: {
                DecobenchScreen.func_238463_a_((MatrixStack)matrix, (int)(this.field_147003_i + 185), (int)(this.field_147009_r + 39 + 9 + this.elevCurVSpacing), (float)247.0f, (float)55.0f, (int)9, (int)6, (int)256, (int)256);
                break;
            }
            case CLOSE: {
                DecobenchScreen.func_238463_a_((MatrixStack)matrix, (int)(this.field_147003_i + 188), (int)(this.field_147009_r + 3), (float)236.0f, (float)34.0f, (int)11, (int)11, (int)256, (int)256);
            }
        }
        DecobenchScreen.func_238463_a_((MatrixStack)matrix, (int)(this.field_147003_i + 83), (int)(this.field_147009_r + 120), (float)this.craftUV[0], (float)this.craftUV[1], (int)17, (int)13, (int)256, (int)256);
        int[] colorsDisplay = new int[]{(int)Math.ceil(25.0f - (float)((DecobenchContainer)this.field_147002_h).colors[0] / 256.0f * 25.0f), (int)Math.ceil(25.0f - (float)((DecobenchContainer)this.field_147002_h).colors[1] / 256.0f * 25.0f), (int)Math.ceil(25.0f - (float)((DecobenchContainer)this.field_147002_h).colors[2] / 256.0f * 25.0f)};
        this.func_238468_a_(matrix, this.field_147003_i + 9, this.field_147009_r + 54 + colorsDisplay[0], this.field_147003_i + 9 + 9, this.field_147009_r + 54 + 25, -65536, -65536);
        this.func_238468_a_(matrix, this.field_147003_i + 9 + 9, this.field_147009_r + 54 + colorsDisplay[1], this.field_147003_i + 9 + 18, this.field_147009_r + 54 + 25, -16711936, -16711936);
        this.func_238468_a_(matrix, this.field_147003_i + 9 + 18, this.field_147009_r + 54 + colorsDisplay[2], this.field_147003_i + 9 + 27, this.field_147009_r + 54 + 25, -16776961, -16776961);
        DecobenchScreen.func_238463_a_((MatrixStack)matrix, (int)(this.field_147003_i + 7), (int)(this.field_147009_r + 53), (float)203.0f, (float)108.0f, (int)30, (int)33, (int)256, (int)256);
        if (this.lastSlotClicked != null) {
            DecobenchScreen.func_238463_a_((MatrixStack)matrix, (int)(this.field_147003_i + this.lastSlotClicked.field_75223_e - 5), (int)(this.field_147009_r + this.lastSlotClicked.field_75221_f - 2), (float)this.cursorUV[0], (float)this.cursorUV[1], (int)22, (int)22, (int)256, (int)256);
        }
        if (((DecobenchContainer)this.field_147002_h).crafting[0] == 1) {
            DecobenchScreen.func_238463_a_((MatrixStack)matrix, (int)(this.field_147003_i + 51), (int)(this.field_147009_r + 120), (float)205.0f, (float)11.0f, (int)24, (int)11, (int)256, (int)256);
            int crafting = (int)Math.ceil((float)((DecobenchContainer)this.field_147002_h).crafting[1] / 40.0f * 60.0f);
            this.func_238468_a_(matrix, this.field_147003_i + 103 + 1, this.field_147009_r + 122 + 1, this.field_147003_i + 103 + 1 + crafting, this.field_147009_r + 122 + 6, -256, -256);
            DecobenchScreen.func_238463_a_((MatrixStack)matrix, (int)(this.field_147003_i + 103), (int)(this.field_147009_r + 122), (float)171.0f, (float)141.0f, (int)62, (int)7, (int)256, (int)256);
        }
        if (((DecobenchContainer)this.field_147002_h).rawMaterial[0] > 0) {
            DecobenchScreen.func_238463_a_((MatrixStack)matrix, (int)(this.field_147003_i + 15), (int)(this.field_147009_r + 107), (float)203.0f, (float)92.0f, (int)14, (int)16, (int)256, (int)256);
            String msg = String.valueOf(((DecobenchContainer)this.field_147002_h).rawMaterial[0]);
            this.field_230712_o_.func_238421_b_(matrix, msg, (float)this.field_147003_i + 22.0f - (float)this.field_230712_o_.func_78256_a(msg) / 2.0f, (float)(this.field_147009_r + 107 + 16), 0xFFFFFF);
        }
        if (this.searchMode) {
            this.searchBox.func_146189_e(true);
            this.searchBox.func_146205_d(false);
            this.searchBox.func_146195_b(true);
            this.searchBox.func_230430_a_(matrix, x, y, partialTicks);
        } else {
            this.searchBox.func_146189_e(false);
            this.searchBox.func_146205_d(true);
            this.searchBox.func_146195_b(false);
            String tab = StringUtils.capitalize((String)this.tabs.get(this.currentTab));
            this.field_230712_o_.func_238421_b_(matrix, tab, (float)this.field_147003_i + 116.0f - (float)this.field_230712_o_.func_78256_a(tab) / 2.0f, (float)(this.field_147009_r + 21), 0xB0B0B0);
        }
        this.func_230459_a_(matrix, x, y);
    }

    protected void func_230459_a_(MatrixStack matrix, int x, int y) {
        if (this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.field_147006_u != null && this.field_147006_u.func_75216_d()) {
            this.func_230457_a_(matrix, this.field_147006_u.func_75211_c(), x, y);
        } else if (x >= this.field_147003_i + 9 && x <= this.field_147003_i + 9 + 27 && y >= this.field_147009_r + 54 && y <= this.field_147009_r + 54 + 25) {
            ArrayList<TranslationTextComponent> tooltip = new ArrayList<TranslationTextComponent>();
            tooltip.add(new TranslationTextComponent(String.format("\u00a7cRed\u00a7r: \u00a7c%d\u00a7r", ((DecobenchContainer)this.field_147002_h).colors[0])));
            tooltip.add(new TranslationTextComponent(String.format("\u00a72Green\u00a7r: \u00a72%d\u00a7r", ((DecobenchContainer)this.field_147002_h).colors[1])));
            tooltip.add(new TranslationTextComponent(String.format("\u00a79Blue\u00a7r: \u00a79%d\u00a7r", ((DecobenchContainer)this.field_147002_h).colors[2])));
            this.renderWrappedToolTip(matrix, tooltip, x, y, this.field_230712_o_);
        } else if (x >= this.field_147003_i + 15 && x <= this.field_147003_i + 15 + 14 && y >= this.field_147009_r + 107 && y <= this.field_147009_r + 107 + 16) {
            ArrayList<TranslationTextComponent> tooltip = new ArrayList<TranslationTextComponent>();
            tooltip.add(new TranslationTextComponent(String.format("Materials: %d", ((DecobenchContainer)this.field_147002_h).rawMaterial[0])));
            this.renderWrappedToolTip(matrix, tooltip, x, y, this.field_230712_o_);
        }
    }

    protected void func_230457_a_(MatrixStack matrix, ItemStack itemStack, int x, int y) {
        List tooltip = itemStack.func_82840_a((PlayerEntity)this.field_230706_i_.field_71439_g, (ITooltipFlag)(this.field_230706_i_.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        if (itemStack.func_77973_b() instanceof DecoBlockItem) {
            DecoBlockItem blockItem = (DecoBlockItem)itemStack.func_77973_b();
            tooltip.add(new TranslationTextComponent(""));
            tooltip.add(new TranslationTextComponent(String.format("\u00a7cR\u00a72G\u00a79B\u00a7r: \u00a7c%d \u00a72%d \u00a79%d\u00a7r", blockItem.getRed(), blockItem.getGreen(), blockItem.getBlue())));
            tooltip.add(new TranslationTextComponent(String.format("Materials: %d", blockItem.getMaterial())));
        }
        FontRenderer font = itemStack.func_77973_b().getFontRenderer(itemStack);
        GuiUtils.preItemToolTip((ItemStack)itemStack);
        this.renderWrappedToolTip(matrix, tooltip, x, y, font == null ? this.field_230712_o_ : font);
        GuiUtils.postItemToolTip();
    }

    protected void func_230451_b_(MatrixStack matrix, int x, int y) {
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTick, int x, int y) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(DECOBENCH_LOCATION);
        int i = this.field_147003_i;
        int j = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrix, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_238474_b_(matrix, this.field_147003_i + this.field_146999_f / 2 - 85, this.field_147009_r + 140, 0, 141, 171, 29);
    }

    private boolean canScroll() {
        return ((DecobenchContainer)this.field_147002_h).canScroll();
    }

    protected void func_184098_a(@Nullable Slot slot, int slotId, int button, ClickType clickType) {
        if (slotId < 11) {
            super.func_184098_a(slot, slotId, button, ClickType.PICKUP);
        } else {
            this.lastSlotClicked = slot;
            this.cursorTimer = 0;
            DecocraftPacketHandler.HANDLER.send(PacketDistributor.SERVER.noArg(), (Object)new CDecobenchClick(slot.func_75211_c()));
        }
    }

    public boolean func_231044_a_(double x, double y, int button) {
        if (button == 0) {
            double d0 = x - (double)this.field_147003_i;
            double d1 = y - (double)this.field_147009_r;
            if (d0 >= 48.0 && d0 <= 57.0 && d1 >= 21.0 && d1 <= 30.0) {
                this.currentButton = Button.TABS_LEFT;
                --this.currentTab;
                if (this.currentTab < 0) {
                    this.currentTab = this.tabs.size() - 1;
                }
                this.updateTab(this.tabs.get(this.currentTab), 0.0f);
            } else if (d0 >= 175.0 && d0 <= 184.0 && d1 >= 21.0 && d1 <= 30.0) {
                this.currentButton = Button.TABS_RIGHT;
                ++this.currentTab;
                if (this.currentTab >= this.tabs.size()) {
                    this.currentTab = 0;
                }
                this.updateTab(this.tabs.get(this.currentTab), 0.0f);
            } else if (d0 >= 185.0 && d0 <= 194.0 && d1 >= 39.0 && d1 <= 47.0) {
                this.currentButton = Button.ELEV_UP;
            } else if (d0 >= 185.0 && d0 <= 194.0 && d1 >= 96.0 && d1 <= 104.0) {
                this.currentButton = Button.ELEV_DOWN;
            } else if (d0 >= 186.0 && d0 <= 193.0 && d1 >= 48.0 && d1 <= (double)(48 + this.elevCurVSpacing)) {
                this.currentButton = Button.ELEV_MAIN_TOP;
            } else if (d0 >= 186.0 && d0 <= 193.0 && d1 >= (double)(48 + this.elevCurVSpacing + 6) && d1 <= 96.0) {
                this.currentButton = Button.ELEV_MAIN_BOTTOM;
            } else if (d0 >= 185.0 && d0 <= 194.0 && d1 >= (double)(48 + this.elevCurVSpacing) && d1 <= (double)(54 + this.elevCurVSpacing)) {
                this.currentButton = Button.ELEV_CURSOR;
            } else if (d0 >= 188.0 && d0 <= 199.0 && d1 >= 3.0 && d1 <= 14.0) {
                this.currentButton = Button.CLOSE;
                this.field_230706_i_.func_147108_a(null);
            } else if (d0 >= 51.0 && d0 <= 75.0 && d1 >= 120.0 && d1 <= 131.0) {
                this.currentButton = Button.CRAFTING;
                ((DecobenchContainer)this.field_147002_h).crafting[0] = ((DecobenchContainer)this.field_147002_h).crafting[0] == 0 ? 1 : 0;
                DecocraftPacketHandler.HANDLER.send(PacketDistributor.SERVER.noArg(), (Object)new CDecobenchCraft(((DecobenchContainer)this.field_147002_h).crafting[0]));
            } else if (d0 >= 188.0 && d0 <= 199.0 && d1 >= 21.0 && d1 <= 32.0) {
                this.currentButton = Button.SEARCH;
                if (this.searchMode) {
                    this.searchMode = false;
                    this.updateTab(this.prevTab, 0.0f);
                } else {
                    this.searchMode = true;
                    this.prevTab = this.tabs.get(this.currentTab);
                    this.updateTab("all", 0.0f);
                    DecocraftPacketHandler.HANDLER.send(PacketDistributor.SERVER.noArg(), (Object)new CDecobenchSearch(this.searchBox.func_146179_b()));
                }
            } else {
                this.currentButton = Button.NONE;
            }
        }
        return super.func_231044_a_(x, y, button);
    }

    public boolean func_231048_c_(double x, double y, int button) {
        if (button == 0) {
            double d0 = x - (double)this.field_147003_i;
            double d1 = y - (double)this.field_147009_r;
            this.currentButton = Button.NONE;
        }
        return super.func_231048_c_(x, y, button);
    }

    public boolean func_231045_a_(double x, double y, int button, double dragX, double dragY) {
        if (button == 0 && this.currentButton == Button.ELEV_CURSOR) {
            this.scrolled(-dragY * 2.0);
        }
        return super.func_231045_a_(x, y, button, dragX, dragY);
    }

    public boolean func_231043_a_(double x, double y, double delta) {
        if (!this.canScroll()) {
            return false;
        }
        this.scrolled(delta);
        return true;
    }

    private void scrolled(double delta) {
        int i = (((DecobenchContainer)this.field_147002_h).items.size() + 7 - 1) / 7 - 4;
        this.scrollOffset = (float)((double)this.scrollOffset - delta / (double)i);
        this.scrollOffset = MathHelper.func_76131_a((float)this.scrollOffset, (float)0.0f, (float)1.0f);
        this.elevCurVSpacing = (int)(this.scrollOffset * 42.0f);
        ((DecobenchContainer)this.field_147002_h).scrollTo(this.scrollOffset);
        DecocraftPacketHandler.HANDLER.send(PacketDistributor.SERVER.noArg(), (Object)new CDecobenchScroll(this.scrollOffset));
        if (this.lastSlotClicked != null) {
            DecocraftPacketHandler.HANDLER.send(PacketDistributor.SERVER.noArg(), (Object)new CDecobenchClick(this.lastSlotClicked.func_75211_c()));
        }
    }

    private void updateTab(String name, float offset) {
        ((DecobenchContainer)this.field_147002_h).getTabItems(name);
        this.scrollOffset = offset;
        this.scrolled(offset);
        DecocraftPacketHandler.HANDLER.send(PacketDistributor.SERVER.noArg(), (Object)new CDecobenchSelectTab(name));
        DecocraftPacketHandler.HANDLER.send(PacketDistributor.SERVER.noArg(), (Object)new CDecobenchScroll(offset));
    }

    public boolean func_231042_a_(char pCodePoint, int pModifiers) {
        if (this.searchMode) {
            this.searchBox.func_231042_a_(pCodePoint, pModifiers);
            DecocraftPacketHandler.HANDLER.send(PacketDistributor.SERVER.noArg(), (Object)new CDecobenchSearch(this.searchBox.func_146179_b()));
            return true;
        }
        return super.func_231042_a_(pCodePoint, pModifiers);
    }

    public boolean func_231046_a_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.searchMode) {
            this.searchBox.func_231046_a_(pKeyCode, pScanCode, pModifiers);
            DecocraftPacketHandler.HANDLER.send(PacketDistributor.SERVER.noArg(), (Object)new CDecobenchSearch(this.searchBox.func_146179_b()));
            return true;
        }
        return super.func_231046_a_(pKeyCode, pScanCode, pModifiers);
    }

    private static enum Button {
        NONE,
        TABS_LEFT,
        TABS_RIGHT,
        ELEV_UP,
        ELEV_DOWN,
        ELEV_MAIN_TOP,
        ELEV_MAIN_BOTTOM,
        ELEV_CURSOR,
        CRAFTING,
        CLOSE,
        SEARCH;

    }
}

