/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.blocks;

import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import com.razz.decocraft.common.entities.DecoSeatEntity;
import com.razz.decocraft.common.properties.DecoProperty;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelParts;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class DecoSeatBlock
extends DecocraftBlock {
    private final Map<Integer, Vector3f> sittingNodes = new HashMap<Integer, Vector3f>();

    public DecoSeatBlock(JsonContainer.Entry meta, BBModel model) {
        super(meta, model);
        model.outlinerFlatList.stream().filter(outliner -> outliner.name.equals("sitting_node")).flatMap(outliner -> ((BBModelParts.OutlinerGroup)outliner).children.stream()).filter(node -> node instanceof BBModelParts.OutlinerCube).forEach(node -> {
            BBModelParts.Element element = (BBModelParts.Element)model.uuidMap.get(((BBModelParts.OutlinerCube)node).uuid);
            Vector3f sittingNode = new Vector3f(0.0f, 0.0f, 0.0f);
            if (element.position != null) {
                sittingNode = new Vector3f(element.position.x / 16.0f * meta.scale, element.position.y / 16.0f * meta.scale, element.position.z / 16.0f * meta.scale);
            } else if (element.from != null) {
                sittingNode = new Vector3f(element.from.x / 16.0f * meta.scale, element.from.y / 16.0f * meta.scale, element.from.z / 16.0f * meta.scale);
            }
            this.sittingNodes.put(Integer.parseInt(element.name), sittingNode);
        });
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DecoProperty.FACING});
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)DecoProperty.FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    @Override
    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        List seats;
        if (!world.field_72995_K && (seats = world.func_217357_a(DecoSeatEntity.class, new AxisAlignedBB((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), (double)blockPos.func_177958_n() + 1.0, (double)blockPos.func_177956_o() + 1.0, (double)blockPos.func_177952_p() + 1.0))).isEmpty()) {
            Vector3f offset = this.sittingNodes.get(0);
            Direction direction = (Direction)blockState.func_177229_b((Property)DecoProperty.FACING);
            Vector3f vect = offset;
            DecoSeatEntity seat = new DecoSeatEntity(world, blockPos, vect);
            world.func_217376_c((Entity)seat);
            playerEntity.func_184205_a((Entity)seat, false);
        }
        return ActionResultType.SUCCESS;
    }
}

