/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.blocks;

import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.ModuleBlocks;
import com.razz.decocraft.common.ModuleSounds;
import com.razz.decocraft.common.properties.DecoProperty;
import com.razz.decocraft.common.tileentities.AnimatedTileEntity;
import com.razz.decocraft.common.tileentities.DecocraftTileEntity;
import com.razz.decocraft.models.bbmodel.BBHitBox;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelParts;
import com.razz.decocraft.utils.Particle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DecocraftBlock
extends Block
implements ITileEntityProvider {
    private static final Map<String, VoxelShape[]> CACHE_HIT_BOXES = new HashMap<String, VoxelShape[]>();
    public final JsonContainer.Entry meta;
    public final BBModel model;
    private final VoxelShape[] shape;
    private final Map<String, Particle> particles;

    public DecocraftBlock(JsonContainer.Entry meta, BBModel model) {
        super(DecocraftBlock.getProperties(meta));
        this.meta = meta;
        this.model = model;
        this.shape = this.parseHitBox(meta, model);
        this.particles = this.parseParticles();
    }

    private Map<String, Particle> parseParticles() {
        if (this.meta.script.particles == null) {
            return null;
        }
        HashMap<String, Particle> particles = new HashMap<String, Particle>();
        for (Map.Entry<String, JsonContainer.Particle> entry : this.meta.script.particles.entrySet()) {
            JsonContainer.Particle particle = entry.getValue();
            this.model.outlinerFlatList.stream().filter(outliner -> outliner.name.equals("particle_" + (String)entry.getKey())).forEach(node -> {
                BBModelParts.Element element = (BBModelParts.Element)this.model.uuidMap.get(node.uuid);
                particles.put((String)entry.getKey(), new Particle(new ResourceLocation(particle.name), 0.5f + element.position.x / 16.0f, element.position.y / 16.0f, 0.5f + element.position.z / 16.0f, particle.vx, particle.vy, particle.vz, particle.delay));
            });
        }
        return particles;
    }

    private static AbstractBlock.Properties getProperties(JsonContainer.Entry meta) {
        if (meta.passable) {
            return AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200942_a();
        }
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_226896_b_();
    }

    public static void script(World world, BlockPos blockPos, BlockState blockState, JsonContainer.Action action) {
        if (action != null) {
            if (action.link != null) {
                DecocraftBlock.scriptLink(world, blockPos, blockState, action.link);
            }
            if (action.sound != null) {
                DecocraftBlock.scriptSound(world, blockPos, blockState, action.sound);
            }
            if (action.animations != null) {
                DecocraftBlock.scriptAnimations(world, blockPos, blockState, action.animations);
            }
        }
    }

    public static void scriptLink(World world, BlockPos blockPos, BlockState blockState, String link) {
        BlockState state = (BlockState)((Block)ModuleBlocks.DECOBLOCKS.get(link).get()).func_176223_P().func_206870_a((Property)DecoProperty.FACING, blockState.func_177229_b((Property)DecoProperty.FACING));
        world.func_180501_a(blockPos, state, 10);
    }

    public static void scriptSound(World world, BlockPos blockPos, BlockState blockState, String sound) {
        world.func_184148_a(null, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), (SoundEvent)ModuleSounds.SOUNDS.get(sound).get(), SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public static void scriptAnimations(World world, BlockPos blockPos, BlockState blockState, List<JsonContainer.Animation> animations) {
        TileEntity te;
        if (!world.func_201670_d() && (te = world.func_175625_s(blockPos)) instanceof AnimatedTileEntity) {
            AnimatedTileEntity tile = (AnimatedTileEntity)te;
            JsonContainer.Animation anim = animations.stream().filter(k -> Objects.equals(k.from, tile.getAnimationName()) || Objects.equals(k.from, "any")).findFirst().orElse(animations.get(0));
            tile.setAnimationName(anim.to);
        }
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState p_220080_1_, IBlockReader p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    private VoxelShape[] parseHitBox(JsonContainer.Entry meta, BBModel model) {
        if (!CACHE_HIT_BOXES.containsKey(meta.model + "_" + meta.scale)) {
            CACHE_HIT_BOXES.put(meta.model + "_" + meta.scale, BBHitBox.parse(meta.scale, ModuleBlocks.MAT_TO_BB_MODEL.get(meta.shape)));
        }
        return CACHE_HIT_BOXES.get(meta.model + "_" + meta.scale);
    }

    public VoxelShape[] getShape() {
        return this.shape;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DecoProperty.FACING});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)DecoProperty.FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public long func_209900_a(BlockState blockState, BlockPos blockPos) {
        return MathHelper.func_180186_a((Vector3i)blockPos);
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader reader, BlockPos blockPos, ISelectionContext context) {
        Direction direction = (Direction)blockState.func_177229_b((Property)DecoProperty.FACING);
        switch (direction) {
            case NORTH: {
                return this.shape[0];
            }
            case SOUTH: {
                return this.shape[1];
            }
            case EAST: {
                return this.shape[2];
            }
            case WEST: {
                return this.shape[3];
            }
        }
        return this.shape[0];
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if (playerEntity.func_225608_bj_() && this.meta.script.shift_on_use != null) {
            DecocraftBlock.script(world, blockPos, blockState, this.meta.script.shift_on_use);
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        if (!playerEntity.func_225608_bj_() && this.meta.script.on_use != null) {
            DecocraftBlock.script(world, blockPos, blockState, this.meta.script.on_use);
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    public void func_220082_b(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean p_220082_5_) {
        DecocraftBlock.script(world, blockPos, blockState, this.meta.script.added);
    }

    public void func_196243_a(BlockState blockState, World world, BlockPos blockPos, BlockState replaced, boolean p_196243_5_) {
        super.func_196243_a(blockState, world, blockPos, replaced, p_196243_5_);
        DecocraftBlock.script(world, blockPos, blockState, this.meta.script.removed);
    }

    public void onAnimationStart(BlockState blockState, World world, BlockPos blockPos) {
        DecocraftBlock.script(world, blockPos, blockState, this.meta.script.animation_start);
    }

    public void onAnimationEnd(BlockState blockState, World world, BlockPos blockPos) {
        DecocraftBlock.script(world, blockPos, blockState, this.meta.script.animation_end);
    }

    public void onToolModelSwitch(BlockState blockState, World world, BlockPos blockPos) {
        DecocraftBlock.script(world, blockPos, blockState, this.meta.script.tool_modelswitch);
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader p_196283_1_) {
        return this.meta.script.trigger != null || this.meta.flipbook.images > 1 ? new DecocraftTileEntity(this.meta) : null;
    }

    public boolean hasTileEntity(BlockState state) {
        return this.meta.script.trigger != null || this.meta.flipbook.images > 1;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return this.meta.script.light;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        if (this.particles != null) {
            for (Map.Entry<String, Particle> entry : this.particles.entrySet()) {
                Particle particle = entry.getValue();
                BasicParticleType particleType = (BasicParticleType)Registry.field_212632_u.func_82594_a(particle.particleType);
                world.func_195594_a((IParticleData)particleType, (double)((float)pos.func_177958_n() + particle.x), (double)((float)pos.func_177956_o() + particle.y), (double)((float)pos.func_177952_p() + particle.z), (double)particle.vx, (double)particle.vy, (double)particle.vz);
            }
        }
    }
}

