/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.containers;

import com.razz.decocraft.common.ModuleContainers;
import com.razz.decocraft.common.items.DecoBlockItem;
import com.razz.decocraft.common.tileentities.DecomposerTileEntity;
import com.razz.mods.Mods;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class DecomposerContainer
extends Container {
    private static final int SPACING = 18;
    private static final int INVENTORY_X = -26;
    private static final int INVENTORY_Y = 117;
    public final NonNullList<ItemStack> items = NonNullList.func_191196_a();
    public final IWorldPosCallable access;
    public int[] crafting = new int[2];
    public int[] fuel = new int[1];
    private DecomposerTileEntity decomposerTE;
    private World world;

    public DecomposerContainer(int containerId, PlayerInventory playerInventory) {
        this(containerId, playerInventory, IWorldPosCallable.field_221489_a);
    }

    public DecomposerContainer(int containerId, PlayerInventory inventory, IWorldPosCallable access) {
        super((ContainerType)ModuleContainers.DECOMPOSER.get(), containerId);
        this.access = access;
        this.access.func_221486_a((world, pos) -> {
            this.decomposerTE = (DecomposerTileEntity)world.func_175625_s(pos);
            this.world = world;
        });
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventory, i, -26 + i * 18, 117));
        }
        this.func_75146_a(new Slot((IInventory)(this.decomposerTE == null ? new Inventory(1) : this.decomposerTE.getInput()), 0, 28, 38){

            public boolean func_75214_a(ItemStack stack) {
                if (stack == ItemStack.field_190927_a) {
                    return false;
                }
                boolean found = stack.func_77973_b() instanceof DecoBlockItem;
                if (!found) {
                    for (Map.Entry<String, Integer> entry : Mods.DECOMPOSER_INGREDIENTS.entrySet()) {
                        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entry.getKey()));
                        if (item == null) {
                            item = Items.field_190931_a;
                        }
                        try {
                            if (!stack.func_77969_a(item.func_190903_i()) && !stack.func_77973_b().func_206844_a((ITag)ItemTags.func_199901_a((String)entry.getKey()))) continue;
                            found = true;
                            break;
                        }
                        catch (IllegalStateException illegalStateException) {
                        }
                    }
                }
                return found;
            }
        });
        this.func_75146_a(new Slot((IInventory)(this.decomposerTE == null ? new Inventory(1) : this.decomposerTE.getResult()), 0, 63, 38){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }
        });
        this.func_75146_a(new Slot((IInventory)(this.decomposerTE == null ? new Inventory(1) : this.decomposerTE.getFuel()), 0, 10, 84){

            public boolean func_75214_a(ItemStack stack) {
                if ("".equals("")) {
                    return ForgeHooks.getBurnTime((ItemStack)stack, null) > 0;
                }
                return stack.func_77969_a(((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(""))).func_190903_i());
            }
        });
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.crafting, (int)0));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.crafting, (int)1));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.fuel, (int)0));
        this.getTEData();
    }

    private void getTEData() {
        if (this.world != null && !this.world.func_201670_d()) {
            this.crafting[0] = this.decomposerTE.getCraft();
            this.crafting[1] = this.decomposerTE.getCraftingTimer();
            this.fuel[0] = this.decomposerTE.getCurrentFuel();
        }
    }

    public boolean func_75145_c(PlayerEntity player) {
        return (Boolean)this.access.func_221485_a((world, pos) -> player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0, (Object)true);
    }

    public void func_75142_b() {
        this.getTEData();
        super.func_75142_b();
    }

    public ItemStack func_184996_a(int pSlotId, int pButton, ClickType pClickType, PlayerEntity pPlayer) {
        ClickType type = pClickType == ClickType.QUICK_MOVE ? ClickType.PICKUP : pClickType;
        return this.func_241440_b_(pSlotId, pButton, type, pPlayer);
    }

    public void craft(int craft) {
        this.decomposerTE.setCraft(craft);
    }
}

