/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.items;

import com.razz.decocraft.common.blocks.DecocraftBlock;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.math.AxisAlignedBB;

public class DecoBlockItem
extends BlockItem {
    private static final float CRAFTING_SCALE = 32.0f;
    private final int material;
    private int red = -1;
    private int green = -1;
    private int blue = -1;

    public DecoBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
        DecocraftBlock decoblock = (DecocraftBlock)block;
        if (decoblock.meta.crafting_color[0] >= 0.0f && decoblock.meta.crafting_color[1] >= 0.0f && decoblock.meta.crafting_color[2] >= 0.0f) {
            this.red = Math.round(decoblock.meta.crafting_color[0] / 100.0f * 32.0f);
            this.green = Math.round(decoblock.meta.crafting_color[1] / 100.0f * 32.0f);
            this.blue = Math.round(decoblock.meta.crafting_color[2] / 100.0f * 32.0f);
        }
        AxisAlignedBB bounds = decoblock.getShape()[0].func_197752_a();
        this.material = Math.min(Math.max((int)Math.ceil((bounds.field_72336_d - bounds.field_72340_a) * (bounds.field_72337_e - bounds.field_72338_b) * (bounds.field_72334_f - bounds.field_72339_c)), 1), 10);
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getMaterial() {
        return this.material;
    }
}

