/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.models.bbmodel;

import com.razz.decocraft.models.bbmodel.BBModelParts;
import com.razz.decocraft.models.bbmodel.BlockbenchLoader;
import com.razz.decocraft.models.libgdx.Matrix4;
import com.razz.decocraft.models.libgdx.Quaternion;
import com.razz.decocraft.models.libgdx.Vector3;
import net.minecraft.client.renderer.FaceDirection;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.client.ForgeHooksClient;

public class BlockbenchBakery {
    private static Vector3 vec3iToVec3(Vector3i vec3i) {
        return new Vector3(vec3i.func_177958_n(), vec3i.func_177956_o(), vec3i.func_177952_p());
    }

    public BakedQuad bakeQuad(BBModelParts.Element element, BlockbenchLoader.BlockbenchSetting settings, BBModelParts.Element rootNode, BBModelParts.UVCoordinate uvs, BBModelParts.Resolution resolution, TextureAtlasSprite texture, Direction direc, IModelTransform modelTransform) {
        int[] vertices = this.makeVertices(element, settings, rootNode, uvs, resolution, texture, direc, this.setupShape(element.from, element.to, element.inflate), modelTransform.func_225615_b_());
        Direction direction = this.calculateFacing(vertices);
        ForgeHooksClient.fillNormal((int[])vertices, (Direction)direction);
        return new BakedQuad(vertices, -1, direction, texture, element.shade);
    }

    private int[] makeVertices(BBModelParts.Element element, BlockbenchLoader.BlockbenchSetting setting, BBModelParts.Element rootNode, BBModelParts.UVCoordinate uvs, BBModelParts.Resolution resolution, TextureAtlasSprite texture, Direction direction, float[] positions, TransformationMatrix transformationMatrix) {
        int[] vertices = new int[32];
        for (int i = 0; i < 4; ++i) {
            this.bakeVertex(vertices, i, rootNode, direction, setting, uvs, resolution, positions, texture, transformationMatrix, element);
        }
        return vertices;
    }

    private void bakeVertex(int[] vertices, int index, BBModelParts.Element rootNode, Direction direction, BlockbenchLoader.BlockbenchSetting setting, BBModelParts.UVCoordinate uvs, BBModelParts.Resolution resolution, float[] positions, TextureAtlasSprite texture, TransformationMatrix transformationMatrix, BBModelParts.Element element) {
        FaceDirection.VertexInformation vertexInfo = FaceDirection.func_179027_a((Direction)direction).func_179025_a(index);
        Vector3 pos = new Vector3(positions[vertexInfo.field_179184_a], positions[vertexInfo.field_179182_b], positions[vertexInfo.field_179183_c]);
        this.applyElementRotation(pos, element);
        Matrix4 mat4 = new Matrix4();
        this.applyTransform(pos, mat4.setToScaling(setting.scale, setting.scale, setting.scale));
        this.applyTransform(pos, mat4.setToTranslation(0.5f, 0.0f, 0.5f));
        if (rootNode != null) {
            if (rootNode.position != null) {
                this.applyTransform(pos, mat4.setToTranslation(-rootNode.position.x / 16.0f, -rootNode.position.y / 16.0f, -rootNode.position.z / 16.0f));
            } else if (rootNode.from != null) {
                this.applyTransform(pos, mat4.setToTranslation(-rootNode.from.x / 16.0f, -rootNode.from.y / 16.0f, -rootNode.from.z / 16.0f));
            }
        }
        this.applyModelRotation(pos, new Vector3(0.5f, 0.5f, 0.5f), transformationMatrix);
        this.fillVertex(vertices, index, setting, pos, texture, uvs, resolution);
    }

    private void applyTransform(Vector3 pos, Matrix4 trans) {
        pos.set(trans.val[0] * pos.x + trans.val[4] * pos.y + trans.val[8] * pos.z + trans.val[12] * 1.0f, trans.val[1] * pos.x + trans.val[5] * pos.y + trans.val[9] * pos.z + trans.val[13] * 1.0f, trans.val[2] * pos.x + trans.val[6] * pos.y + trans.val[10] * pos.z + trans.val[14] * 1.0f);
    }

    private void rotateVertexBy(Vector3 pos, Vector3 origin, Matrix4 mat4) {
        Vector3 delta = new Vector3(pos.x - origin.x, pos.y - origin.y, pos.z - origin.z);
        this.applyTransform(delta, mat4);
        pos.set(delta.x + origin.x, delta.y + origin.y, delta.z + origin.z);
    }

    private void rotateVertexBy(Vector3 pos, Vector3 origin, Matrix4f mat4) {
        Vector4f delta = new Vector4f(pos.x - origin.x, pos.y - origin.y, pos.z - origin.z, 1.0f);
        delta.func_229372_a_(mat4);
        pos.set(delta.func_195910_a() + origin.x, delta.func_195913_b() + origin.y, delta.func_195914_c() + origin.z);
    }

    private void applyModelRotation(Vector3 pos, Vector3 rot, TransformationMatrix transformationMatrix) {
        if (transformationMatrix != TransformationMatrix.func_227983_a_()) {
            this.rotateVertexBy(pos, rot, transformationMatrix.func_227988_c_());
        }
    }

    private void applyElementRotation(Vector3 pos, BBModelParts.Element element) {
        Vector3 origin = new Vector3(element.origin.x, element.origin.y, element.origin.z);
        Vector3 rotation = element.rotation;
        BBModelParts.OutlinerGroup parent = element.parent;
        Quaternion quaternion = new Quaternion();
        while (true) {
            if (rotation.x != 0.0f) {
                quaternion.set(Vector3.X, rotation.x);
                this.rotateVertexBy(pos, new Vector3(origin.x / 16.0f, origin.y / 16.0f, origin.z / 16.0f), new Matrix4(quaternion));
            }
            if (rotation.y != 0.0f) {
                quaternion.set(Vector3.Y, rotation.y);
                this.rotateVertexBy(pos, new Vector3(origin.x / 16.0f, origin.y / 16.0f, origin.z / 16.0f), new Matrix4(quaternion));
            }
            if (rotation.z != 0.0f) {
                quaternion.set(Vector3.Z, rotation.z);
                this.rotateVertexBy(pos, new Vector3(origin.x / 16.0f, origin.y / 16.0f, origin.z / 16.0f), new Matrix4(quaternion));
            }
            if (parent == null) break;
            origin = parent.origin;
            rotation = parent.rotation;
            parent = parent.parent;
        }
    }

    private void fillVertex(int[] vertices, int index, BlockbenchLoader.BlockbenchSetting setting, Vector3 pos, TextureAtlasSprite texture, BBModelParts.UVCoordinate uvs, BBModelParts.Resolution resolution) {
        int i = index * 8;
        float u = -1.0f;
        float v = -1.0f;
        if (!setting.flipV) {
            switch (index) {
                case 0: {
                    u = uvs.u0;
                    v = uvs.v0;
                    break;
                }
                case 1: {
                    u = uvs.u0;
                    v = uvs.v1;
                    break;
                }
                case 2: {
                    u = uvs.u1;
                    v = uvs.v1;
                    break;
                }
                case 3: {
                    u = uvs.u1;
                    v = uvs.v0;
                }
            }
        } else {
            switch (index) {
                case 2: {
                    u = uvs.u1;
                    v = uvs.v0;
                    break;
                }
                case 3: {
                    u = uvs.u1;
                    v = uvs.v1;
                    break;
                }
                case 0: {
                    u = uvs.u0;
                    v = uvs.v1;
                    break;
                }
                case 1: {
                    u = uvs.u0;
                    v = uvs.v0;
                }
            }
        }
        vertices[i] = Float.floatToRawIntBits(pos.x);
        vertices[i + 1] = Float.floatToRawIntBits(pos.y);
        vertices[i + 2] = Float.floatToRawIntBits(pos.z);
        vertices[i + 3] = -1;
        vertices[i + 4] = Float.floatToRawIntBits(texture.func_94214_a((double)(u / ((float)resolution.width / 16.0f))));
        vertices[i + 4 + 1] = Float.floatToRawIntBits(texture.func_94207_b((double)(v / ((float)resolution.height / 16.0f))));
    }

    private float[] setupShape(Vector3 from, Vector3 to, float inflate) {
        float[] afloat = new float[Direction.values().length];
        afloat[FaceDirection.Constants.field_179176_f] = (from.x - inflate / 2.0f) / 16.0f;
        afloat[FaceDirection.Constants.field_179178_e] = (from.y - inflate / 2.0f) / 16.0f;
        afloat[FaceDirection.Constants.field_179177_d] = (from.z - inflate / 2.0f) / 16.0f;
        afloat[FaceDirection.Constants.field_179180_c] = (to.x + inflate / 2.0f) / 16.0f;
        afloat[FaceDirection.Constants.field_179179_b] = (to.y + inflate / 2.0f) / 16.0f;
        afloat[FaceDirection.Constants.field_179181_a] = (to.z + inflate / 2.0f) / 16.0f;
        return afloat;
    }

    private Direction calculateFacing(int[] vertices) {
        Vector3 pos1 = new Vector3(Float.intBitsToFloat(vertices[0]), Float.intBitsToFloat(vertices[1]), Float.intBitsToFloat(vertices[2]));
        Vector3 pos2 = new Vector3(Float.intBitsToFloat(vertices[8]), Float.intBitsToFloat(vertices[9]), Float.intBitsToFloat(vertices[10]));
        Vector3 pos3 = new Vector3(Float.intBitsToFloat(vertices[16]), Float.intBitsToFloat(vertices[17]), Float.intBitsToFloat(vertices[18]));
        Vector3 delta1 = pos1.cpy();
        delta1.sub(pos2);
        Vector3 delta2 = pos3.cpy();
        delta2.sub(pos2);
        Vector3 cross = delta2.cpy();
        cross.crs(delta1);
        cross.nor();
        Direction direction = null;
        float f = 0.0f;
        for (Direction direc : Direction.values()) {
            Vector3 normal = BlockbenchBakery.vec3iToVec3(direc.func_176730_m());
            float f1 = cross.dot(normal);
            if (!(f1 >= 0.0f) || !(f1 > f)) continue;
            f = f1;
            direction = direc;
        }
        return direction == null ? Direction.UP : direction;
    }
}

