/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.models.bbmodel;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelLoader;
import com.razz.decocraft.models.bbmodel.BlockbenchModel;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelLoader;

public class BlockbenchLoader
implements IModelLoader<BlockbenchModel> {
    public static BlockbenchLoader INSTANCE = new BlockbenchLoader();
    private final Map<BlockbenchSetting, BlockbenchModel> modelCache = Maps.newHashMap();
    private IResourceManager manager = Minecraft.func_71410_x().func_195551_G();

    public void func_195410_a(IResourceManager resourceManager) {
        this.modelCache.clear();
        this.manager = resourceManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BlockbenchModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        if (!modelContents.has("model")) {
            throw new RuntimeException("Blockbench Loader requires a 'model' key that points to a valid .BBModel.");
        }
        String modelLocation = modelContents.get("model").getAsString();
        float scale = modelContents.has("scale") ? JSONUtils.func_151217_k((JsonObject)modelContents, (String)"scale") : 1.0f;
        boolean flipV = JSONUtils.func_151209_a((JsonObject)modelContents, (String)"flip-v", (boolean)false);
        String material = JSONUtils.func_151219_a((JsonObject)modelContents, (String)"material", (String)"UNKNOWN");
        BlockbenchSetting settings = new BlockbenchSetting(new ResourceLocation(modelLocation), scale, flipV, material);
        try (IResource resource = this.manager.func_199002_a(settings.modelLocation);){
            InputStreamReader lineStream = new InputStreamReader(resource.func_199027_b(), Charsets.UTF_8);
            BufferedReader lineReader = new BufferedReader(lineStream);
            BBModel model = new BBModelLoader().loadModel(lineReader);
            BlockbenchModel blockbenchModel = new BlockbenchModel(settings, model);
            return blockbenchModel;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not find BBModel", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not read BBModel", e);
        }
    }

    public static class BlockbenchSetting {
        public final ResourceLocation modelLocation;
        public final float scale;
        public final boolean flipV;
        public final String material;

        public BlockbenchSetting(ResourceLocation modelLocation, float scale, boolean flipV, String material) {
            this.modelLocation = modelLocation;
            this.scale = scale;
            this.flipV = flipV;
            this.material = material;
        }
    }
}

