/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.models.geometry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;

public class GeometryJson {
    public GeometryMain model;

    public GeometryJson(String file) {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        gsonBuilder.registerTypeAdapter(UV.class, (Object)new UVDeserializer());
        Gson gson = gsonBuilder.create();
        try (FileReader reader = new FileReader(file);){
            this.model = (GeometryMain)gson.fromJson((Reader)reader, GeometryMain.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        GeometryMain model = new GeometryJson((String)"src/main/resources/assets/decocraft/models/portable_record_player.json").model;
        System.out.println(model.geometries[0].bones[0].cubes[0].uv.north);
    }

    public static class GeometryMain {
        public String format_version;
        @SerializedName(value="minecraft:geometry")
        public Geometry[] geometries;
    }

    public static class Geometry {
        public Description description;
        public Bone[] bones;
    }

    public static class Description {
        public String identifier;
        public int texture_width;
        public int texture_height;
        public float visible_bounds_width;
        public float visible_bounds_height;
        public float[] visible_bounds_offset;
    }

    public static class Bone {
        public String name;
        public float[] pivot;
        public Cube[] cubes;
    }

    public static class Cube {
        public float[] origin;
        public float[] size;
        public UV uv;
        public float[] pivot;
        public float[] rotation;
    }

    public static class UV {
        public Integer[] uv;
        public Orientation north;
        public Orientation east;
        public Orientation south;
        public Orientation west;
        public Orientation up;
        public Orientation down;
    }

    public static class Orientation {
        public int[] uv;
        public int[] uv_size;
    }

    private static class UVDeserializer
    implements JsonDeserializer<UV> {
        private final Gson gson = new Gson();

        private UVDeserializer() {
        }

        public UV deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            UV uv = new UV();
            if (json.isJsonArray()) {
                uv.uv = (Integer[])this.gson.fromJson(json, Integer[].class);
            } else {
                uv = (UV)this.gson.fromJson(json, UV.class);
            }
            return uv;
        }
    }
}

