/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.utils.nbt;

import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelParts;
import com.razz.decocraft.utils.nbt.NBTAnimation;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class NBTModel {
    private static final String NBT_ANIMATIONS_PER_NAME_SIZE = "animationsPerName.size";
    private static final String NBT_ANIMATIONS_PER_NAME_KEYS = "animationsPerName.keys[%d]";
    private static final String NBT_ANIMATIONS_PER_NAME_VALUES = "animationsPerName.values[%d]";
    private static final String NBT_NAME = "name";

    public static CompoundNBT toNBT(BBModel model) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a(NBT_NAME, model.name);
        int size = model.animationPerName.size();
        nbt.func_74768_a(NBT_ANIMATIONS_PER_NAME_SIZE, size);
        int i = 0;
        for (Map.Entry<String, BBModelParts.Animation> entry : model.animationPerName.entrySet()) {
            nbt.func_74778_a(String.format(NBT_ANIMATIONS_PER_NAME_KEYS, i), entry.getKey());
            nbt.func_218657_a(String.format(NBT_ANIMATIONS_PER_NAME_VALUES, i), (INBT)NBTAnimation.toNBT(entry.getValue()));
            ++i;
        }
        return nbt;
    }

    public static BBModel fromNBT(CompoundNBT nbt) {
        BBModel model = new BBModel();
        model.name = nbt.func_74779_i(NBT_NAME);
        int size = nbt.func_74762_e(NBT_ANIMATIONS_PER_NAME_SIZE);
        model.animationPerName = new HashMap<String, BBModelParts.Animation>();
        for (int i = 0; i < size; ++i) {
            model.animationPerName.put(nbt.func_74779_i(String.format(NBT_ANIMATIONS_PER_NAME_KEYS, i)), NBTAnimation.fromNBT(nbt.func_74775_l(String.format(NBT_ANIMATIONS_PER_NAME_VALUES, i))));
        }
        return model;
    }
}

