/*
 * Decompiled with CFR 0.152.
 */
package com.razz.essentialpartnermod;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ResourceLocation;

public class Draw {
    public final int mouseX;
    public final int mouseY;
    public final MatrixStack matrixStack;
    private static final List<Consumer<Draw>> deferred = new ArrayList<Consumer<Draw>>();

    public Draw(int mouseX, int mouseY, MatrixStack matrixStack) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.matrixStack = matrixStack;
    }

    public void rect(int left, int top, int right, int bottom, int color) {
        AbstractGui.func_238467_a_((MatrixStack)this.matrixStack, (int)left, (int)top, (int)right, (int)bottom, (int)color);
    }

    public void texturedRect(ResourceLocation texture, int x, int y, int width, int height, int u, int v, int textureWidth, int textureHeight) {
        this.texturedRect(texture, x, y, width, height, u, v, textureWidth, textureHeight, -1);
    }

    public void texturedRect(ResourceLocation texture, int x, int y, int width, int height, int u, int v, int textureWidth, int textureHeight, int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        AbstractGui.func_238463_a_((MatrixStack)this.matrixStack, (int)x, (int)y, (float)u, (float)v, (int)width, (int)height, (int)textureWidth, (int)textureHeight);
    }

    public void string(String text, int x, int y, int color) {
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(this.matrixStack, text, (float)x, (float)y, color);
    }

    public void string(String text, int x, int y, int color, int shadowColor) {
        this.string(text, x + 1, y + 1, shadowColor);
        this.string(text, x, y, color);
    }

    public void centredString(String text, int centreX, int y, int color, int shadowColor) {
        int width = Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
        this.string(text, centreX - width / 2, y, color, shadowColor);
    }

    public void multilineCentredString(String text, int centreX, int y, int lineSpacing, int color, int shadowColor) {
        for (String line : text.split("\n")) {
            this.centredString(line, centreX, y, color, shadowColor);
            y += lineSpacing;
        }
    }

    public static boolean hovered(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public boolean hovered(int x, int y, int width, int height) {
        return Draw.hovered(this.mouseX, this.mouseY, x, y, width, height);
    }

    public static void deferred(Consumer<Draw> drawer) {
        deferred.add(drawer);
    }

    public static void flushDeferred(Draw draw) {
        for (Consumer<Draw> drawConsumer : deferred) {
            drawConsumer.accept(draw);
        }
        deferred.clear();
    }
}

