/*
 * Decompiled with CFR 0.152.
 */
package com.razz.essentialpartnermod.modal;

import com.razz.essentialpartnermod.Draw;
import com.razz.essentialpartnermod.EssentialPartner;
import com.razz.essentialpartnermod.EssentialUtil;
import com.razz.essentialpartnermod.UDesktop;
import com.razz.essentialpartnermod.UResolution;
import com.razz.essentialpartnermod.modal.AdModal;
import com.razz.essentialpartnermod.modal.ButtonColor;
import com.razz.essentialpartnermod.modal.Modal;
import com.razz.essentialpartnermod.modal.ModalButton;
import com.razz.essentialpartnermod.modal.ModalManager;
import net.minecraft.client.Minecraft;

public class TwoButtonModal
extends Modal {
    private final String text;
    private final ButtonProducer leftButtonProducer;
    private final ButtonProducer rightButtonProducer;

    public TwoButtonModal(String text, ButtonProducer leftButtonProducer, ButtonProducer rightButtonProducer) {
        this.text = text;
        this.leftButtonProducer = leftButtonProducer;
        this.rightButtonProducer = rightButtonProducer;
    }

    @Override
    public void init() {
        super.init();
        int textLines = this.text.split("\n").length;
        int textHeight = 10 * textLines + 2 * (textLines - 1);
        this.setDimensions(224, 70 + textHeight);
        int buttonY = this.startY + 20 + textHeight + 17;
        this.buttonList.add(this.leftButtonProducer.make(this.centreX - 95, buttonY, 91));
        this.buttonList.add(this.rightButtonProducer.make(this.centreX + 4, buttonY, 91));
    }

    @Override
    public void draw(Draw draw) {
        super.draw(draw);
        draw.multilineCentredString(this.text, this.centreX, this.startY + 20, 12, -1710619, -16777216);
    }

    public static TwoButtonModal postInstall() {
        return new TwoButtonModal("Essential Mod will install the next time\nyou launch the game.", (x, y, width) -> {
            ModalButton button = new ModalButton(x, y, width, ButtonColor.GRAY, "Quit & Install", () -> {
                ModalManager.INSTANCE.setModal(null);
                EssentialUtil.shutdown();
            });
            button.setTooltip("This will close your game!");
            return button;
        }, (x, y, width) -> new ModalButton(x, y, width, ButtonColor.BLUE, "Okay", () -> ModalManager.INSTANCE.setModal(null)));
    }

    public static TwoButtonModal removeAds(final AdModal adModal) {
        final boolean[] removed = new boolean[1];
        return new TwoButtonModal("Do you want to remove all\n'Get Essential Mod' buttons?", (x, y, width) -> new ModalButton(x, y, width, ButtonColor.GRAY, "Back", () -> ModalManager.INSTANCE.setModal(null)), (x, y, width) -> new ModalButton(x, y, width, ButtonColor.RED, "Remove", () -> {
            EssentialPartner.CONFIG.hideButtons();
            removed[0] = true;
            ModalManager.INSTANCE.setModal(null);
            Minecraft.func_71410_x().field_71462_r.func_231152_a_(Minecraft.func_71410_x(), UResolution.getScaledWidth(), UResolution.getScaledHeight());
        })){

            @Override
            public void close() {
                super.close();
                if (!removed[0]) {
                    ModalManager.INSTANCE.setModal(adModal);
                }
            }
        };
    }

    public static TwoButtonModal installFailed() {
        return new TwoButtonModal("An issue occurred while installing\nEssential Mod. Download it from\nour website instead.", (x, y, width) -> new ModalButton(x, y, width, ButtonColor.GRAY, "Okay", () -> ModalManager.INSTANCE.setModal(null)), (x, y, width) -> new ModalButton(x, y, width, ButtonColor.BLUE, "Download", () -> {
            UDesktop.browse("https://essential.gg/download");
            ModalManager.INSTANCE.setModal(null);
        }));
    }

    public static interface ButtonProducer {
        public ModalButton make(int var1, int var2, int var3);
    }
}

