/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.screenhandlers;

import com.razz.decocraft.common.ModuleBlocks;
import com.razz.decocraft.common.ModuleItems;
import com.razz.decocraft.common.ModuleScreenHandlers;
import com.razz.decocraft.common.tileentities.DecobenchTileEntity;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2586;
import net.minecraft.class_3914;
import net.minecraft.class_3915;

public class DecobenchScreenHandler
extends class_1703 {
    public static final int ROWS = 4;
    public static final int COLUMNS = 7;
    public static final int CONTAINER_SLOT_ID = 11;
    private static final class_1277 CONTAINER = new class_1277(28);
    private static final int FIRST_ROW = 37;
    private static final int FIRST_COLUMNS = 54;
    private static final int SPACING = 18;
    private static final int INVENTORY_X = 22;
    private static final int INVENTORY_Y = 147;
    public final class_2371<class_1799> items = class_2371.method_10211();
    private final class_3914 context;
    public int[] colors = new int[3];
    public int[] rawMaterial = new int[1];
    public int[] crafting = new int[2];
    private DecobenchTileEntity decobenchTE;
    private class_1937 world;

    public DecobenchScreenHandler(int syncId, class_1661 inventory) {
        this(syncId, inventory, class_3914.field_17304);
    }

    public DecobenchScreenHandler(int syncId, class_1661 inventory, class_3914 context) {
        super(ModuleScreenHandlers.DECOBENCH, syncId);
        this.context = context;
        this.context.method_17393((world, pos) -> {
            class_2586 blockEntity = world.method_8321(pos);
            System.out.println("ScreenHandler: Block entity at " + String.valueOf(pos) + " is type: " + (blockEntity != null ? blockEntity.getClass().getSimpleName() : "null"));
            if (blockEntity instanceof DecobenchTileEntity) {
                this.decobenchTE = (DecobenchTileEntity)blockEntity;
                System.out.println("ScreenHandler: Successfully linked to DecobenchTileEntity");
            } else {
                this.decobenchTE = null;
                System.out.println("ScreenHandler: ERROR - Block entity is not DecobenchTileEntity!");
            }
            this.world = world;
        });
        for (int i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)inventory, i, 22 + i * 18, 147));
        }
        class_1277 inputInventory = this.decobenchTE != null ? this.decobenchTE.getInput() : new class_1277(1);
        System.out.println("SCREENHANDLER: Creating input slot with inventory: " + inputInventory.getClass().getSimpleName() + " (TE is " + (this.decobenchTE != null ? "NOT NULL" : "NULL") + ")");
        this.method_7621(new class_1735((class_1263)inputInventory, 0, 14, 16){

            public boolean method_7680(class_1799 stack) {
                boolean canInsert = stack.method_7909() instanceof class_1769 || stack.method_7909() == ModuleItems.RAW_MATERIAL;
                System.out.println("INPUT SLOT: canInsert(" + stack.method_7909().getClass().getSimpleName() + ") = " + canInsert);
                return canInsert;
            }

            public void method_48931(class_1799 stack) {
                System.out.println("INPUT SLOT: setStack(" + stack.method_7909().getClass().getSimpleName() + " x" + stack.method_7947() + ")");
                super.method_48931(stack);
            }
        });
        class_1277 resultInventory = this.decobenchTE != null ? this.decobenchTE.getResult() : new class_1277(1);
        this.method_7621(new class_1735((class_1263)resultInventory, 0, 175, 116){

            public boolean method_7680(class_1799 stack) {
                return false;
            }
        });
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.method_7621(new class_1735((class_1263)CONTAINER, i * 7 + j, 54 + j * 18, 37 + i * 18){

                    public boolean method_7674(class_1657 player) {
                        return false;
                    }
                });
            }
        }
        this.getTabItems("all");
        this.method_17362(new class_3915(){

            public int method_17407() {
                return DecobenchScreenHandler.this.decobenchTE != null ? DecobenchScreenHandler.this.decobenchTE.getColorRed() : 0;
            }

            public void method_17404(int value) {
                DecobenchScreenHandler.this.colors[0] = value;
            }
        });
        this.method_17362(new class_3915(){

            public int method_17407() {
                return DecobenchScreenHandler.this.decobenchTE != null ? DecobenchScreenHandler.this.decobenchTE.getColorGreen() : 0;
            }

            public void method_17404(int value) {
                DecobenchScreenHandler.this.colors[1] = value;
            }
        });
        this.method_17362(new class_3915(){

            public int method_17407() {
                return DecobenchScreenHandler.this.decobenchTE != null ? DecobenchScreenHandler.this.decobenchTE.getColorBlue() : 0;
            }

            public void method_17404(int value) {
                DecobenchScreenHandler.this.colors[2] = value;
            }
        });
        this.method_17362(new class_3915(){

            public int method_17407() {
                return DecobenchScreenHandler.this.decobenchTE != null ? DecobenchScreenHandler.this.decobenchTE.getRawMaterial() : 0;
            }

            public void method_17404(int value) {
                DecobenchScreenHandler.this.rawMaterial[0] = value;
            }
        });
        this.method_17362(new class_3915(){

            public int method_17407() {
                return DecobenchScreenHandler.this.decobenchTE != null ? DecobenchScreenHandler.this.decobenchTE.getCraft() : 0;
            }

            public void method_17404(int value) {
                DecobenchScreenHandler.this.crafting[0] = value;
            }
        });
        this.method_17362(new class_3915(){

            public int method_17407() {
                return DecobenchScreenHandler.this.decobenchTE != null ? DecobenchScreenHandler.this.decobenchTE.getCraftingTimer() : 0;
            }

            public void method_17404(int value) {
                DecobenchScreenHandler.this.crafting[1] = value;
            }
        });
        this.getTEData();
    }

    public int getColorRed() {
        this.syncDataFromTE();
        return this.colors[0];
    }

    public int getColorGreen() {
        this.syncDataFromTE();
        return this.colors[1];
    }

    public int getColorBlue() {
        this.syncDataFromTE();
        return this.colors[2];
    }

    public int getRawMaterial() {
        this.syncDataFromTE();
        return this.rawMaterial[0];
    }

    public int getCrafting() {
        this.syncDataFromTE();
        return this.crafting[0];
    }

    public int getCraftingTimer() {
        this.syncDataFromTE();
        return this.crafting[1];
    }

    private void syncDataFromTE() {
        if (this.decobenchTE != null) {
            this.colors[0] = this.decobenchTE.getColorRed();
            this.colors[1] = this.decobenchTE.getColorGreen();
            this.colors[2] = this.decobenchTE.getColorBlue();
            this.rawMaterial[0] = this.decobenchTE.getRawMaterial();
            this.crafting[0] = this.decobenchTE.getCraft();
            this.crafting[1] = this.decobenchTE.getCraftingTimer();
            if (this.world != null && this.world.method_8608()) {
                System.out.println("CLIENT TE DATA: R=" + this.colors[0] + " G=" + this.colors[1] + " B=" + this.colors[2]);
            }
        } else if (this.world != null && this.world.method_8608()) {
            System.out.println("CLIENT: decobenchTE is NULL!");
        }
    }

    public void scrollTo(float pos) {
        int rowMax = (this.items.size() + 7 - 1) / 7 - 4;
        int posScrolled = (int)((double)(pos * (float)rowMax) + 0.5);
        if (posScrolled < 0) {
            posScrolled = 0;
        }
        for (int row = 0; row < 4; ++row) {
            for (int column = 0; column < 7; ++column) {
                int item = column + (row + posScrolled) * 7;
                if (item >= 0 && item < this.items.size()) {
                    CONTAINER.method_5447(column + row * 7, (class_1799)this.items.get(item));
                    continue;
                }
                CONTAINER.method_5447(column + row * 7, class_1799.field_8037);
            }
        }
        this.method_7623();
    }

    public boolean method_7597(class_1657 player) {
        return (Boolean)this.context.method_17396((world, pos) -> player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) <= 64.0, (Object)true);
    }

    public void getTabItems(String tabText) {
        this.items.clear();
        if (!ModuleBlocks.BLOCKS_PER_GROUP.containsKey(tabText)) {
            tabText = "all";
        }
        if ("all".equals(tabText)) {
            for (List<class_2248> tab : ModuleBlocks.BLOCKS_PER_GROUP.values()) {
                this.fillItemList(tab, this.items);
            }
        } else {
            this.fillItemList(ModuleBlocks.BLOCKS_PER_GROUP.get(tabText), this.items);
        }
        this.scrollTo(0.0f);
    }

    private void fillItemList(List<class_2248> tab, class_2371<class_1799> pItems) {
        if (tab != null) {
            tab.forEach(block -> pItems.add((Object)new class_1799((class_1935)block)));
        }
    }

    public void search(String searchText) {
        this.items.clear();
        String search = searchText.toLowerCase();
        for (List<class_2248> tab : ModuleBlocks.BLOCKS_PER_GROUP.values()) {
            this.fillItemList(tab, this.items);
        }
        this.items.removeIf(stack -> !stack.method_7922().toLowerCase().contains(search));
        this.scrollTo(0.0f);
    }

    public void craft(int craft) {
        System.out.println("SERVER: craft() called with value: " + craft);
        if (this.decobenchTE != null) {
            this.decobenchTE.setCraft(craft);
            this.decobenchTE.method_5431();
            System.out.println("SERVER: Set craft state to: " + craft + " on tile entity");
        } else {
            System.out.println("SERVER: ERROR - decobenchTE is null! Trying to get from context...");
            this.context.method_17393((world, pos) -> {
                class_2586 blockEntity = world.method_8321(pos);
                if (blockEntity instanceof DecobenchTileEntity) {
                    this.decobenchTE = (DecobenchTileEntity)blockEntity;
                    this.decobenchTE.setCraft(craft);
                    this.decobenchTE.method_5431();
                    System.out.println("SERVER: Successfully retrieved and set craft state to: " + craft);
                }
            });
        }
    }

    public void scroll(float scrollOffset) {
        this.scrollTo(scrollOffset);
    }

    public void selectTab(String tabName, float scrollOffset) {
        this.getTabItems(tabName);
        this.scrollTo(scrollOffset);
    }

    public boolean canScroll() {
        return this.items.size() > 28;
    }

    public class_3914 getContext() {
        return this.context;
    }

    public int getItemsSize() {
        return this.items.size();
    }

    private void getTEData() {
        if (this.world != null && !this.world.method_8608() && this.decobenchTE != null) {
            this.colors[0] = this.decobenchTE.getColorRed();
            this.colors[1] = this.decobenchTE.getColorGreen();
            this.colors[2] = this.decobenchTE.getColorBlue();
            this.rawMaterial[0] = this.decobenchTE.getRawMaterial();
            this.crafting[0] = this.decobenchTE.getCraft();
            this.crafting[1] = this.decobenchTE.getCraftingTimer();
        }
    }

    public void method_7623() {
        super.method_7623();
        this.getTEData();
        if (this.world == null || this.world.method_8608() || this.decobenchTE != null) {
            // empty if block
        }
    }

    public class_1799 method_7601(class_1657 player, int index) {
        return class_1799.field_8037;
    }
}

