/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.client.screens;

import com.razz.decocraft.common.containers.DecoStorageScreenHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class DecoStorageScreen
extends AbstractContainerScreen<DecoStorageScreenHandler> {
    private static final ResourceLocation CHEST_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/generic_54.png");
    private final int rows;
    private final int cols;

    public DecoStorageScreen(DecoStorageScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.rows = handler.getRows();
        this.cols = handler.getCols();
        int storageWidth = 7 + this.cols * 18 + 7;
        this.imageWidth = Math.max(176, storageWidth);
        int storageContainerHeight = 17 + this.rows * 18 + 1;
        int storageAreaHeight = 8 + storageContainerHeight;
        int gap = 7;
        int playerInvHeight = 96;
        this.imageHeight = storageAreaHeight + gap + playerInvHeight;
        this.titleLabelY = 14;
        this.inventoryLabelX = 8;
        int playerInvStartY = storageAreaHeight + gap;
        this.inventoryLabelY = playerInvStartY + 5;
    }

    protected void renderBg(GuiGraphics guiGraphics, float delta, int mouseX, int mouseY) {
        int guiX = (this.width - this.imageWidth) / 2;
        int guiY = (this.height - this.imageHeight) / 2;
        int storageWidth = 7 + this.cols * 18 + 7;
        int storageX = guiX + (this.imageWidth - storageWidth) / 2;
        int storageY = guiY + 8;
        this.drawDynamicContainer(guiGraphics, storageX, storageY, this.cols, this.rows);
        int storageContainerHeight = 17 + this.rows * 18 + 1;
        int actualStorageHeight = 8 + storageContainerHeight;
        int playerInvY = guiY + actualStorageHeight + 7 + 2;
        this.drawPlayerInventoryBackground(guiGraphics, guiX, playerInvY);
    }

    private void drawDynamicContainer(GuiGraphics guiGraphics, int x, int y, int cols, int rows) {
        int i;
        int containerWidth = 7 + cols * 18 + 7;
        int containerHeight = 17 + rows * 18 + 1;
        guiGraphics.blit(CHEST_TEXTURE, x, y, 0, 0, 7, 17);
        guiGraphics.blit(CHEST_TEXTURE, x + containerWidth - 7, y, 169, 0, 7, 17);
        guiGraphics.blit(CHEST_TEXTURE, x, y + containerHeight - 1, 0, 215, 7, 1);
        guiGraphics.blit(CHEST_TEXTURE, x + containerWidth - 7, y + containerHeight - 1, 169, 215, 7, 1);
        for (i = 0; i < cols; ++i) {
            guiGraphics.blit(CHEST_TEXTURE, x + 7 + i * 18, y, 7, 0, 18, 17);
        }
        for (int row = 0; row < rows; ++row) {
            int slotY = y + 17 + row * 18;
            guiGraphics.blit(CHEST_TEXTURE, x, slotY, 0, 17, 7, 18);
            for (int col = 0; col < cols; ++col) {
                guiGraphics.blit(CHEST_TEXTURE, x + 7 + col * 18, slotY, 7, 17, 18, 18);
            }
            guiGraphics.blit(CHEST_TEXTURE, x + containerWidth - 7, slotY, 169, 17, 7, 18);
        }
        for (i = 0; i < cols; ++i) {
            guiGraphics.blit(CHEST_TEXTURE, x + 7 + i * 18, y + containerHeight - 1, 7, 215, 18, 1);
        }
    }

    private void drawPlayerInventoryBackground(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.blit(CHEST_TEXTURE, x, y, 0, 126, 176, 96);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int titleWidth = this.font.width((FormattedText)this.title);
        int centeredX = (this.imageWidth - titleWidth) / 2;
        guiGraphics.drawString(this.font, this.title, centeredX, this.titleLabelY, 0x404040, false);
        MutableComponent inventoryTitle = Component.translatable((String)"container.inventory");
        guiGraphics.drawString(this.font, (Component)inventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }
}

