/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.blocks;

import com.mojang.datafixers.util.Either;
import com.razz.decocraft.Decocraft;
import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.ModuleTileEntities;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import com.razz.decocraft.common.properties.DecoProperty;
import com.razz.decocraft.common.tileentities.DecocraftTileEntity;
import com.razz.decocraft.models.bbmodel.BBModel;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DecoBedBlock
extends DecocraftBlock {
    public DecoBedBlock(JsonContainer.Entry meta, BBModel model) {
        super(meta, model);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.OCCUPIED, (Comparable)Boolean.valueOf(false))).setValue((Property)DecoProperty.BED, (Comparable)Integer.valueOf(0)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.OCCUPIED});
        builder.add(new Property[]{DecoProperty.BED});
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState baseState = super.getStateForPlacement(context);
        if (baseState != null) {
            return (BlockState)baseState.setValue((Property)DecoProperty.BED, (Comparable)Integer.valueOf(0));
        }
        return null;
    }

    @Override
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        super.neighborChanged(state, level, pos, sourceBlock, sourcePos, notify);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        Either result;
        if (level.isClientSide) {
            return InteractionResult.CONSUME;
        }
        if (this.meta.script != null && this.meta.script.on_use != null) {
            DecocraftBlock.script(level, pos, state, this.meta.script.on_use);
        }
        if (!level.dimensionType().bedWorks()) {
            level.removeBlock(pos, false);
            level.explode(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 5.0f, true, Level.ExplosionInteraction.BLOCK);
            return InteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (level.isDay()) {
                Decocraft.setDecoBedSpawnPoint(serverPlayer.getUUID(), pos);
                player.sendSystemMessage((Component)Component.translatable((String)"message.decocraft.bed.spawn_set"));
                return InteractionResult.SUCCESS;
            }
        }
        if ((result = player.startSleepInBed(pos)).left().isPresent()) {
            Player.BedSleepingProblem reason = (Player.BedSleepingProblem)result.left().get();
            switch (reason) {
                case NOT_POSSIBLE_NOW: 
                case NOT_SAFE: {
                    player.displayClientMessage((Component)Component.translatable((String)"block.minecraft.bed.no_sleep"), true);
                    break;
                }
                case TOO_FAR_AWAY: 
                case OBSTRUCTED: {
                    player.displayClientMessage((Component)Component.translatable((String)"block.minecraft.bed.obstructed"), true);
                    break;
                }
                default: {
                    player.displayClientMessage((Component)Component.translatable((String)"block.minecraft.bed.occupied"), true);
                    break;
                }
            }
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Decocraft.setDecoBedSpawnPoint(serverPlayer.getUUID(), pos);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (this.meta.script != null && (this.meta.script.trigger != null || this.meta.script.on_use != null)) {
            return new DecocraftTileEntity((BlockEntityType)ModuleTileEntities.DECOCRAFT.get(), pos, state);
        }
        return null;
    }

    @Override
    public void onToolModelSwitch(BlockState state, Level level, BlockPos pos) {
        if (this.meta != null && this.meta.script != null && this.meta.script.tool_modelswitch != null) {
            DecocraftBlock.script(level, pos, state, this.meta.script.tool_modelswitch);
        }
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5625, (double)1.0);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5625, (double)1.0);
    }

    @Override
    public boolean useShapeForLightOcclusion(BlockState state) {
        return false;
    }

    @Override
    public float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    @Override
    public VoxelShape getOcclusionShape(BlockState state, BlockGetter world, BlockPos pos) {
        return Shapes.empty();
    }

    public boolean isBed(BlockState state, BlockGetter world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public boolean canSetSpawn(BlockState state, LevelReader world, BlockPos pos) {
        return true;
    }

    public Direction getBedDirection(BlockState state, LevelReader world, BlockPos pos) {
        return ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite();
    }

    public Optional<ServerPlayer.RespawnPosAngle> getRespawnPosition(BlockState state, EntityType<?> type, LevelReader levelReader, BlockPos pos, float yRot) {
        if (levelReader instanceof Level) {
            Level level = (Level)levelReader;
            Direction facing = this.getBedDirection(state, (LevelReader)level, pos);
            BlockPos.MutableBlockPos mutablePos = pos.mutable();
            for (int i = 0; i < 4; ++i) {
                Direction checkDir = Direction.from2DDataValue((int)((facing.get2DDataValue() + i) % 4));
                mutablePos.set((Vec3i)pos).move(checkDir);
                if (!level.getBlockState((BlockPos)mutablePos).isAir() || !level.getBlockState(mutablePos.above()).isAir()) continue;
                Vec3 result = new Vec3((double)mutablePos.getX() + 0.5, (double)mutablePos.getY(), (double)mutablePos.getZ() + 0.5);
                return Optional.of(ServerPlayer.RespawnPosAngle.of((Vec3)result, (BlockPos)pos));
            }
            Vec3 fallback = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.6, (double)pos.getZ() + 0.5);
            return Optional.of(ServerPlayer.RespawnPosAngle.of((Vec3)fallback, (BlockPos)pos));
        }
        return Optional.empty();
    }
}

