/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.tileentities;

import com.razz.decocraft.common.ModuleTileEntities;
import com.razz.decocraft.common.blocks.DecoStorageBlock;
import com.razz.decocraft.common.containers.DecoStorageScreenHandler;
import com.razz.decocraft.common.tileentities.ImplementedInventory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DecoStorageTileEntity
extends BlockEntity
implements MenuProvider,
ImplementedInventory {
    private NonNullList<ItemStack> inventory;
    private int width;
    private int height;
    private long placementTime;

    public DecoStorageTileEntity(BlockPos pos, BlockState state, int width, int height) {
        this((BlockEntityType)ModuleTileEntities.DECO_STORAGE.get(), pos, state, width, height);
    }

    public DecoStorageTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int width, int height) {
        super(type, pos, state);
        this.width = width;
        this.height = height;
        this.inventory = NonNullList.withSize((int)(width * height), (Object)ItemStack.EMPTY);
        this.placementTime = -1L;
    }

    public DecoStorageTileEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModuleTileEntities.DECO_STORAGE.get(), pos, state, 3, 6);
    }

    public DecoStorageTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, 3, 6);
    }

    public void onLoad() {
        super.onLoad();
        if (this.placementTime == -1L && this.level != null) {
            this.placementTime = this.level.getGameTime();
        }
    }

    public long getPlacementTime() {
        return this.placementTime;
    }

    public BlockEntityType<?> getType() {
        BlockEntityType currentType = super.getType();
        return currentType != null ? currentType : (BlockEntityType)ModuleTileEntities.DECO_STORAGE.get();
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        if (this.inventory == null) {
            this.inventory = NonNullList.withSize((int)(this.width * this.height), (Object)ItemStack.EMPTY);
        }
        return this.inventory;
    }

    public Component getDisplayName() {
        return Component.literal((String)"Storage");
    }

    public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
        return new DecoStorageScreenHandler(syncId, inv, this, this.width, this.height);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        if (nbt.contains("Width")) {
            this.width = nbt.getInt("Width");
        }
        if (nbt.contains("Height")) {
            this.height = nbt.getInt("Height");
        }
        if (!(nbt.contains("Width") && nbt.contains("Height") || !(this.getBlockState().getBlock() instanceof DecoStorageBlock))) {
            DecoStorageBlock block = (DecoStorageBlock)this.getBlockState().getBlock();
            if (block.meta != null && block.meta.script != null && block.meta.script.on_use != null && block.meta.script.on_use.storage != null && block.meta.script.on_use.storage.length == 2) {
                this.width = block.meta.script.on_use.storage[0];
                this.height = block.meta.script.on_use.storage[1];
            }
        }
        this.inventory = NonNullList.withSize((int)(this.width * this.height), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)registryLookup);
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putInt("Width", this.width);
        nbt.putInt("Height", this.height);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)registryLookup);
    }

    @Override
    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            this.level.getChunkAt(this.getBlockPos()).setUnsaved(true);
        }
    }

    private int countNonEmptyItems() {
        if (this.inventory == null) {
            return 0;
        }
        int count = 0;
        for (ItemStack stack : this.inventory) {
            if (stack.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        CompoundTag nbt = super.getUpdateTag(registryLookup);
        this.saveAdditional(nbt, registryLookup);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        this.loadAdditional(nbt, registryLookup);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

