/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.tileentities;

import com.razz.decocraft.common.ModuleItems;
import com.razz.decocraft.common.ModuleTileEntities;
import com.razz.decocraft.common.items.DecoBlockItem;
import com.razz.mods.Mods;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DecomposerTileEntity
extends BlockEntity {
    public static final float CRAFTING_TIME = 40.0f;
    public static final float FUEL_MAX = 16000.0f;
    private final SimpleContainer input = new SimpleContainer(1){

        public void setChanged() {
            super.setChanged();
            DecomposerTileEntity.this.setChanged();
        }
    };
    private final SimpleContainer result = new SimpleContainer(1){

        public void setChanged() {
            super.setChanged();
            DecomposerTileEntity.this.setChanged();
        }
    };
    private final SimpleContainer fuel = new SimpleContainer(1){

        public void setChanged() {
            super.setChanged();
            DecomposerTileEntity.this.setChanged();
        }
    };
    private int currentFuel = 0;
    private long fuelTimer = 0L;
    private int craft = 0;
    private int craftingTimer = 0;
    private boolean isLoading = false;

    public DecomposerTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public DecomposerTileEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModuleTileEntities.DECOMPOSER.get(), pos, state);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, DecomposerTileEntity be) {
        ++be.fuelTimer;
        if (!be.fuel.isEmpty() && be.fuelTimer > 10L) {
            ItemStack fuelStack = be.fuel.getItem(0);
            int burnTime = 0;
            if (fuelStack.getItem() == Items.COBBLESTONE) {
                burnTime = 1600;
            } else if (fuelStack.is(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"minecraft:logs"))) || fuelStack.is(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"minecraft:planks")))) {
                burnTime = 300;
            } else if (fuelStack.getItem() == Items.WHEAT_SEEDS || fuelStack.getItem() == Items.BEETROOT_SEEDS || fuelStack.getItem() == Items.MELON_SEEDS || fuelStack.getItem() == Items.PUMPKIN_SEEDS || fuelStack.getItem() == Items.POTATO || fuelStack.getItem() == Items.CARROT || fuelStack.getItem() == Items.COCOA_BEANS || fuelStack.getItem() == Items.KELP || fuelStack.getItem() == Items.SWEET_BERRIES || fuelStack.getItem() == Items.GLOW_BERRIES) {
                burnTime = 100;
            }
            if (burnTime > 0 && ((float)(be.currentFuel + burnTime) <= 16000.0f || be.currentFuel == 0)) {
                ItemStack container = fuelStack.getCraftingRemainingItem();
                if (!container.isEmpty()) {
                    be.fuel.setItem(0, container);
                } else {
                    be.fuel.removeItem(0, 1);
                }
                be.fuelTimer = 0L;
                be.currentFuel += burnTime;
            }
        }
        if (be.craft == 1 && DecomposerTileEntity.canAddItem(be.result, new ItemStack((ItemLike)ModuleItems.RAW_MATERIAL.get())) && be.input.getItem(0) != ItemStack.EMPTY) {
            ItemStack inputStack;
            boolean found = be.input.getItem(0).getItem() instanceof DecoBlockItem;
            if (!found) {
                for (Map.Entry<String, Integer> entry : Mods.DECOMPOSER_INGREDIENTS.entrySet()) {
                    inputStack = be.input.getItem(0);
                    if (entry.getKey().startsWith("#")) {
                        TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)entry.getKey().substring(1)));
                        if (!inputStack.is(tag) || inputStack.getCount() < entry.getValue()) continue;
                        found = true;
                        break;
                    }
                    Item targetItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)entry.getKey()));
                    if (inputStack.getItem() != targetItem || inputStack.getCount() < entry.getValue()) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                return;
            }
            if (be.input.getItem(0).getItem() instanceof DecoBlockItem && ((DecoBlockItem)be.input.getItem(0).getItem()).getMaterial() + be.result.getItem(0).getCount() > new ItemStack((ItemLike)ModuleItems.RAW_MATERIAL.get()).getMaxStackSize()) {
                return;
            }
            if (be.currentFuel > 0) {
                ++be.craftingTimer;
                if ((float)be.craftingTimer >= 40.0f) {
                    be.craftingTimer = 0;
                    if (be.input.getItem(0).getItem() instanceof DecoBlockItem) {
                        ItemStack stack = new ItemStack((ItemLike)ModuleItems.RAW_MATERIAL.get());
                        stack.setCount(((DecoBlockItem)be.input.getItem(0).getItem()).getMaterial());
                        be.input.removeItem(0, 1);
                        System.out.println("DecomposerTileEntity: Decomposing complete! Adding to result: " + String.valueOf(stack));
                        DecomposerTileEntity.addItem(be.result, stack);
                        System.out.println("DecomposerTileEntity: Result slot now contains: " + String.valueOf(be.result.getItem(0)));
                    } else {
                        for (Map.Entry<String, Integer> entry : Mods.DECOMPOSER_INGREDIENTS.entrySet()) {
                            inputStack = be.input.getItem(0);
                            boolean matches = false;
                            if (entry.getKey().startsWith("#")) {
                                TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)entry.getKey().substring(1)));
                                matches = inputStack.is(tag);
                            } else {
                                Item targetItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)entry.getKey()));
                                boolean bl = matches = inputStack.getItem() == targetItem;
                            }
                            if (!matches) continue;
                            be.input.removeItem(0, entry.getValue().intValue());
                            System.out.println("DecomposerTileEntity: Decomposing complete! Adding to result: " + String.valueOf(new ItemStack((ItemLike)ModuleItems.RAW_MATERIAL.get())));
                            DecomposerTileEntity.addItem(be.result, new ItemStack((ItemLike)ModuleItems.RAW_MATERIAL.get()));
                            System.out.println("DecomposerTileEntity: Result slot now contains: " + String.valueOf(be.result.getItem(0)));
                            break;
                        }
                    }
                }
                be.currentFuel -= 10;
                be.currentFuel = Mth.clamp((int)be.currentFuel, (int)0, (int)Integer.MAX_VALUE);
                be.setChanged();
            }
        } else {
            be.craftingTimer = 0;
            be.craft = 0;
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.isLoading = true;
        this.craft = nbt.getInt("craft");
        this.craftingTimer = nbt.getInt("crafting_timer");
        this.currentFuel = nbt.getInt("current_fuel");
        ItemStack resultStack = ItemStack.parseOptional((HolderLookup.Provider)registryLookup, (CompoundTag)nbt.getCompound("result"));
        ItemStack inputStack = ItemStack.parseOptional((HolderLookup.Provider)registryLookup, (CompoundTag)nbt.getCompound("input"));
        ItemStack fuelStack = ItemStack.parseOptional((HolderLookup.Provider)registryLookup, (CompoundTag)nbt.getCompound("fuel"));
        this.result.setItem(0, resultStack);
        this.input.setItem(0, inputStack);
        this.fuel.setItem(0, fuelStack);
        this.isLoading = false;
        System.out.println("DecomposerTileEntity.loadAdditional: result=" + String.valueOf(resultStack) + ", input=" + String.valueOf(inputStack) + ", fuel=" + String.valueOf(fuelStack) + ", currentFuel=" + this.currentFuel);
    }

    public void setChanged() {
        super.setChanged();
        if (!this.isLoading && this.level != null && !this.level.isClientSide) {
            this.level.blockEntityChanged(this.worldPosition);
            this.level.getChunkAt(this.worldPosition).setUnsaved(true);
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        this.saveNBTCustom(nbt, registryLookup);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        CompoundTag nbt = super.getUpdateTag(registryLookup);
        this.saveNBTCustom(nbt, registryLookup);
        return nbt;
    }

    private void saveNBTCustom(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        nbt.putInt("craft", this.craft);
        nbt.putInt("crafting_timer", this.craftingTimer);
        nbt.putInt("current_fuel", this.currentFuel);
        if (!this.result.getItem(0).isEmpty()) {
            nbt.put("result", this.result.getItem(0).save(registryLookup));
        }
        if (!this.input.getItem(0).isEmpty()) {
            nbt.put("input", this.input.getItem(0).save(registryLookup));
        }
        if (!this.fuel.getItem(0).isEmpty()) {
            nbt.put("fuel", this.fuel.getItem(0).save(registryLookup));
        }
        System.out.println("DecomposerTileEntity.saveNBTCustom: result=" + String.valueOf(this.result.getItem(0)) + ", input=" + String.valueOf(this.input.getItem(0)) + ", fuel=" + String.valueOf(this.fuel.getItem(0)) + ", currentFuel=" + this.currentFuel);
    }

    public SimpleContainer getInput() {
        return this.input;
    }

    public SimpleContainer getResult() {
        return this.result;
    }

    public SimpleContainer getFuel() {
        return this.fuel;
    }

    public int getCraft() {
        return this.craft;
    }

    public void setCraft(int craft) {
        this.craft = craft;
    }

    public int getCraftingTimer() {
        return this.craftingTimer;
    }

    public int getCurrentFuel() {
        return this.currentFuel;
    }

    private static boolean canAddItem(SimpleContainer inventory, ItemStack stack) {
        ItemStack existing = inventory.getItem(0);
        if (existing.isEmpty()) {
            return true;
        }
        return ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)stack) && existing.getCount() + stack.getCount() <= existing.getMaxStackSize();
    }

    private static void addItem(SimpleContainer inventory, ItemStack stack) {
        ItemStack existing = inventory.getItem(0);
        if (existing.isEmpty()) {
            inventory.setItem(0, stack);
        } else if (ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)stack)) {
            existing.grow(stack.getCount());
        }
    }
}

