/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.models.bbmodel;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.razz.decocraft.common.ModuleBlocks;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBUnbakedModel;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;

public class BBModelGeometryLoader
implements IGeometryLoader<BBGeometry> {
    public static final BBModelGeometryLoader INSTANCE = new BBModelGeometryLoader();

    public BBGeometry read(JsonObject jsonObject, JsonDeserializationContext context) {
        System.out.println("========================================");
        System.out.println("BBModelGeometryLoader.read() CALLED!");
        System.out.println("JSON: " + jsonObject.toString());
        System.out.println("========================================");
        String decoref = null;
        if (jsonObject.has("decoref")) {
            decoref = jsonObject.get("decoref").getAsString();
            System.out.println("BBModelGeometryLoader: Found decoref in JSON: " + decoref);
        }
        String material = null;
        if (jsonObject.has("material")) {
            String fullMaterial = jsonObject.get("material").getAsString();
            System.out.println("BBModelGeometryLoader.read() called for material: " + fullMaterial);
            material = fullMaterial.contains("/") ? fullMaterial.substring(fullMaterial.lastIndexOf(47) + 1) : (fullMaterial.contains(":") ? fullMaterial.substring(fullMaterial.indexOf(58) + 1) : fullMaterial);
            if (decoref == null) {
                decoref = material;
                System.out.println("BBModelGeometryLoader: No decoref in JSON, using material as decoref: " + decoref);
            }
        } else {
            System.out.println("BBModelGeometryLoader.read() called but NO material field found!");
        }
        BBModel bbModel = null;
        if (decoref != null) {
            String finalMaterial = material;
            bbModel = ModuleBlocks.MAT_TO_BB_MODEL.get(decoref);
            System.out.println("BBModelGeometryLoader: decoref=" + decoref + " -> bbModel=" + (bbModel != null ? "FOUND" : "NULL"));
            if (bbModel == null) {
                System.out.println("BBModelGeometryLoader: ERROR - No BBModel found for decoref=" + decoref);
            }
        } else {
            System.out.println("BBModelGeometryLoader: ERROR - No decoref/material found in JSON");
        }
        System.out.println("BBModelGeometryLoader: Returning BBGeometry with decoref=" + (decoref != null ? decoref : material) + ", bbModel=" + (bbModel != null ? "NOT NULL" : "NULL"));
        return new BBGeometry(decoref != null ? decoref : material, bbModel);
    }

    public static class BBGeometry
    implements IUnbakedGeometry<BBGeometry> {
        private final String materialName;
        private final BBModel bbModel;

        public BBGeometry(String materialName, BBModel bbModel) {
            this.materialName = materialName;
            this.bbModel = bbModel;
        }

        public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
            if (context.hasMaterial("particle")) {
                Material particleMaterial = context.getMaterial("particle");
                TextureAtlasSprite particleSprite = spriteGetter.apply(particleMaterial);
                System.out.println("BBGeometry: Registered particle texture " + String.valueOf(particleSprite.contents().name()) + " for material " + this.materialName);
            } else {
                System.out.println("BBGeometry: NO particle material found for " + this.materialName);
            }
            if (context.hasMaterial("texture0")) {
                Material texture0Material = context.getMaterial("texture0");
                spriteGetter.apply(texture0Material);
            }
            if (this.bbModel == null) {
                System.out.println("BBGeometry.bake(): ERROR - bbModel is NULL for materialName=" + this.materialName + "! Returning null.");
                return null;
            }
            BBUnbakedModel unbakedModel = new BBUnbakedModel(this.materialName, this.bbModel);
            return unbakedModel.bake(baker, spriteGetter, modelState);
        }
    }
}

